/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.zombiehorde.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.mebahel.zombiehorde.MebahelZombieHorde;
import net.mebahel.zombiehorde.util.HordeMemberModConfig;
import net.mebahel.zombiehorde.util.IPatrolData;
import net.mebahel.zombiehorde.util.ModDifficultyState;
import net.mebahel.zombiehorde.util.ZombieHordeModConfig;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_26;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ZombieHordeManager {
    private static final Map<class_3218, Long> lastHordeSpawnTime = new HashMap<class_3218, Long>();
    private static final Map<class_3218, Long> nextScheduledHordeTick = new HashMap<class_3218, Long>();
    private static final int NETHER_CHECK_INTERVAL = 300;
    private static int netherCheckCounter = 0;
    private static final Map<class_3218, Integer> worldDifficultyLevels = new HashMap<class_3218, Integer>();
    private static final Map<class_3218, ServerTickEvents.EndTick> registeredListeners = new HashMap<class_3218, ServerTickEvents.EndTick>();

    public static void register() {
        if (!ZombieHordeModConfig.patrolSpawning) {
            MebahelZombieHorde.LOGGER.info("[Mebahel's Zombie Horde] Zombie horde spawning is disabled in config file.");
            return;
        }
        MebahelZombieHorde.LOGGER.info("[Mebahel's Zombie Horde] Registering zombie horde spawning for mebahel-zombie-horde.");
        ServerWorldEvents.LOAD.register((server, world) -> {
            class_26 stateManager = world.method_17983();
            ModDifficultyState difficultyState = (ModDifficultyState)stateManager.method_17924(ModDifficultyState.TYPE, "zombie_horde_difficulty");
            int difficultyLevel = difficultyState.getDifficultyLevel();
            worldDifficultyLevels.put(world, difficultyLevel);
            lastHordeSpawnTime.put(world, world.method_8510());
            MebahelZombieHorde.LOGGER.info("[Zombie Horde] Loaded difficulty for world " + String.valueOf(world.method_27983().method_29177()));
            ServerTickEvents.EndTick listener = serverTick -> {
                boolean canSpawnNow;
                long currentTick = world.method_8510();
                ZombieHordeModConfig.HordeDelayResult delayInfo = ZombieHordeModConfig.getHordeDelayInTicksWithUnit();
                long delayInTicks = delayInfo.ticks;
                if (!nextScheduledHordeTick.containsKey(world)) {
                    long targetTick;
                    if (delayInfo.unit.equals("day")) {
                        long nextFullDay = (currentTick / 24000L + 1L) * 24000L;
                        long randomOffset = world.field_9229.method_43048(24000);
                        targetTick = nextFullDay + randomOffset;
                    } else {
                        targetTick = currentTick + delayInTicks;
                    }
                    nextScheduledHordeTick.put(world, targetTick);
                    System.out.println("[Zombie Horde] Next horde scheduled for: " + targetTick + " in " + String.valueOf(world.method_27983().method_29177()));
                }
                long scheduledTick = nextScheduledHordeTick.getOrDefault(world, Long.MAX_VALUE);
                boolean bl = canSpawnNow = ZombieHordeModConfig.spawnInDaylight || ZombieHordeManager.isNightTime(world);
                if (canSpawnNow && currentTick >= scheduledTick) {
                    nextScheduledHordeTick.remove(world);
                    for (int i = 0; i < ZombieHordeModConfig.hordeNumber; ++i) {
                        if (world.field_9229.method_43057() <= ZombieHordeModConfig.hordeSpawnChance) {
                            ZombieHordeManager.checkAndSpawnPatrol(world);
                            continue;
                        }
                        System.out.println("[Zombie Horde] Horde didn't spawn this time (chance miss).");
                    }
                }
                if (ZombieHordeModConfig.enableDifficultySystem && world.method_27983() == class_1937.field_25179 && worldDifficultyLevels.get(world) == 1 && ++netherCheckCounter >= 300) {
                    netherCheckCounter = 0;
                    ZombieHordeManager.checkNetherVisit(world, difficultyState);
                }
            };
            ServerTickEvents.END_SERVER_TICK.register((Object)listener);
            registeredListeners.put(world, listener);
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                registeredListeners.remove(world);
                lastHordeSpawnTime.remove(world);
                MebahelZombieHorde.LOGGER.info("[Mebahel's Zombie Horde] World unloaded, event listener removed.");
            }
        });
    }

    public static void forceSpawnPatrol(class_3218 world, class_2338 pos, UUID patrolId) {
        ZombieHordeManager.spawnPatrol(world, pos, patrolId);
    }

    public static Long getNextScheduledHordeTick(class_3218 world) {
        return nextScheduledHordeTick.get(world);
    }

    private static void checkAndSpawnPatrol(class_3218 world) {
        class_2338 spawnPos;
        Random random;
        class_1657 randomPlayer;
        List players = world.method_18456();
        if (!players.isEmpty() && (randomPlayer = (class_1657)players.get((random = new Random()).nextInt(players.size()))).method_5805() && (spawnPos = ZombieHordeManager.findSpawnPosition(world, randomPlayer)) != null) {
            UUID patrolId = UUID.randomUUID();
            ZombieHordeManager.spawnPatrol(world, spawnPos, patrolId);
        }
    }

    private static class_2338 findSpawnPosition(class_3218 world, class_1657 player) {
        int x = 30 + world.field_9229.method_43048(30);
        int z = 30 + world.field_9229.method_43048(30);
        if (world.field_9229.method_43056()) {
            x = -x;
        }
        if (world.field_9229.method_43056()) {
            z = -z;
        }
        class_2338 base = player.method_24515().method_10069(x, 0, z);
        return new class_2338(base.method_10263(), player.method_24515().method_10264(), base.method_10260());
    }

    private static void checkNetherVisit(class_3218 world, ModDifficultyState difficultyState) {
        List players = world.method_18456();
        for (class_3222 player : players) {
            if (!player.method_14236().method_12882(world.method_8503().method_3851().method_12896(class_2960.method_60655((String)"minecraft", (String)"nether/root"))).method_740()) continue;
            int difficultyLevel = 2;
            worldDifficultyLevels.put(world, difficultyLevel);
            difficultyState.setDifficultyLevel(difficultyLevel);
            System.out.println("[Mebahel's Zombie Horde] Difficulty increased to 2 due to Nether visit by " + player.method_5477().getString());
            break;
        }
    }

    private static boolean isNightTime(class_3218 world) {
        return !world.method_8597().method_29960() && !world.method_8530();
    }

    private static HordeMemberModConfig.HordeComposition getRandomHordeComposition(Random random, class_3218 world) {
        String currentDimension = world.method_27983().method_29177().toString();
        List<HordeMemberModConfig.HordeComposition> eligible = HordeMemberModConfig.hordeCompositions.stream().filter(comp -> comp.dimensions.contains(currentDimension)).toList();
        if (eligible.isEmpty()) {
            System.err.println("[Mebahel's Zombie Horde] No eligible horde compositions for dimension: " + currentDimension);
            return null;
        }
        int totalWeight = eligible.stream().mapToInt(c -> c.weight).sum();
        int randomValue = random.nextInt(totalWeight);
        for (HordeMemberModConfig.HordeComposition comp2 : eligible) {
            if ((randomValue -= comp2.weight) >= 0) continue;
            return comp2;
        }
        return eligible.get(0);
    }

    private static class_1299<?> getRandomEntityTypeFromComposition(Random random, HordeMemberModConfig.HordeComposition composition) {
        int totalWeight = composition.mobTypes.stream().mapToInt(mobType -> mobType.weight).sum();
        int randomValue = random.nextInt(totalWeight);
        for (HordeMemberModConfig.HordeMobType mobType2 : composition.mobTypes) {
            if ((randomValue -= mobType2.weight) >= 0) continue;
            class_2960 entityId = class_2960.method_60654((String)mobType2.id);
            return class_7923.field_41177.method_17966(entityId).orElse(null);
        }
        return null;
    }

    private static void spawnPatrol(class_3218 world, class_2338 pos, UUID patrolId) {
        HordeMemberModConfig.HordeComposition composition;
        Random random = new Random();
        class_2338 playerGroundPos = ZombieHordeManager.findSafeSpawnPosition(world, pos);
        class_2338 distantTarget = ZombieHordeManager.setRandomPatrolTarget(world, playerGroundPos);
        int difficultyLevel = worldDifficultyLevels.getOrDefault(world, 1);
        int numFollowers = 4 + 2 * difficultyLevel + random.nextInt(1 + 2 * difficultyLevel);
        if (ZombieHordeModConfig.randomNumberHordeReinforcements > 0) {
            int reinforcement = random.nextInt(ZombieHordeModConfig.randomNumberHordeReinforcements);
            numFollowers += reinforcement;
            System.out.printf("[Mebahel's Zombie Horde] The Horde has been reinforced by %d Zombies.%n", reinforcement);
        }
        if ((composition = ZombieHordeManager.getRandomHordeComposition(random, world)) == null) {
            System.err.println("[Mebahel's Zombie Horde] No valid horde composition found for this dimension. Skipping spawn.");
            return;
        }
        List<class_2338> validPositions = ZombieHordeManager.findValidSpawnPositionsAround(world, playerGroundPos, 8);
        if (validPositions.isEmpty()) {
            System.err.println("[Mebahel's Zombie Horde] \u274c No valid spawn positions found near: " + String.valueOf(playerGroundPos));
            return;
        }
        class_2338 leaderPos = validPositions.remove(random.nextInt(validPositions.size()));
        ZombieHordeManager.spawnPatrolLeader(composition, world, leaderPos, distantTarget, random, patrolId, difficultyLevel);
        int remaining = Math.min(numFollowers, validPositions.size());
        for (int i = 0; i < remaining; ++i) {
            class_2338 spawnPos = validPositions.remove(random.nextInt(validPositions.size()));
            ZombieHordeManager.spawnPatrolMember(composition, world, 1, spawnPos, distantTarget, random, patrolId, difficultyLevel);
        }
        if (ZombieHordeModConfig.showHordeSpawningMessage) {
            String coords = leaderPos.method_10263() + " " + leaderPos.method_10264() + " " + leaderPos.method_10260();
            class_5250 clickableCoords = class_2561.method_43470((String)("[" + coords + "]")).method_10862(class_2583.field_24360.method_10977(class_124.field_1075).method_10958(new class_2558(class_2558.class_2559.field_11750, "/tp @s " + coords)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to teleport"))));
            class_5250 finalMsg = class_2561.method_43470((String)"A horde has spawned at : ").method_10852((class_2561)clickableCoords).method_27693("!");
            for (class_3222 p : world.method_18456()) {
                p.method_7353((class_2561)finalMsg, false);
            }
        }
    }

    private static List<class_2338> findValidSpawnPositionsAround(class_3218 world, class_2338 center, int radius) {
        ArrayList<class_2338> validPositions = new ArrayList<class_2338>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double distance = Math.sqrt(dx * dx + dz * dz);
                if (distance > (double)radius) continue;
                class_2338 candidate = center.method_10069(dx, 0, dz);
                class_2338 below = candidate.method_10074();
                class_2338 above = candidate.method_10084();
                boolean solidBelow = world.method_8320(below).method_26212((class_1922)world, below);
                boolean airHere = world.method_8320(candidate).method_26215();
                boolean airAbove = world.method_8320(above).method_26215();
                boolean isLiquidHere = world.method_8320(candidate).method_26227().method_15771();
                boolean isLiquidBelow = world.method_8320(below).method_26227().method_15771();
                if (!solidBelow || !airHere || !airAbove || isLiquidHere || isLiquidBelow) continue;
                validPositions.add(candidate);
            }
        }
        return validPositions;
    }

    private static void spawnPatrolLeader(HordeMemberModConfig.HordeComposition composition, class_3218 world, class_2338 groundPos, class_2338 distantTarget, Random random, UUID patrolId, int difficultyLevel) {
        class_1299<?> randomEntityType = ZombieHordeManager.getRandomEntityTypeFromComposition(random, composition);
        if (randomEntityType == null) {
            System.err.println("[Mebahel's Zombie Horde] Error: Invalid or unregistered entity type in horde composition.");
            return;
        }
        class_1297 leader = randomEntityType.method_5883((class_1937)world);
        if (leader == null) {
            System.err.println("[Mebahel's Zombie Horde] Error: Failed to create entity of type " + String.valueOf(randomEntityType));
            return;
        }
        class_2338 leaderPos = ZombieHordeManager.findSafeSpawnPosition(world, groundPos);
        leader.method_5814((double)leaderPos.method_10263() + 0.5, (double)leaderPos.method_10264(), (double)leaderPos.method_10260() + 0.5);
        if (leader instanceof class_1308) {
            class_1308 livingMember = (class_1308)leader;
            livingMember.method_5971();
            if (ZombieHordeModConfig.hordeMemberBonusHealth > 0) {
                livingMember.method_5996(class_5134.field_23716).method_6192((double)(livingMember.method_6063() + (float)ZombieHordeModConfig.hordeMemberBonusHealth));
                livingMember.method_6033(livingMember.method_6063());
            }
        }
        IPatrolData patrolData = (IPatrolData)leader;
        patrolData.setHordeEntityPatrolLeader(true);
        patrolData.setHordeEntityPatrolTarget(distantTarget);
        patrolData.setHordeEntityPatrolling(true);
        patrolData.setHordeEntityPatrolId(patrolId.toString());
        ZombieHordeManager.equipWithGear(leader, random, composition, difficultyLevel);
        world.method_8649(leader);
    }

    private static void spawnPatrolMember(HordeMemberModConfig.HordeComposition composition, class_3218 world, int entityNumber, class_2338 initialPos, class_2338 distantTarget, Random random, UUID patrolId, int difficultyLevel) {
        class_2338 currentSpawnPos = initialPos;
        for (int i = 0; i < entityNumber; ++i) {
            class_1299 randomEntityType = ZombieHordeManager.getRandomEntityTypeFromComposition(random, composition);
            if (randomEntityType == null) {
                randomEntityType = class_1299.field_6051;
                System.err.println("[Mebahel's Zombie Horde] Error: Invalid or unregistered entity type in horde composition.");
                continue;
            }
            class_1297 member = randomEntityType.method_5883((class_1937)world);
            if (member == null) {
                System.err.println("[Mebahel's Zombie Horde] Error: Failed to create entity of type " + String.valueOf(randomEntityType));
                continue;
            }
            class_2338 memberSpawnPos = ZombieHordeManager.findSafeSpawnPosition(world, currentSpawnPos);
            member.method_5814((double)memberSpawnPos.method_10263() + 0.5, (double)memberSpawnPos.method_10264(), (double)memberSpawnPos.method_10260() + 0.5);
            if (member instanceof class_1308) {
                class_1308 livingMember = (class_1308)member;
                livingMember.method_5971();
                if (ZombieHordeModConfig.hordeMemberBonusHealth > 0) {
                    livingMember.method_5996(class_5134.field_23716).method_6192((double)(livingMember.method_6063() + (float)ZombieHordeModConfig.hordeMemberBonusHealth));
                    livingMember.method_6033(livingMember.method_6063());
                }
            }
            IPatrolData patrolData = (IPatrolData)member;
            patrolData.setHordeEntityPatrolTarget(distantTarget);
            patrolData.setHordeEntityPatrolling(true);
            patrolData.setHordeEntityPatrolId(patrolId.toString());
            ZombieHordeManager.equipWithGear(member, random, composition, difficultyLevel);
            world.method_8649(member);
            currentSpawnPos = ZombieHordeManager.getOffsetPosition(currentSpawnPos, random);
        }
    }

    private static class_2338 findSafeSpawnPosition(class_3218 world, class_2338 pos) {
        boolean airAbove;
        boolean solidBelow;
        class_2338 check;
        int y;
        boolean isCeilingWorld = world.method_8597().comp_643();
        int playerY = pos.method_10264();
        int maxAllowedY = isCeilingWorld ? 122 : world.method_31600() - 1;
        int startY = Math.min(playerY, maxAllowedY);
        int minY = world.method_31607();
        System.out.println("[Zombie Horde][DEBUG] Finding safe spawn position in world: " + String.valueOf(world.method_27983().method_29177()));
        System.out.println("[Zombie Horde][DEBUG] hasCeiling = " + isCeilingWorld + ", startY = " + startY + ", maxY = " + maxAllowedY + ", minY = " + minY);
        for (y = startY; y <= maxAllowedY; ++y) {
            check = new class_2338(pos.method_10263(), y, pos.method_10260());
            solidBelow = !world.method_8320(check).method_26215();
            airAbove = world.method_8320(check.method_10084()).method_26215();
            if (!solidBelow || !airAbove) continue;
            System.out.printf("[Zombie Horde][DEBUG] \u2705 Valid upward spawn at Y=%d%n", y + 1);
            return check.method_10084();
        }
        for (y = startY - 1; y >= minY; --y) {
            check = new class_2338(pos.method_10263(), y, pos.method_10260());
            solidBelow = !world.method_8320(check).method_26215();
            airAbove = world.method_8320(check.method_10084()).method_26215();
            if (!solidBelow || !airAbove) continue;
            System.out.printf("[Zombie Horde][DEBUG] \u2705 Valid downward spawn at Y=%d%n", y + 1);
            return check.method_10084();
        }
        System.err.println("[Zombie Horde][WARN] \u274c No valid spawn position found. Using fallback: " + String.valueOf(pos));
        return pos;
    }

    private static class_2338 getOffsetPosition(class_2338 basePos, Random random) {
        int offsetX = 5 + random.nextInt(5);
        int offsetZ = 5 + random.nextInt(5);
        if (random.nextBoolean()) {
            offsetX = -offsetX;
        }
        if (random.nextBoolean()) {
            offsetZ = -offsetZ;
        }
        return basePos.method_10069(offsetX, 0, offsetZ);
    }

    public static class_2338 setRandomPatrolTarget(class_3218 world, class_2338 pos) {
        return ZombieHordeManager.setRandomPatrolTarget(world, pos, 0);
    }

    private static class_2338 setRandomPatrolTarget(class_3218 world, class_2338 pos, int tries) {
        class_2338 roughTargetPos;
        class_2338 finalTargetPos;
        if (tries >= 10) {
            System.err.println("[Mebahel's Zombie Horde] Failed to find valid patrol target after 10 attempts.");
            return pos;
        }
        int x = 150 + world.field_9229.method_43048(110);
        int z = 150 + world.field_9229.method_43048(110);
        if (world.field_9229.method_43056()) {
            x = -x;
        }
        if (world.field_9229.method_43056()) {
            z = -z;
        }
        if ((finalTargetPos = ZombieHordeManager.findTopSolidBlock(world, roughTargetPos = new class_2338(pos.method_10263() + x, world.method_31605(), pos.method_10260() + z))).method_10264() == -64) {
            return ZombieHordeManager.setRandomPatrolTarget(world, pos, tries + 1);
        }
        return finalTargetPos;
    }

    private static class_2338 findTopSolidBlock(class_3218 world, class_2338 pos) {
        return world.method_8598(class_2902.class_2903.field_13203, pos);
    }

    private static HordeMemberModConfig.HordeMobType getMobTypeFromComposition(class_1297 entity, HordeMemberModConfig.HordeComposition composition) {
        String mobId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        for (HordeMemberModConfig.HordeMobType mobType : composition.mobTypes) {
            if (!mobType.id.equals(mobId)) continue;
            return mobType;
        }
        return null;
    }

    private static void equipWithGear(class_1297 entity, Random random, HordeMemberModConfig.HordeComposition composition, int difficultyLevel) {
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)entity;
        float armorChance = 0.06f * (float)difficultyLevel;
        float weaponChance = 0.13f * (float)difficultyLevel;
        if (random.nextFloat() < armorChance) {
            living.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
        }
        if (random.nextFloat() < armorChance) {
            living.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8523));
        }
        if (random.nextFloat() < armorChance) {
            living.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8396));
        }
        if (random.nextFloat() < armorChance) {
            living.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8660));
        }
        if (entity.method_5864() == class_1299.field_6105 || entity.method_5864() == class_1299.field_6117) {
            HordeMemberModConfig.HordeMobType mobType = ZombieHordeManager.getMobTypeFromComposition(entity, composition);
            if (mobType != null && mobType.weapons != null && !mobType.weapons.isEmpty()) {
                double totalChance = mobType.weapons.stream().mapToDouble(w -> w.chance).sum();
                double randomChance = (double)random.nextFloat() * totalChance;
                for (HordeMemberModConfig.WeaponConfig weapon : mobType.weapons) {
                    if (!((randomChance -= (double)weapon.chance) <= 0.0)) continue;
                    class_1799 weaponStack = new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)weapon.itemId)));
                    living.method_5673(class_1304.field_6173, weaponStack);
                    return;
                }
            }
            if (entity.method_5864() == class_1299.field_6105) {
                living.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8399));
            } else if (entity.method_5864() == class_1299.field_6117) {
                living.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8475));
            }
            return;
        }
        HordeMemberModConfig.HordeMobType mobType = ZombieHordeManager.getMobTypeFromComposition(entity, composition);
        if (mobType != null && mobType.weapons != null && !mobType.weapons.isEmpty() && random.nextFloat() < mobType.spawnWithWeaponProbability) {
            double totalChance = mobType.weapons.stream().mapToDouble(w -> w.chance).sum();
            double randomChance = (double)random.nextFloat() * totalChance;
            for (HordeMemberModConfig.WeaponConfig weapon : mobType.weapons) {
                if (!((randomChance -= (double)weapon.chance) <= 0.0)) continue;
                class_1799 weaponStack = new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)weapon.itemId)));
                living.method_5673(class_1304.field_6173, weaponStack);
                return;
            }
        }
    }
}

