/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.zombiehorde.entity.ai;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mebahel.zombiehorde.util.IPatrolData;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2620;
import net.minecraft.class_3218;
import net.minecraft.class_3959;

public class BreakGlassGoal
extends class_1352 {
    private final class_1308 zombie;
    private final boolean hordeMemberBreakFence;
    private final boolean hordeMemberBreakGlass;
    private class_2338 targetGlassBlockPos = null;
    private int glassBreakingProgress = 0;
    private int tickCounter = 0;
    private static final int MAX_GLASS_BREAKING_PROGRESS = 10;
    private static final Map<class_2338, Integer> glassBreakingProgressMap = new HashMap<class_2338, Integer>();

    public BreakGlassGoal(class_1308 zombie, boolean hordeMemberBreakGlass, boolean hordeMemberBreakFence) {
        this.zombie = zombie;
        this.hordeMemberBreakGlass = hordeMemberBreakGlass;
        this.hordeMemberBreakFence = hordeMemberBreakFence;
    }

    public boolean method_6264() {
        if (!this.isPartOfPatrol()) {
            return false;
        }
        class_1309 target = this.zombie.method_5968();
        if (target == null || !target.method_5805()) {
            target = this.findTargetThroughGlass();
            if (target != null) {
                this.zombie.method_5980(target);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean method_6266() {
        class_1309 livingEntity = this.zombie.method_5968();
        return livingEntity != null && livingEntity.method_5805() && (!(livingEntity instanceof class_1657) || !((class_1657)livingEntity).method_7337() && !((class_1657)livingEntity).method_7325());
    }

    public void method_6269() {
        class_1309 target = this.findTargetThroughGlass();
        if (target != null) {
            this.zombie.method_5980(target);
        }
    }

    public void method_6270() {
        this.resetBlockBreakingProgress();
    }

    public void method_6268() {
        class_2338 glassBlockPos;
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            class_1309 target = this.findTargetThroughGlass();
            if (target != null) {
                this.zombie.method_5980(target);
            }
        }
        if ((glassBlockPos = this.findGlassBlockInFrontTopToBottom()) != null) {
            if (!glassBlockPos.equals((Object)this.targetGlassBlockPos)) {
                this.resetBlockBreakingProgress();
                this.targetGlassBlockPos = glassBlockPos;
                this.glassBreakingProgress = 0;
            }
            this.glassBreakingProgress = glassBreakingProgressMap.getOrDefault(this.targetGlassBlockPos, 0) + 1;
            if (this.glassBreakingProgress >= 10) {
                if (this.zombie.method_37908() instanceof class_3218) {
                    ((class_3218)this.zombie.method_37908()).method_8651(this.targetGlassBlockPos, true, (class_1297)this.zombie);
                }
                this.resetBlockBreakingProgress();
            } else {
                glassBreakingProgressMap.put(this.targetGlassBlockPos, this.glassBreakingProgress);
                this.zombie.method_6104(this.zombie.method_6058());
                this.setGlassBreakingProgress(this.targetGlassBlockPos, this.glassBreakingProgress * 10 / 10);
            }
        }
    }

    private void resetBlockBreakingProgress() {
        if (this.targetGlassBlockPos != null) {
            if (this.zombie.method_37908() instanceof class_3218) {
                ((class_3218)this.zombie.method_37908()).method_8503().method_3760().method_14581((class_2596)new class_2620(this.zombie.method_5628(), this.targetGlassBlockPos, -1));
            }
            glassBreakingProgressMap.remove(this.targetGlassBlockPos);
            this.targetGlassBlockPos = null;
            this.glassBreakingProgress = 0;
        }
    }

    private class_2338 findGlassBlockInFrontTopToBottom() {
        class_2338 currentPos = this.zombie.method_24515();
        class_2350 facing = this.zombie.method_5755();
        for (int y = 2; y >= -2; --y) {
            for (int i = 1; i <= 2; ++i) {
                class_2338 pos = currentPos.method_10079(facing, i).method_10086(y);
                if (!this.isGlassOrBreakableBlock(pos)) continue;
                return pos;
            }
        }
        return null;
    }

    private boolean isGlassOrBreakableBlock(class_2338 pos) {
        class_2248 block = this.zombie.method_37908().method_8320(pos).method_26204();
        if (this.hordeMemberBreakGlass && this.hordeMemberBreakFence) {
            return block == class_2246.field_10033 || block == class_2246.field_10285 || block == class_2246.field_10620 || block == class_2246.field_10020 || block == class_2246.field_10299 || block == class_2246.field_10319 || block == class_2246.field_10144 || block == class_2246.field_10132 || block == class_2246.field_37565 || block == class_2246.field_10188 || block == class_2246.field_10291 || block == class_2246.field_10513 || block == class_2246.field_10041 || block == class_2246.field_10457 || block == class_2246.field_10196 || block == class_2246.field_37563;
        }
        if (this.hordeMemberBreakGlass && !this.hordeMemberBreakFence) {
            return block == class_2246.field_10033 || block == class_2246.field_10285;
        }
        if (!this.hordeMemberBreakGlass && this.hordeMemberBreakFence) {
            return block == class_2246.field_10620 || block == class_2246.field_10020 || block == class_2246.field_10299 || block == class_2246.field_10319 || block == class_2246.field_10144 || block == class_2246.field_10132 || block == class_2246.field_37565 || block == class_2246.field_10188 || block == class_2246.field_10291 || block == class_2246.field_10513 || block == class_2246.field_10041 || block == class_2246.field_10457 || block == class_2246.field_10196 || block == class_2246.field_37563;
        }
        return false;
    }

    private void setGlassBreakingProgress(class_2338 pos, int progress) {
        if (this.zombie.method_37908() instanceof class_3218) {
            ((class_3218)this.zombie.method_37908()).method_8503().method_3760().method_14581((class_2596)new class_2620(this.zombie.method_5628(), pos, progress));
        }
    }

    private class_1309 findTargetThroughGlass() {
        class_238 detectionBox = this.zombie.method_5829().method_1014(24.0);
        List potentialTargets = this.zombie.method_37908().method_8390(class_1309.class, detectionBox, entity -> entity instanceof class_1657);
        for (class_1309 potentialTarget : potentialTargets) {
            if (!this.canSeeThroughGlassOrBreakable(potentialTarget)) continue;
            return potentialTarget;
        }
        return null;
    }

    private boolean canSeeThroughGlassOrBreakable(class_1309 target) {
        class_243 startPos = this.zombie.method_33571();
        class_243 endPos = target.method_33571();
        class_3959 context = new class_3959(startPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.zombie);
        class_2338 hitPos = this.zombie.method_37908().method_17742(context).method_17777();
        class_2248 hitBlock = this.zombie.method_37908().method_8320(hitPos).method_26204();
        return this.isGlassOrBreakableBlock(hitPos);
    }

    private boolean isPartOfPatrol() {
        return ((IPatrolData)this.zombie).isHordeEntityPatrolling();
    }
}

