/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.zombiehorde.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.mebahel.zombiehorde.util.IPatrolData;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class ModHordeGoal
extends class_1352 {
    private final class_1308 entity;
    private final double baseSpeed;
    private final double leaderSpeed;
    private final double followSpeed;
    private class_1308 assignedLeader;

    public ModHordeGoal(class_1308 entity, double leaderSpeed, double followSpeed) {
        if (!(entity instanceof IPatrolData)) {
            throw new IllegalArgumentException("Entity must implement IPatrolData");
        }
        this.entity = entity;
        this.baseSpeed = Objects.requireNonNull(this.entity.method_5996(class_5134.field_23719)).method_6201();
        this.leaderSpeed = leaderSpeed;
        this.followSpeed = followSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.assignedLeader = null;
    }

    public void method_6269() {
        super.method_6269();
        Objects.requireNonNull(this.entity.method_5996(class_5134.field_23719)).method_6192(0.27);
    }

    public void method_6270() {
        super.method_6270();
        Objects.requireNonNull(this.entity.method_5996(class_5134.field_23719)).method_6192(this.baseSpeed);
    }

    public boolean method_6264() {
        IPatrolData patrolData = (IPatrolData)this.entity;
        if (!patrolData.isHordeEntityPatrolling()) {
            return false;
        }
        if (this.entity.method_5968() != null && this.entity.method_5968().method_5805()) {
            this.shareTargetWithHorde(this.entity.method_5968());
            return false;
        }
        if (this.assignedLeader == null || !this.assignedLeader.method_5805()) {
            this.assignedLeader = this.findNewLeader();
        }
        return this.assignedLeader != null && this.assignedLeader.method_5805();
    }

    public boolean method_6266() {
        class_1309 target = this.entity.method_5968();
        if (target != null && target.method_5805()) {
            this.shareTargetWithHorde(target);
            this.method_6270();
            return false;
        }
        return true;
    }

    public void method_6268() {
        boolean hasNearbyPlayer = this.entity.method_37908().method_18456().stream().anyMatch(player -> player.method_5649(this.entity.method_23317(), this.entity.method_23318(), this.entity.method_23321()) <= 60000.0);
        if (!hasNearbyPlayer && this.entity.field_6012 > 20) {
            this.entity.method_31472();
            return;
        }
        IPatrolData patrolData = (IPatrolData)this.entity;
        class_1408 navigation = this.entity.method_5942();
        if (navigation.method_6357()) {
            class_2338 targetPos;
            class_1309 currentTarget;
            if (this.assignedLeader == null || !this.assignedLeader.method_5805()) {
                this.assignedLeader = this.findNewLeader();
            }
            class_1309 class_13092 = currentTarget = this.assignedLeader != null ? this.assignedLeader.method_5968() : null;
            if (currentTarget != null && currentTarget.method_5805()) {
                this.shareTargetWithHorde(currentTarget);
                return;
            }
            class_2338 class_23382 = targetPos = this.assignedLeader != null ? ((IPatrolData)this.assignedLeader).getHordeEntityPatrolTarget() : null;
            if (!patrolData.isHordeEntityPatrolLeader() && targetPos != null && !targetPos.equals((Object)patrolData.getHordeEntityPatrolTarget())) {
                patrolData.setHordeEntityPatrolTarget(targetPos);
            }
            if (targetPos != null) {
                class_11 path = navigation.method_6348(targetPos, 0);
                if (path != null) {
                    navigation.method_6334(path, patrolData.isHordeEntityPatrolLeader() ? this.leaderSpeed : this.followSpeed);
                } else if (patrolData.isHordeEntityPatrolLeader()) {
                    class_2338 newTarget = ModHordeGoal.setRandomPatrolTarget((class_3218)this.entity.method_37908(), this.entity.method_24515());
                    patrolData.setHordeEntityPatrolTarget(newTarget);
                }
            } else {
                this.wander();
            }
        }
    }

    public static class_2338 setRandomPatrolTarget(class_3218 world, class_2338 pos) {
        class_5819 random = world.field_9229;
        int x = 150 + random.method_43048(150);
        int z = 150 + random.method_43048(150);
        if (random.method_43056()) {
            x = -x;
        }
        if (random.method_43056()) {
            z = -z;
        }
        class_2338 roughTargetPos = new class_2338(pos.method_10263() + x, world.method_31605(), pos.method_10260() + z);
        return ModHordeGoal.findTopSolidBlock(world, roughTargetPos);
    }

    private static class_2338 findTopSolidBlock(class_3218 world, class_2338 pos) {
        return world.method_8598(class_2902.class_2903.field_13203, pos);
    }

    private class_1308 findNewLeader() {
        List patrolMembers = this.entity.method_37908().method_8390(class_1308.class, this.entity.method_5829().method_1014(64.0), e -> e instanceof IPatrolData && ((IPatrolData)e).isHordeEntityPatrolling() && ((IPatrolData)e).isHordeEntityPartOfSamePatrol((IPatrolData)this.entity));
        for (class_1308 member : patrolMembers) {
            if (!member.method_5805() || !((IPatrolData)member).isHordeEntityPatrolLeader()) continue;
            return member;
        }
        for (class_1308 member : patrolMembers) {
            if (!member.method_5805() || ((IPatrolData)member).isHordeEntityPatrolLeader()) continue;
            ((IPatrolData)member).setHordeEntityPatrolLeader(true);
            return member;
        }
        return null;
    }

    private void shareTargetWithHorde(class_1309 target) {
        List patrolMembers = this.entity.method_37908().method_8390(class_1308.class, this.entity.method_5829().method_1014(64.0), e -> e instanceof IPatrolData && ((IPatrolData)e).isHordeEntityPatrolling() && ((IPatrolData)e).isHordeEntityPartOfSamePatrol((IPatrolData)this.entity));
        for (class_1308 member : patrolMembers) {
            if (member.method_5968() == null) {
                member.method_5980(target);
                continue;
            }
            if (member.method_5968().method_5805()) continue;
            member.method_5980(target);
        }
    }

    private void wander() {
        class_5819 random = this.entity.method_6051();
        class_2338 blockPos = this.entity.method_37908().method_8598(class_2902.class_2903.field_13203, this.entity.method_24515().method_10069(-8 + random.method_43048(16), 0, -8 + random.method_43048(16)));
        this.entity.method_5942().method_6337((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), this.leaderSpeed);
    }
}

