/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.zombiehorde.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class HordeMemberModConfig {
    private static final String CONFIG_FILE_NAME = "mebahel-zombie-hordemob_type_config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static List<HordeComposition> hordeCompositions = List.of(new HordeComposition(1, List.of("minecraft:overworld"), List.of(new HordeMobType("minecraft:zombie", 30, 0.15f, List.of(new WeaponConfig("minecraft:iron_sword", 0.5f), new WeaponConfig("minecraft:stone_sword", 0.3f), new WeaponConfig("minecraft:wooden_sword", 0.2f))))));

    public static void loadConfig(File configDir) {
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        boolean updated = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (data == null || data.hordeCompositions == null) {
                    System.err.println("[Mebahel's Zombie Horde] Config file is malformed. Using default configuration.");
                    data = HordeMemberModConfig.createDefaultConfig();
                    updated = true;
                } else if (data.hordeCompositions.isEmpty()) {
                    System.err.println("[Mebahel's Zombie Horde] Config file is empty. Skipping loading. Please define at least one horde composition.");
                    return;
                }
                hordeCompositions = data.hordeCompositions;
                for (HordeComposition composition : data.hordeCompositions) {
                    if (composition.dimensions == null || composition.dimensions.isEmpty()) {
                        composition.dimensions = List.of("minecraft:overworld");
                        updated = true;
                        System.out.println("[Mebahel's Zombie Horde] Added default dimension 'minecraft:overworld' to a horde composition");
                    }
                    for (HordeMobType mobType : composition.mobTypes) {
                        if (!(mobType.spawnWithWeaponProbability <= 0.0f)) continue;
                        mobType.spawnWithWeaponProbability = 0.15f;
                        updated = true;
                        System.out.println("[Mebahel's Zombie Horde] Added missing spawnWithWeaponProbability=0.15 to " + mobType.id);
                    }
                }
                System.out.println("-------------------[MEBAHEL'S ZOMBIE HORDE]-------------------");
                System.out.println("[Mebahel's Zombie Horde] Loaded " + hordeCompositions.size() + " horde composition(s):");
                int hordeIndex = 1;
                for (HordeComposition composition : hordeCompositions) {
                    System.out.println("  Horde #" + hordeIndex + " (weight: " + composition.weight + "): Dimensions=" + String.valueOf(composition.dimensions));
                    for (HordeMobType mobType : composition.mobTypes) {
                        System.out.println("    - " + mobType.id + " (weight: " + mobType.weight + ")");
                        if (mobType.weapons == null || mobType.weapons.isEmpty()) continue;
                        for (WeaponConfig weapon : mobType.weapons) {
                            System.out.println("        * Weapon: " + weapon.itemId + " (chance: " + weapon.chance * 100.0f + "%)");
                        }
                    }
                    ++hordeIndex;
                }
                System.out.println("-------------------[MEBAHEL'S ZOMBIE HORDE]-------------------");
            }
            catch (Exception e) {
                System.err.println("[Mebahel's Zombie Horde] Failed to load config file. Using default configuration: " + e.getMessage());
                hordeCompositions = HordeMemberModConfig.createDefaultConfig().hordeCompositions;
                updated = true;
            }
        } else {
            System.out.println("[Mebahel's Zombie Horde] Config file not found. Creating a new one with default configuration.");
            hordeCompositions = HordeMemberModConfig.createDefaultConfig().hordeCompositions;
            updated = true;
        }
        if (updated) {
            HordeMemberModConfig.saveConfig(configDir);
        }
    }

    private static ConfigData createDefaultConfig() {
        return new ConfigData(List.of(new HordeComposition(1, List.of("minecraft:overworld"), List.of(new HordeMobType("minecraft:zombie", 30, 0.15f, List.of(new WeaponConfig("minecraft:iron_sword", 0.65f), new WeaponConfig("minecraft:stone_sword", 0.35f)))))));
    }

    public static void saveConfig(File configDir) {
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        ConfigData data = new ConfigData(hordeCompositions);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }

    private static class ConfigData {
        List<HordeComposition> hordeCompositions;

        ConfigData(List<HordeComposition> hordeCompositions) {
            this.hordeCompositions = hordeCompositions;
        }
    }

    public static class HordeComposition {
        public int weight;
        public List<String> dimensions;
        public List<HordeMobType> mobTypes;

        HordeComposition(int weight, List<String> dimensions, List<HordeMobType> mobTypes) {
            this.weight = weight;
            this.dimensions = dimensions;
            this.mobTypes = mobTypes;
        }
    }

    public static class HordeMobType {
        public String id;
        public int weight;
        public float spawnWithWeaponProbability;
        public List<WeaponConfig> weapons;

        HordeMobType(String id, int weight, float spawnWithWeaponProbability, List<WeaponConfig> weapons) {
            this.id = id;
            this.weight = weight;
            this.spawnWithWeaponProbability = spawnWithWeaponProbability;
            this.weapons = weapons;
        }
    }

    public static class WeaponConfig {
        public String itemId;
        public float chance;

        WeaponConfig(String itemId, float chance) {
            this.itemId = itemId;
            this.chance = chance;
        }
    }
}

