/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.zombiehorde.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class ZombieHordeModConfig {
    private static final String CONFIG_FILE_NAME = "mebahel-zombie-horde_config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static boolean spawnInDaylight = true;
    public static boolean enableDifficultySystem = true;
    public static boolean patrolSpawning = true;
    public static int hordeSpawnDelayAmount = 15;
    public static String hordeSpawnDelayUnit = "minute";
    public static float hordeSpawnChance = 1.0f;
    public static int randomNumberHordeReinforcements = 0;
    public static int hordeNumber = 1;
    public static int hordeMemberBonusHealth = 0;
    public static boolean hordeMemberBreakGlass = true;
    public static boolean hordeMemberBreakFence = true;
    public static boolean showHordeSpawningMessage = true;

    public static void loadConfig(File configDir) {
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        boolean updated = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (data.spawnInDayLight == null) {
                    data.spawnInDayLight = true;
                    updated = true;
                }
                if (data.enableDifficultySystem == null) {
                    data.enableDifficultySystem = true;
                    updated = true;
                }
                if (data.hordeSpawning == null) {
                    data.hordeSpawning = true;
                    updated = true;
                }
                if (data.hordeSpawnDelay == null) {
                    data.hordeSpawnDelay = List.of(Integer.valueOf(15), "minute");
                    updated = true;
                } else if (data.hordeSpawnDelay instanceof Number) {
                    int legacyValue = ((Number)data.hordeSpawnDelay).intValue();
                    data.hordeSpawnDelay = List.of(Integer.valueOf(legacyValue), "minute");
                    hordeSpawnDelayAmount = legacyValue;
                    hordeSpawnDelayUnit = "minute";
                    updated = true;
                } else {
                    List list;
                    Object legacyValue = data.hordeSpawnDelay;
                    if (legacyValue instanceof List && (list = (List)legacyValue).size() == 2) {
                        try {
                            Object amount = list.get(0);
                            Object unit = list.get(1);
                            if (!(amount instanceof Number) || !(unit instanceof String)) {
                                throw new IllegalArgumentException();
                            }
                            int amt = ((Number)amount).intValue();
                            String unt = ((String)unit).toLowerCase();
                            if (amt < 1 || !unt.equals("minute") && !unt.equals("day")) {
                                throw new IllegalArgumentException();
                            }
                            hordeSpawnDelayAmount = amt;
                            hordeSpawnDelayUnit = unt;
                        }
                        catch (Exception e) {
                            System.err.println("[Zombie Horde] Invalid 'hordeSpawnDelay' format. Resetting to [15, \"minute\"]");
                            data.hordeSpawnDelay = List.of(Integer.valueOf(15), "minute");
                            hordeSpawnDelayAmount = 15;
                            hordeSpawnDelayUnit = "minute";
                            updated = true;
                        }
                    } else {
                        System.err.println("[Zombie Horde] Invalid 'hordeSpawnDelay' value. Resetting.");
                        data.hordeSpawnDelay = List.of(Integer.valueOf(15), "minute");
                        hordeSpawnDelayAmount = 15;
                        hordeSpawnDelayUnit = "minute";
                        updated = true;
                    }
                }
                if (data.hordeSpawnChance == null || data.hordeSpawnChance.floatValue() < 0.0f || data.hordeSpawnChance.floatValue() > 1.0f) {
                    data.hordeSpawnChance = Float.valueOf(1.0f);
                    updated = true;
                }
                if (data.randomNumberHordeReinforcements == null || data.randomNumberHordeReinforcements < 0 || data.randomNumberHordeReinforcements > 10) {
                    data.randomNumberHordeReinforcements = 0;
                    updated = true;
                }
                if (data.hordeNumber == null || data.hordeNumber < 1 || data.hordeNumber > 20) {
                    data.hordeNumber = 1;
                    updated = true;
                }
                if (data.hordeMemberBonusHealth == null || data.hordeMemberBonusHealth < 0 || data.hordeMemberBonusHealth > 40) {
                    data.hordeMemberBonusHealth = 0;
                    updated = true;
                }
                if (data.hordeMemberBreakGlass == null) {
                    data.hordeMemberBreakGlass = true;
                    updated = true;
                }
                if (data.hordeMemberBreakFence == null) {
                    data.hordeMemberBreakFence = true;
                    updated = true;
                }
                if (data.showHordeSpawningMessage == null) {
                    data.showHordeSpawningMessage = true;
                    updated = true;
                }
                spawnInDaylight = data.spawnInDayLight;
                enableDifficultySystem = data.enableDifficultySystem;
                patrolSpawning = data.hordeSpawning;
                hordeSpawnChance = data.hordeSpawnChance.floatValue();
                randomNumberHordeReinforcements = data.randomNumberHordeReinforcements;
                hordeNumber = data.hordeNumber;
                hordeMemberBonusHealth = data.hordeMemberBonusHealth;
                hordeMemberBreakGlass = data.hordeMemberBreakGlass;
                hordeMemberBreakFence = data.hordeMemberBreakFence;
                showHordeSpawningMessage = data.showHordeSpawningMessage;
                if (updated) {
                    ZombieHordeModConfig.saveConfig(configDir);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to load config file: " + e.getMessage());
            }
        } else {
            ZombieHordeModConfig.saveConfig(configDir);
        }
    }

    public static void saveConfig(File configDir) {
        File configFile = new File(configDir, CONFIG_FILE_NAME);
        ConfigData data = new ConfigData(spawnInDaylight, enableDifficultySystem, patrolSpawning, List.of(Integer.valueOf(hordeSpawnDelayAmount), hordeSpawnDelayUnit), Float.valueOf(hordeSpawnChance), randomNumberHordeReinforcements, hordeNumber, hordeMemberBonusHealth, hordeMemberBreakGlass, hordeMemberBreakFence, showHordeSpawningMessage);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config file: " + e.getMessage());
        }
    }

    public static HordeDelayResult getHordeDelayInTicksWithUnit() {
        String unit;
        int base = hordeSpawnDelayAmount;
        return switch (unit = hordeSpawnDelayUnit) {
            case "minute", "minutes" -> new HordeDelayResult((long)(base * 20) * 60L, "minute");
            case "day", "days" -> new HordeDelayResult((long)base * 24000L, "day");
            default -> new HordeDelayResult(18000L, "minute");
        };
    }

    private static class ConfigData {
        Boolean spawnInDayLight;
        Boolean enableDifficultySystem;
        Boolean hordeSpawning;
        Object hordeSpawnDelay;
        Float hordeSpawnChance;
        Integer randomNumberHordeReinforcements;
        Integer hordeNumber;
        Integer hordeMemberBonusHealth;
        Boolean hordeMemberBreakGlass;
        Boolean hordeMemberBreakFence;
        Boolean showHordeSpawningMessage;

        ConfigData(Boolean spawnInDayLight, Boolean enableDifficultySystem, Boolean hordeSpawning, List<Object> hordeSpawnDelay, Float hordeSpawnChance, Integer randomNumberHordeReinforcements, Integer hordeNumber, Integer hordeMemberBonusHealth, Boolean hordeMemberBreakGlass, Boolean hordeMemberBreakFence, Boolean showHordeSpawningMessage) {
            this.spawnInDayLight = spawnInDayLight;
            this.enableDifficultySystem = enableDifficultySystem;
            this.hordeSpawning = hordeSpawning;
            this.hordeSpawnDelay = hordeSpawnDelay;
            this.hordeSpawnChance = hordeSpawnChance;
            this.randomNumberHordeReinforcements = randomNumberHordeReinforcements;
            this.hordeNumber = hordeNumber;
            this.hordeMemberBonusHealth = hordeMemberBonusHealth;
            this.hordeMemberBreakGlass = hordeMemberBreakGlass;
            this.hordeMemberBreakFence = hordeMemberBreakFence;
            this.showHordeSpawningMessage = showHordeSpawningMessage;
        }
    }

    public static class HordeDelayResult {
        public final long ticks;
        public final String unit;

        public HordeDelayResult(long ticks, String unit) {
            this.ticks = ticks;
            this.unit = unit;
        }
    }
}

