/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge;

import javax.annotation.Nullable;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.config.Settings;
import me.dexrn.rrdiscordbridge.game.Advancement;
import me.dexrn.rrdiscordbridge.impls.BroadcastPlayer;
import me.dexrn.rrdiscordbridge.interfaces.ICancellable;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import net.dv8tion.jda.api.entities.MessageEmbed;

public class Events {
    public static void onPlayerAchievement(Advancement.Type type, IPlayer player, String achievement, @Nullable String description) {
        String str = achievement.startsWith("[") && achievement.endsWith("]") ? achievement.substring(1, achievement.length() - 1) : achievement;
        Events.onPlayerAchievement(type, player, achievement, description, str);
    }

    public static void onPlayerAchievement(Advancement.Type type, IPlayer player, String achievement, @Nullable String description, String wikiName) {
        String str = achievement.startsWith("[") && achievement.endsWith("]") ? achievement.substring(1, achievement.length() - 1) : achievement;
        String wiki = wikiName.replaceAll(" ", "_");
        switch (type) {
            case ACHIEVEMENT: {
                str = String.format("%s has just earned the achievement [[%s]](<https://minecraft.wiki/w/Achievement/Java_Edition#%s>)", player.getName(), str, wiki);
                break;
            }
            case ADVANCEMENT: {
                str = String.format("%s has made the advancement [[%s]](<https://minecraft.wiki/w/Advancement#%s>)", player.getName(), str, wiki);
                break;
            }
            case GOAL: {
                str = String.format("%s has reached the goal [[%s]](<https://minecraft.wiki/w/Advancement#%s>)", player.getName(), str, wiki);
                break;
            }
            case CHALLENGE: {
                str = String.format("%s has completed the challenge [[%s]](<https://minecraft.wiki/w/Advancement#%s>)", player.getName(), str, wiki);
            }
        }
        RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_ACHIEVEMENT, player.getName(), type == Advancement.Type.ACHIEVEMENT ? "Achievement Get!" : "Advancement Get!", str, type == Advancement.Type.CHALLENGE ? RRDiscordBridge.instance.getSettings().colorPalette.playerChallenge : RRDiscordBridge.instance.getSettings().colorPalette.playerAchievement, null, description);
    }

    public static void onPlayerJoin(IPlayer player) {
        if (RRDiscordBridge.instance.getSupportedFeatures().canQueryPlayerHasJoinedBefore() && !player.hasPlayedBefore()) {
            RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_JOIN, player.getName(), String.format("%s joined the game for the first time.", player.getName()), null, RRDiscordBridge.instance.getSettings().colorPalette.playerFirstJoin, null, null);
        } else {
            RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_JOIN, player.getName(), String.format("%s joined the game.", player.getName()), null, RRDiscordBridge.instance.getSettings().colorPalette.playerJoin, null, null);
        }
        RRDiscordBridge.instance.getBot().setPlayerCount(RRDiscordBridge.instance.getServer().getOnlinePlayers().length);
    }

    public static void onPlayerLeave(IPlayer player) {
        if (RRDiscordBridge.instance == null) {
            return;
        }
        RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_LEAVE, player.getName(), String.format("%s left the game.", player.getName()), null, RRDiscordBridge.instance.getSettings().colorPalette.playerLeave, null, null);
        RRDiscordBridge.instance.getBot().setPlayerCount(RRDiscordBridge.instance.getServer().getOnlinePlayers().length - 1);
    }

    public static void onPlayerKick(IPlayer player, String reason) {
        if (RRDiscordBridge.instance == null) {
            return;
        }
        RRDiscordBridge.instance.getBot().setPlayerCount(RRDiscordBridge.instance.getServer().getOnlinePlayers().length - 1);
        RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_KICK, player.getName(), String.format("%s was kicked.", player.getName()), reason, RRDiscordBridge.instance.getSettings().colorPalette.playerKick, null, null);
    }

    public static void onPlayerCommand(IPlayer player, String command) {
        if (command.toLowerCase().startsWith("/me ") && command.length() > 4 && RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.ME_COMMAND)) {
            RRDiscordBridge.instance.getBot().sendPlayerMessage(Settings.Events.ME_COMMAND, player, String.format("_%s %s_", player.getName(), command.substring(4)));
        }
        if (command.toLowerCase().startsWith("/say ") && command.length() > 5 && RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.SAY_BROADCAST) && player.isOperator()) {
            RRDiscordBridge.instance.getBot().sendPlayerMessage(Settings.Events.SAY_BROADCAST, new BroadcastPlayer(), RRDiscordBridge.instance.getSettings().broadcastSkinName, command.substring(5));
        }
    }

    public static void onServerCommand(String command) {
        if (command.toLowerCase().startsWith("say ") && command.length() > 4 && RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.SAY_BROADCAST)) {
            RRDiscordBridge.instance.getBot().sendPlayerMessage(Settings.Events.SAY_BROADCAST, new BroadcastPlayer(), RRDiscordBridge.instance.getSettings().broadcastSkinName, command.substring(4));
        }
    }

    public static void onChatMessage(IPlayer sender, String message, ICancellable event) {
        if (RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.PLAYER_CHAT)) {
            RRDiscordBridge.instance.getBot().sendPlayerMessage(sender, message, event);
        }
    }

    public static void onPlayerDeath(IPlayer player, String message) {
        if (message != null && !message.trim().isEmpty()) {
            if (player == null) {
                RRDiscordBridge.instance.getBot().sendEvent(Settings.Events.PLAYER_DEATH, new MessageEmbed.AuthorInfo(message, null, null, null), null, RRDiscordBridge.instance.getSettings().colorPalette.playerDeath, null);
            } else {
                RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_DEATH, player.getName(), message, null, RRDiscordBridge.instance.getSettings().colorPalette.playerDeath, null, null);
            }
        } else if (player != null) {
            RRDiscordBridge.instance.getBot().sendPlayerEvent(Settings.Events.PLAYER_DEATH, player.getName(), String.format("%s died", player.getName()), null, RRDiscordBridge.instance.getSettings().colorPalette.playerDeath, null, null);
        }
    }
}

