/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Logger;
import me.dexrn.rrdiscordbridge.SupportedFeatures;
import me.dexrn.rrdiscordbridge.command.CommandRegistry;
import me.dexrn.rrdiscordbridge.command.commands.BroadcastCommand;
import me.dexrn.rrdiscordbridge.command.commands.ChatExtensionsCommand;
import me.dexrn.rrdiscordbridge.command.commands.DiscordLinkCommand;
import me.dexrn.rrdiscordbridge.command.commands.ReloadCommand;
import me.dexrn.rrdiscordbridge.config.ConfigDirectory;
import me.dexrn.rrdiscordbridge.config.Settings;
import me.dexrn.rrdiscordbridge.discord.DiscordBot;
import me.dexrn.rrdiscordbridge.extension.BridgeExtensionManager;
import me.dexrn.rrdiscordbridge.impls.logging.JavaLogger;
import me.dexrn.rrdiscordbridge.interfaces.ILogger;
import me.dexrn.rrdiscordbridge.interfaces.IServer;
import me.scarsz.jdaappender.ChannelLoggingHandler;
import me.scarsz.jdaappender.LogLevel;
import me.scarsz.jdaappender.adapter.JavaLoggingAdapter;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;

public class RRDiscordBridge {
    public static RRDiscordBridge instance;
    public static final String MOD_ID = "rrdiscordbridge";
    private static long serverStartTime;
    private final IServer server;
    public static ILogger logger;
    public ChannelLoggingHandler logHandler;
    private final CommandRegistry commandRegistry;
    private Settings settings;
    private BridgeExtensionManager extensions;
    private SupportedFeatures features;
    private ScheduledExecutorService playerCountUpdater;
    public static ConfigDirectory configDir;
    private DiscordBot bot;

    public RRDiscordBridge(IServer server, ILogger logger, ConfigDirectory dir) {
        configDir = dir;
        this.server = server;
        RRDiscordBridge.logger = logger;
        this.commandRegistry = new CommandRegistry().register(new ChatExtensionsCommand()).register(new DiscordLinkCommand()).register(new BroadcastCommand()).register(new ReloadCommand());
        try {
            this.settings = new Settings(Paths.get(configDir.getPath(), "config.json")).load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            serverStartTime = System.currentTimeMillis();
        }
    }

    public static long getServerStartTime() {
        return serverStartTime;
    }

    public RRDiscordBridge initialize() {
        try {
            logger.info("Starting Discord relay bot");
            this.bot = new DiscordBot();
            this.bot.start();
            if (!this.settings.consoleChannelId.isEmpty()) {
                logger.info("Registering console channel handler");
                TextChannel c = this.bot.jda.getTextChannelById(this.settings.consoleChannelId);
                this.logHandler = new ChannelLoggingHandler(() -> c, config -> {
                    config.setLogLevels(EnumSet.of(LogLevel.INFO, LogLevel.WARN, LogLevel.ERROR));
                    config.setColored(true);
                    config.setSplitCodeBlockForLinks(false);
                    config.setAllowLinkEmbeds(true);
                    config.mapLoggerName("net.dv8tion.jda", "JDA");
                    config.mapLoggerName("net.minecraft.server.MinecraftServer", "MinecraftServer");
                }).attachSystemLogging().schedule();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.extensions = new BridgeExtensionManager();
        this.extensions.registerExtensions();
        this.extensions.sort();
        this.playerCountUpdater = Executors.newScheduledThreadPool(1);
        this.playerCountUpdater.scheduleAtFixedRate(this.bot.updatePlayerCountRunnable, 0L, 1L, TimeUnit.MINUTES);
        logger.info(String.format("RRDiscordBridge v%s has started.", RRDiscordBridge.getVersion()));
        this.bot.sendEvent(Settings.Events.SERVER_START, new MessageEmbed.AuthorInfo(null, null, null, null), null, this.settings.colorPalette.serverStarted, "Server started!");
        return this;
    }

    public void shutdown(boolean reloading) {
        this.getBridgeExtensions().shutdown(this, reloading);
        if (this.playerCountUpdater != null) {
            this.playerCountUpdater.shutdown();
        }
        CompletableFuture<Void> eventFuture = CompletableFuture.runAsync(() -> {
            if (reloading) {
                this.bot.sendEvent(Settings.Events.PLUGIN_RELOAD, new MessageEmbed.AuthorInfo(null, null, null, null), null, this.settings.colorPalette.pluginReload, "Reloading RRDiscordBridge");
            }
            this.bot.sendEvent(Settings.Events.SERVER_STOP, new MessageEmbed.AuthorInfo(null, null, null, null), null, this.settings.colorPalette.serverStopped, "Server stopped!");
        });
        if (this.logHandler != null) {
            Handler[] handlers;
            for (Handler handler : handlers = logger.getHandlers()) {
                if (handler.getClass() != JavaLoggingAdapter.class) continue;
                logger.removeHandler(handler);
            }
            this.logHandler.shutdown();
        }
        eventFuture.thenRun(this.bot::stop);
        if (!reloading) {
            instance = null;
        }
    }

    public static String getVersion() {
        return "3.0.0";
    }

    public static Semver getSemver() {
        return new Semver("3.0.0", Semver.SemverType.LOOSE);
    }

    public BridgeExtensionManager getBridgeExtensions() {
        return this.extensions;
    }

    public void reload() throws IOException {
        this.shutdown(true);
        this.settings = new Settings(this.settings.configPath).load();
        this.initialize();
    }

    public SupportedFeatures getSupportedFeatures() {
        return this.features;
    }

    public RRDiscordBridge setSupportedFeatures(SupportedFeatures features) {
        this.features = features;
        return this;
    }

    public IServer getServer() {
        return this.server;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public DiscordBot getBot() {
        return this.bot;
    }

    static {
        logger = new JavaLogger(Logger.getLogger("RRDiscordBridge"));
    }
}

