/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.bukkit.events;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.dexrn.rrdiscordbridge.Events;
import me.dexrn.rrdiscordbridge.bukkit.impls.BukkitPlayer;
import me.dexrn.rrdiscordbridge.game.Advancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAchievementAwardedEvent;

public class PlayerAchievement
implements Listener {
    public Map<String, String> fixedAchievementNames = PlayerAchievement.createAchievementNameFixer();

    @EventHandler
    public void onPlayerAchievement(PlayerAchievementAwardedEvent event) {
        String loc = event.getAchievement().name().toLowerCase();
        String resource = loc.replaceAll("_", " ");
        String name = Stream.of(resource.trim().split("\\s")).filter(word -> !word.isEmpty()).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
        String wikiName = (name.substring(0, 1).toLowerCase() + name.substring(1)).replaceAll(" ", "");
        if (this.fixedAchievementNames.containsKey(wikiName)) {
            wikiName = this.fixedAchievementNames.get(wikiName);
        }
        Events.onPlayerAchievement(Advancement.Type.ACHIEVEMENT, new BukkitPlayer(event.getPlayer()), name, null, wikiName);
    }

    private static Map<String, String> createAchievementNameFixer() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("buildWorkbench", "buildWorkBench");
        return m;
    }
}

