/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.bukkit.impls;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import me.dexrn.rrdiscordbridge.Events;
import me.dexrn.rrdiscordbridge.bukkit.impls.BukkitPlayer;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import me.dexrn.rrdiscordbridge.interfaces.IServer;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;

public class BukkitServer
implements IServer {
    protected final Server server;

    public BukkitServer(Server server) {
        this.server = server;
    }

    @Override
    public void broadcastMessage(String message) {
        this.server.broadcastMessage(message);
    }

    @Override
    public IPlayer[] getOnlinePlayers() {
        return (IPlayer[])Arrays.stream(this.server.getOnlinePlayers()).map(OfflinePlayer::getPlayer).filter(Objects::nonNull).map(BukkitPlayer::new).toArray(IPlayer[]::new);
    }

    @Override
    public String[] getOperators() {
        return (String[])this.server.getOperators().stream().map(OfflinePlayer::getPlayer).filter(Objects::nonNull).map(BukkitPlayer::new).map(BukkitPlayer::getName).toArray(String[]::new);
    }

    @Override
    public IPlayer getPlayer(String name) {
        return new BukkitPlayer(this.server.getPlayer(name));
    }

    @Override
    public InputStream getResource(String path) {
        return this.server.getClass().getResourceAsStream(path);
    }

    @Override
    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    @Override
    public String getName() {
        return this.server.getServerName();
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public String getVersion() {
        return this.server.getVersion();
    }

    @Override
    public String getSoftwareName() {
        return this.server.getName();
    }

    @Override
    public void runCommand(String command) {
        this.server.dispatchCommand((CommandSender)this.server.getConsoleSender(), command);
        Events.onServerCommand(command);
    }
}

