/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.command.commands;

import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.command.CommandRegistry;
import me.dexrn.rrdiscordbridge.command.ICommand;
import me.dexrn.rrdiscordbridge.extension.AbstractBridgeExtension;
import me.dexrn.rrdiscordbridge.interfaces.ICommandCaller;

public class ChatExtensionsCommand
implements ICommand {
    @Override
    public CommandRegistry.CommandName getCommandName() {
        return CommandRegistry.CommandName.RDBEXT;
    }

    @Override
    public final String getDescription() {
        return "Handles extensions";
    }

    @Override
    public boolean invoke(ICommandCaller caller, String[] params) {
        if (params == null || params.length < 1) {
            caller.respond("\u00a7cNo subcommand given, valid options are:");
            caller.respond("\u00a7eList\u00a7b - \u00a7fLists all extensions");
            caller.respond("\u00a7eEnable <ext>\u00a7b - \u00a7fEnables a extension");
            caller.respond("\u00a7eDisable <ext>\u00a7b - \u00a7fDisables a extension");
            caller.respond("\u00a7eInfo <ext>\u00a7b - \u00a7fDisplays info about a given extension");
            caller.respond("\u00a7eHelp\u00a7b - \u00a7fShows all subcommands");
            return true;
        }
        String commandName = params[0];
        switch (commandName.toLowerCase()) {
            case "help": {
                caller.respond("\u00a7eList\u00a7b - \u00a7fLists all extensions");
                caller.respond("\u00a7eEnable <ext>\u00a7b - \u00a7fEnables a extension");
                caller.respond("\u00a7eDisable <ext>\u00a7b - \u00a7fDisables a extension");
                caller.respond("\u00a7eHelp\u00a7b - \u00a7fShows this message");
                break;
            }
            case "info": {
                if (params.length <= 1) {
                    caller.respond("\u00a7cNo extension name was provided.");
                    return true;
                }
                String iExtName = params[1];
                AbstractBridgeExtension iExt = RRDiscordBridge.instance.getBridgeExtensions().getExtension(iExtName);
                if (iExt == null) {
                    caller.respond(String.format("\u00a7cUnknown extension '%s'", iExtName));
                    return true;
                }
                caller.respond(String.format("%s%s \u00a77(v%s)\u00a7b - \u00a7r%s", RRDiscordBridge.instance.getBridgeExtensions().isEnabled(iExt) ? "\u00a7a" : "\u00a7c", iExt.getName(), iExt.getVersion(), iExt.getAuthor()));
                caller.respond(iExt.getDescription());
                break;
            }
            case "list": {
                caller.respond(String.format("\u00a7bExtensions (%s enabled, %s total)", RRDiscordBridge.instance.getBridgeExtensions().enabledExtensions.size(), RRDiscordBridge.instance.getBridgeExtensions().extensions.size()));
                for (AbstractBridgeExtension ext : RRDiscordBridge.instance.getBridgeExtensions().enabledExtensions) {
                    caller.respond(String.format("\u00a7a%s \u00a7b(v%s)", ext.getName(), ext.getVersion()));
                }
                for (AbstractBridgeExtension ext : RRDiscordBridge.instance.getBridgeExtensions().extensions) {
                    if (RRDiscordBridge.instance.getBridgeExtensions().enabledExtensions.contains(ext)) continue;
                    caller.respond(String.format("\u00a7c%s \u00a7b(v%s)", ext.getName(), ext.getVersion()));
                }
                break;
            }
            case "disable": {
                if (params.length <= 1) {
                    caller.respond("\u00a7cNo extension name was provided.");
                    return true;
                }
                String dExtName = params[1];
                AbstractBridgeExtension dExt = RRDiscordBridge.instance.getBridgeExtensions().getExtension(dExtName);
                if (dExt == null) {
                    caller.respond(String.format("\u00a7cUnknown extension '%s'", dExtName));
                    return true;
                }
                if (!RRDiscordBridge.instance.getBridgeExtensions().isEnabled(dExt)) {
                    caller.respond(String.format("\u00a7cExtension '%s' is already disabled", dExt.getName()));
                    return true;
                }
                RRDiscordBridge.instance.getBridgeExtensions().disable(RRDiscordBridge.instance.getBridgeExtensions().getExtension(dExtName));
                caller.respond(String.format("\u00a7bDisabled extension '%s'", dExt.getName()));
                break;
            }
            case "enable": {
                if (params.length <= 1) {
                    caller.respond("\u00a7cNo extension name was provided.");
                    return true;
                }
                String extName = params[1];
                AbstractBridgeExtension ext = RRDiscordBridge.instance.getBridgeExtensions().getExtension(extName);
                if (ext == null) {
                    caller.respond(String.format("\u00a7cUnknown extension '%s'", extName));
                    return true;
                }
                if (RRDiscordBridge.instance.getBridgeExtensions().isEnabled(ext)) {
                    caller.respond(String.format("\u00a7cExtension '%s' is already enabled", ext.getName()));
                    return true;
                }
                RRDiscordBridge.instance.getBridgeExtensions().enable(RRDiscordBridge.instance.getBridgeExtensions().getExtension(extName));
                caller.respond(String.format("\u00a7bEnabled extension '%s'", ext.getName()));
                break;
            }
            default: {
                caller.respond(String.format("\u00a7cUnknown subcommand '%s'", commandName));
            }
        }
        return true;
    }
}

