/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.awt.Color;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.config.IConfig;
import me.dexrn.rrdiscordbridge.config.adapter.ColorTypeAdapter;
import me.dexrn.rrdiscordbridge.config.adapter.PathTypeAdapter;

public class ColorPalette
implements IConfig {
    public static final Path DEFAULT_PATH = Paths.get(RRDiscordBridge.configDir.getPath(), "palettes", "default.json");
    public Color serverStarted = Color.GREEN;
    public Color serverStopped = Color.RED;
    public Color playerJoin = Color.GREEN;
    public Color playerFirstJoin = Color.GREEN;
    public Color playerLeave = new Color(255, 100, 0);
    public Color playerKick = new Color(255, 100, 0);
    public Color playerDeath = Color.RED;
    public Color pluginReload = Color.PINK;
    public Color playerAchievement = Color.CYAN;
    public Color playerChallenge = Color.MAGENTA;
    private transient Path path;

    public ColorPalette(Path path) {
        this.path = path;
    }

    @Override
    public ColorPalette load() throws IOException {
        ColorPalette palette;
        if (this.path == null) {
            this.path = DEFAULT_PATH;
        }
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, new PathTypeAdapter()).registerTypeAdapter((Type)((Object)Color.class), new ColorTypeAdapter()).registerTypeAdapter((Type)((Object)ColorPalette.class), new GsonInstanceCreator(this.path)).create();
        if (!Files.exists(this.path, new LinkOption[0])) {
            this.create();
        }
        try (FileReader reader = new FileReader(this.path.toFile());){
            palette = gson.fromJson((Reader)reader, ColorPalette.class);
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while reading the palette file: " + e.getMessage());
            throw e;
        }
        palette.upgrade(gson).save();
        return palette;
    }

    @Override
    public ColorPalette upgrade(Gson gson) {
        return this;
    }

    @Override
    public void save() {
        if (this.path == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.path.toFile());){
            Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Color.class), new ColorTypeAdapter()).setPrettyPrinting().create();
            writer.write(gson.toJson(this));
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while writing the palette: " + e.getMessage());
        }
    }

    @Override
    public void create() {
        Path parent = this.path.getParent();
        try {
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!Files.exists(this.path, new LinkOption[0])) {
                try {
                    Files.createFile(this.path, new FileAttribute[0]);
                    this.save();
                }
                catch (IOException e) {
                    RRDiscordBridge.logger.error("Exception while creating the palette file: ", e);
                }
            }
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while creating palette dir: ", e);
        }
    }

    private static class GsonInstanceCreator
    implements InstanceCreator<ColorPalette> {
        private final Path configPath;

        public GsonInstanceCreator(Path configPath) {
            this.configPath = configPath;
        }

        @Override
        public ColorPalette createInstance(Type type) {
            return new ColorPalette(this.configPath);
        }
    }
}

