/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vdurmont.semver4j.Semver;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.config.ColorPalette;
import me.dexrn.rrdiscordbridge.config.IConfig;
import me.dexrn.rrdiscordbridge.config.adapter.PathTypeAdapter;

public class Settings
implements IConfig {
    public String version;
    public final transient Path configPath;
    public transient ColorPalette colorPalette;
    public Path colorPalettePath;
    public String botToken;
    public String relayChannelId;
    public String consoleChannelId;
    public String discordInvite;
    public boolean useDisplayNames;
    public boolean useNicknames;
    public int maxMessageSize;
    public boolean publicPlayerNames;
    public boolean publicOperatorNames;
    public String skinProvider;
    public boolean showServerIcon;
    public String broadcastSkinName;
    public List<String> disabledExtensions;
    public List<Events> enabledEvents;
    public List<DiscordEvents> enabledDiscordEvents;
    public boolean useDiscordRelativeTimestamp;
    public List<String> discordOperators;
    public boolean stripMc2DcFormatting;

    public Settings(Path configPath) {
        this.colorPalette = new ColorPalette(this.colorPalettePath);
        this.colorPalettePath = ColorPalette.DEFAULT_PATH;
        this.botToken = "";
        this.relayChannelId = "";
        this.consoleChannelId = "";
        this.discordInvite = "";
        this.useDisplayNames = true;
        this.useNicknames = false;
        this.maxMessageSize = 300;
        this.publicPlayerNames = true;
        this.publicOperatorNames = true;
        this.skinProvider = "https://mc-heads.net/avatar/%s.png";
        this.showServerIcon = true;
        this.broadcastSkinName = "CONSOLE";
        this.disabledExtensions = new ArrayList<String>();
        this.enabledEvents = Arrays.asList(Events.values());
        this.enabledDiscordEvents = Arrays.asList(DiscordEvents.values());
        this.useDiscordRelativeTimestamp = true;
        this.discordOperators = new ArrayList<String>();
        this.stripMc2DcFormatting = true;
        this.configPath = configPath;
    }

    @Override
    public Settings load() throws IOException {
        Settings settings;
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, new PathTypeAdapter()).registerTypeAdapter((Type)((Object)Settings.class), new GsonInstanceCreator(this.configPath)).create();
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.create();
        }
        try (FileReader reader = new FileReader(this.configPath.toFile());){
            settings = gson.fromJson((Reader)reader, Settings.class);
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while reading the config file: " + e.getMessage());
            throw e;
        }
        settings.upgrade(gson);
        settings.colorPalette = this.colorPalette.load();
        settings.save();
        return settings;
    }

    @Override
    public void save() {
        try (FileWriter writer = new FileWriter(this.configPath.toFile());){
            Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, new PathTypeAdapter()).setPrettyPrinting().create();
            writer.write(gson.toJson(this));
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while writing the config: " + e.getMessage());
        }
        this.colorPalette.save();
    }

    @Override
    public Settings upgrade(Gson gson) {
        String version = this.version == null ? "2.1.0" : this.version;
        Semver ver = new Semver(version);
        if (!ver.isLowerThan(RRDiscordBridge.getVersion())) {
            return this;
        }
        RRDiscordBridge.logger.info(String.format("Config version is older than mod/plugin version (%s < %s), attempting to upgrade%n", version, RRDiscordBridge.getVersion()));
        if (ver.isLowerThan("2.2.0") && !this.enabledEvents.contains((Object)Events.PLAYER_ACHIEVEMENT)) {
            this.enabledEvents.add(Events.PLAYER_ACHIEVEMENT);
        }
        if (ver.isLowerThan("2.4.0") && !this.enabledEvents.contains((Object)Events.PLUGIN_RELOAD)) {
            this.enabledEvents.add(Events.PLUGIN_RELOAD);
        }
        if (ver.isLowerThan("3.0.0")) {
            try (FileReader reader = new FileReader(this.configPath.toFile());){
                JsonObject o = JsonParser.parseReader(reader).getAsJsonObject();
                String op = o.get("opChatChannelId").getAsString();
                if (!op.isEmpty()) {
                    RRDiscordBridge.logger.warn("OpChat channel ID has moved to " + this.configPath.getParent() + "/extensions/config/OpChat.json" + "\nPlease move your OpChat channel ID '" + op + "' to that file.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.version = RRDiscordBridge.getVersion();
        return this;
    }

    @Override
    public void create() {
        Path parent = this.configPath.getParent();
        try {
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                try {
                    Files.createFile(this.configPath, new FileAttribute[0]);
                    this.save();
                }
                catch (IOException e) {
                    RRDiscordBridge.logger.error("Exception while creating the config file: ", e);
                }
            }
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while creating config dir: ", e);
        }
    }

    public static enum Events {
        PLAYER_JOIN,
        PLAYER_LEAVE,
        PLAYER_KICK,
        PLAYER_DEATH,
        PLAYER_CHAT,
        PLAYER_ACHIEVEMENT,
        SERVER_START,
        PLUGIN_RELOAD,
        SERVER_STOP,
        SAY_BROADCAST,
        FANCY_BROADCAST,
        ME_COMMAND,
        GENERIC_OTHER;

    }

    public static enum DiscordEvents {
        USER_MESSAGE,
        USER_JOIN,
        USER_BOOST,
        THREAD_CREATION,
        MESSAGE_PIN,
        POLL_CREATION,
        POLL_ENDED,
        SLASH_COMMAND,
        USER_APP,
        FORWARDED_MESSAGE;

    }

    private static class GsonInstanceCreator
    implements InstanceCreator<Settings> {
        private final Path configPath;

        public GsonInstanceCreator(Path configPath) {
            this.configPath = configPath;
        }

        @Override
        public Settings createInstance(Type type) {
            return new Settings(this.configPath);
        }
    }
}

