/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.discord;

import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import club.minnced.discord.webhook.send.AllowedMentions;
import club.minnced.discord.webhook.send.WebhookMessage;
import club.minnced.discord.webhook.send.WebhookMessageBuilder;
import java.awt.Color;
import java.time.Instant;
import java.util.List;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.config.Settings;
import me.dexrn.rrdiscordbridge.discord.DiscordEventHandler;
import me.dexrn.rrdiscordbridge.discord.commands.AboutCommand;
import me.dexrn.rrdiscordbridge.discord.commands.PlayersCommand;
import me.dexrn.rrdiscordbridge.extension.event.events.ExtensionEvents;
import me.dexrn.rrdiscordbridge.extension.event.events.chat.MinecraftChatEvent;
import me.dexrn.rrdiscordbridge.extension.event.registry.ExtensionEventRegistry;
import me.dexrn.rrdiscordbridge.extension.types.ModifiableMessage;
import me.dexrn.rrdiscordbridge.game.FormattingCodes;
import me.dexrn.rrdiscordbridge.interfaces.ICancellable;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.internal.utils.JDALogger;
import org.jetbrains.annotations.NotNull;

public class DiscordBot {
    public WebhookClient webhookClient;
    public Webhook webhook;
    public User self;
    public JDA jda;
    TextChannel channel;
    public final Runnable updatePlayerCountRunnable = () -> {
        if (RRDiscordBridge.instance != null && RRDiscordBridge.instance.getServer() != null) {
            this.setPlayerCount();
        }
    };

    public DiscordBot() {
        JDALogger.setFallbackLoggerEnabled(true);
    }

    public void start() throws InterruptedException {
        if (RRDiscordBridge.instance.getSettings().botToken.isEmpty()) {
            RRDiscordBridge.instance.getServer().broadcastMessage("Failed to load RRDiscordBridge, please check the console logs.");
            throw new RuntimeException(String.format("Please set the bot token in %s", RRDiscordBridge.instance.getSettings().configPath));
        }
        if (RRDiscordBridge.instance.getSettings().relayChannelId.isEmpty()) {
            RRDiscordBridge.instance.getServer().broadcastMessage("Failed to load RRDiscordBridge, please check the console logs.");
            throw new RuntimeException(String.format("Please set the channel id (of the relay channel) in %s", RRDiscordBridge.instance.getSettings().configPath));
        }
        this.jda = JDABuilder.createDefault(RRDiscordBridge.instance.getSettings().botToken).addEventListeners(new DiscordEventHandler(), new PlayersCommand(), new AboutCommand()).enableIntents(GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT).build().awaitReady();
        this.self = this.jda.getSelfUser();
        List<Webhook> webhooks = this.channel.retrieveWebhooks().complete();
        this.webhook = webhooks.stream().filter(hook -> {
            User owner = hook.getOwnerAsUser();
            if (owner == null) {
                return false;
            }
            return owner.getId().equals(this.self.getId());
        }).findFirst().orElseGet(() -> (Webhook)this.channel.createWebhook("RRMCBridge").complete());
        WebhookClientBuilder builder = new WebhookClientBuilder(this.webhook.getUrl());
        builder.setThreadFactory(job -> {
            Thread thread = new Thread(job);
            thread.setName("RRDiscordBridgeWebhook");
            thread.setDaemon(true);
            return thread;
        });
        builder.setWait(true);
        this.webhookClient = builder.build();
        if (RRDiscordBridge.instance != null && RRDiscordBridge.instance.getServer() != null) {
            this.setPlayerCount();
        }
        this.channel.getGuild().updateCommands().addCommands(Commands.slash("players", "List of online players"), Commands.slash("about", "Server info")).queue();
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.getJDA().shutdown();
        }
        if (this.webhookClient != null) {
            this.webhookClient.close();
            this.webhookClient = null;
        }
    }

    public void setPlayerCount() {
        this.setPlayerCount(RRDiscordBridge.instance.getServer().getOnlinePlayers().length);
    }

    public void setPlayerCount(int i) {
        Activity activity = Activity.playing(String.format("with %s %s", i, i != 1 ? "players" : "player"));
        this.jda.getPresence().setActivity(activity);
    }

    public static String getName(Member member) {
        String nickname = member.getNickname();
        if (member.getUser().isBot()) {
            return RRDiscordBridge.instance.getSettings().useNicknames && nickname != null && !nickname.isEmpty() ? nickname : member.getUser().getName();
        }
        String displayName = member.getUser().getGlobalName();
        return RRDiscordBridge.instance.getSettings().useNicknames && nickname != null && !nickname.isEmpty() ? nickname : (RRDiscordBridge.instance.getSettings().useDisplayNames && displayName != null && !displayName.isEmpty() ? displayName : member.getUser().getName());
    }

    public static String getName(User user) {
        if (user.isBot()) {
            return user.getName();
        }
        String displayName = user.getGlobalName();
        return RRDiscordBridge.instance.getSettings().useDisplayNames && displayName != null && !displayName.isEmpty() ? user.getGlobalName() : user.getName();
    }

    public void sendPlayerMessage(IPlayer player, String message, ICancellable event) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.PLAYER_CHAT)) {
            return;
        }
        String msg = message;
        if (RRDiscordBridge.instance.getBridgeExtensions() != null) {
            MinecraftChatEvent ev = new MinecraftChatEvent(player, message);
            ExtensionEventRegistry.getInstance().invoke(ExtensionEvents.MINECRAFT_CHAT, ev);
            ModifiableMessage<String> res = ev.getResult();
            msg = (String)res.message;
            if (!res.getShouldSendToMinecraft()) {
                event.cancel();
            }
            if (!res.getShouldSendToDiscord()) {
                return;
            }
        }
        AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
        WebhookMessage messageSend = new WebhookMessageBuilder().setUsername(player.getName()).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, player.getName())).setContent(FormattingCodes.removeDcFormatting(msg)).setAllowedMentions(allowedMentions).build();
        this.webhookClient.send(messageSend);
    }

    public void sendPlayerMessage(String playerName, String message) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.PLAYER_CHAT)) {
            return;
        }
        AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
        WebhookMessage wMessage = new WebhookMessageBuilder().setUsername(playerName).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, playerName)).setContent(FormattingCodes.removeDcFormatting(message)).setAllowedMentions(allowedMentions).build();
        this.webhookClient.send(wMessage);
    }

    public static void sendPlayerMessage(String playerName, String message, WebhookClient wc) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.PLAYER_CHAT)) {
            return;
        }
        AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
        WebhookMessage wMessage = new WebhookMessageBuilder().setUsername(playerName).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, playerName)).setContent(FormattingCodes.removeDcFormatting(message)).setAllowedMentions(allowedMentions).build();
        wc.send(wMessage);
    }

    public void sendPlayerMessage(Settings.Events eventType, IPlayer player, String message) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)eventType)) {
            return;
        }
        String msg = message;
        if (RRDiscordBridge.instance.getBridgeExtensions() != null) {
            MinecraftChatEvent ev = new MinecraftChatEvent(player, message);
            ExtensionEventRegistry.getInstance().invoke(ExtensionEvents.MINECRAFT_CHAT, ev);
            ModifiableMessage<String> res = ev.getResult();
            msg = (String)res.message;
            if (!res.getShouldSendToDiscord()) {
                return;
            }
        }
        AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
        WebhookMessage wMessage = new WebhookMessageBuilder().setUsername(player.getName()).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, player.getName())).setContent(FormattingCodes.removeDcFormatting(msg)).setAllowedMentions(allowedMentions).build();
        this.webhookClient.send(wMessage);
    }

    public void sendPlayerMessage(String playerName, String playerSkinName, String message) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)Settings.Events.PLAYER_CHAT)) {
            return;
        }
        AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
        WebhookMessage wMessage = new WebhookMessageBuilder().setUsername(playerName).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, playerSkinName)).setContent(FormattingCodes.removeDcFormatting(message)).setAllowedMentions(allowedMentions).build();
        this.webhookClient.send(wMessage);
    }

    public void sendPlayerMessage(Settings.Events eventType, IPlayer player, String playerSkinName, String message) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)eventType)) {
            return;
        }
        String msg = message;
        if (RRDiscordBridge.instance.getBridgeExtensions() != null) {
            MinecraftChatEvent ev = new MinecraftChatEvent(player, message);
            ExtensionEventRegistry.getInstance().invoke(ExtensionEvents.MINECRAFT_CHAT, ev);
            ModifiableMessage<String> res = ev.getResult();
            msg = (String)res.message;
            if (!res.getShouldSendToDiscord()) {
                return;
            }
        }
        AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
        WebhookMessage wMessage = new WebhookMessageBuilder().setUsername(player.getName()).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, playerSkinName)).setContent(FormattingCodes.removeDcFormatting(msg)).setAllowedMentions(allowedMentions).build();
        this.webhookClient.send(wMessage);
    }

    public void sendPlayerEvent(Settings.Events eventType, String playerName, String description, Color color, String title) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)eventType)) {
            return;
        }
        EmbedBuilder embed = new EmbedBuilder().setColor(color).setDescription(FormattingCodes.removeDcFormatting(description)).setTitle(FormattingCodes.removeDcFormatting(title)).setTimestamp(Instant.now()).setAuthor(playerName, null, String.format(RRDiscordBridge.instance.getSettings().skinProvider, playerName));
        this.channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    public void sendPlayerEvent(Settings.Events eventType, String playerName, String authorName, String description, Color color, String title, String footer) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)eventType)) {
            return;
        }
        EmbedBuilder embed = new EmbedBuilder().setColor(color).setDescription(FormattingCodes.removeDcFormatting(description)).setTitle(FormattingCodes.removeDcFormatting(title)).setTimestamp(Instant.now()).setFooter(FormattingCodes.removeDcFormatting(footer)).setAuthor(authorName, null, String.format(RRDiscordBridge.instance.getSettings().skinProvider, playerName));
        this.channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    public void sendEvent(Settings.Events eventType, MessageEmbed.AuthorInfo author, String description, Color color, String title) {
        if (!RRDiscordBridge.instance.getSettings().enabledEvents.contains((Object)eventType)) {
            return;
        }
        EmbedBuilder embed = new EmbedBuilder().setColor(color).setDescription(FormattingCodes.removeDcFormatting(description)).setTitle(FormattingCodes.removeDcFormatting(title)).setTimestamp(Instant.now()).setAuthor(author.getName(), null, author.getIconUrl());
        this.channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    public void sendMessage(String message) {
        if (this.channel != null) {
            this.channel.sendMessage(message).queue();
        } else {
            RRDiscordBridge.logger.warn("bot isn't ready!");
        }
    }

    public static Message sendMessage(String message, TextChannel channel) {
        if (channel != null) {
            MessageCreateAction action = channel.sendMessage(message);
            return (Message)action.complete();
        }
        RRDiscordBridge.logger.warn("Cannot send because provided channel is null.");
        return null;
    }

    public Message sendMessage(String message, String channel) {
        TextChannel txtChannel = this.jda.getTextChannelById(channel);
        if (txtChannel != null) {
            MessageCreateAction action = txtChannel.sendMessage(message);
            return (Message)action.complete();
        }
        RRDiscordBridge.logger.warn("Could not find channel " + channel);
        return null;
    }

    public static void editMessage(String newMessage, Message msg) {
        if (msg != null) {
            msg.editMessage(newMessage).queue();
        } else {
            RRDiscordBridge.logger.warn("Cannot edit because provided message is null.");
        }
    }

    @NotNull
    static String trimDiscordMessage(Message message) {
        String messageTrimmed = "\u00a77Empty message";
        if (!message.getAttachments().isEmpty()) {
            messageTrimmed = "";
        }
        if (!message.getContentDisplay().isEmpty()) {
            messageTrimmed = message.getContentDisplay().substring(0, Math.min(RRDiscordBridge.instance.getSettings().maxMessageSize, message.getContentDisplay().length()));
        }
        return messageTrimmed;
    }
}

