/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.discord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.config.Settings;
import me.dexrn.rrdiscordbridge.discord.DiscordBot;
import me.dexrn.rrdiscordbridge.discord.DiscordMessageEvent;
import me.dexrn.rrdiscordbridge.extension.event.events.ExtensionEvents;
import me.dexrn.rrdiscordbridge.extension.event.events.chat.DiscordChatEvent;
import me.dexrn.rrdiscordbridge.extension.event.registry.ExtensionEventRegistry;
import me.dexrn.rrdiscordbridge.extension.types.ModifiableMessage;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.MessageType;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.messages.MessagePoll;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.session.ReadyEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;

public class DiscordEventHandler
extends ListenerAdapter {
    EnumMap<MessageType, DiscordMessageEvent<MessageReceivedEvent, Message, String, String>> events = new EnumMap(MessageType.class);

    public DiscordEventHandler() {
        this.events.put(MessageType.DEFAULT, this::onMessage);
        this.events.put(MessageType.INLINE_REPLY, this::onMessage);
        this.events.put(MessageType.GUILD_MEMBER_JOIN, this::onMemberJoin);
        this.events.put(MessageType.GUILD_MEMBER_BOOST, this::onServerBoost);
        this.events.put(MessageType.THREAD_CREATED, this::onThreadCreated);
        this.events.put(MessageType.CHANNEL_PINNED_ADD, this::onMessagePinned);
        this.events.put(MessageType.POLL_RESULT, this::onPollEnded);
        this.events.put(MessageType.CONTEXT_COMMAND, this::onUserAppActivity);
    }

    @Override
    public void onReady(ReadyEvent event) {
        RRDiscordBridge.instance.getBot().channel = event.getJDA().getTextChannelById(RRDiscordBridge.instance.getSettings().relayChannelId);
    }

    public void onConsoleChannelMessageReceived(MessageReceivedEvent event, Message message, String author, String text) {
        Member member = event.getMember();
        if (member != null && RRDiscordBridge.instance.getSettings().discordOperators.contains(member.getId()) && RRDiscordBridge.instance.getSupportedFeatures().canSendConsoleCommands()) {
            RRDiscordBridge.logger.info(String.format("[Discord Console] %s ran command '%s'", author, text));
            RRDiscordBridge.instance.getServer().runCommand(text);
        }
    }

    @Override
    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        if (event.getInteraction().getMember() == null) {
            return;
        }
        String channel = event.getChannel().getId();
        String sender = event.getInteraction().getMember().getId();
        if (channel.equals(RRDiscordBridge.instance.getSettings().relayChannelId) && !sender.equals(RRDiscordBridge.instance.getBot().self.getId()) && !sender.equals(RRDiscordBridge.instance.getBot().webhook.getId())) {
            String author = event.getMember() != null ? DiscordBot.getName(event.getMember()) : DiscordBot.getName(event.getUser());
            RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s ran Discord command \"/%s\".", author, event.getFullCommandName()));
        }
    }

    public void onMemberJoin(MessageReceivedEvent event, Message message, String author, String text) {
        if (RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.USER_JOIN)) {
            RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s has joined the Discord server.", author));
        }
    }

    public void onServerBoost(MessageReceivedEvent event, Message message, String author, String text) {
        if (RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.USER_BOOST)) {
            RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s has boosted the Discord server.", author));
        }
    }

    public void onThreadCreated(MessageReceivedEvent event, Message message, String author, String text) {
        if (RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.THREAD_CREATION)) {
            RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s has created the thread \"%s\".", author, message));
        }
    }

    public void onMessagePinned(MessageReceivedEvent event, Message message, String author, String text) {
        if (RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.MESSAGE_PIN)) {
            RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s has pinned a message to the channel.", author));
        }
    }

    public void onPollEnded(MessageReceivedEvent event, Message message, String author, String text) {
        if (!RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.POLL_ENDED)) {
            return;
        }
        MessageReference ref = message.getMessageReference();
        if (ref == null) {
            return;
        }
        String channelId = ref.getChannelId();
        TextChannel pollChannel = message.getGuild().getTextChannelById(channelId);
        if (pollChannel == null) {
            return;
        }
        Message poll = pollChannel.retrieveMessageById(message.getMessageReference().getMessageId()).complete();
        MessagePoll mPoll = poll.getPoll();
        if (mPoll == null) {
            return;
        }
        RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s's poll \"%s\" has ended.\nResults:", author, mPoll.getQuestion().getText()));
        poll.getPoll().getAnswers().forEach(answer -> RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a73%s: \u00a7b%s", answer.getText(), answer.getVotes())));
    }

    public void onUserAppActivity(MessageReceivedEvent event, Message message, String author, String text) {
        if (!RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.USER_APP)) {
            return;
        }
        if (message.getInteractionMetadata() == null) {
            return;
        }
        RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s used app \"%s\".", author, message.getAuthor().getName()));
    }

    public void onForwardedMessage(MessageReceivedEvent event, Message message, String author, String text) {
        if (!RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.FORWARDED_MESSAGE)) {
            return;
        }
        RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s forwarded a message.", author));
    }

    public void onPollCreated(MessageReceivedEvent event, Message message, String author, String text) {
        if (!RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.POLL_CREATION)) {
            return;
        }
        MessagePoll poll = message.getPoll();
        if (poll == null) {
            return;
        }
        RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord] \u00a7e%s has created a poll \"%s\".", author, poll.getQuestion().getText()));
    }

    public void onMessage(MessageReceivedEvent event, Message message, String author, String text) {
        if (message.getMessageReference() != null && message.getMessageReference().getType() == MessageReference.MessageReferenceType.FORWARD) {
            this.onForwardedMessage(event, message, author, text);
            return;
        }
        if (message.getPoll() != null) {
            this.onPollCreated(event, message, author, text);
            return;
        }
        if (!RRDiscordBridge.instance.getSettings().enabledDiscordEvents.contains((Object)Settings.DiscordEvents.USER_MESSAGE)) {
            return;
        }
        ArrayList traits = new ArrayList(Collections.emptyList());
        boolean hasAttachment = false;
        int attachmentCount = 0;
        Message replyingTo = null;
        if (message.getMessageReference() != null) {
            replyingTo = message.getReferencedMessage();
        }
        String replyAuthor = "";
        if (replyingTo != null) {
            replyAuthor = replyingTo.getMember() != null ? DiscordBot.getName(replyingTo.getMember()) : DiscordBot.getName(replyingTo.getAuthor());
        }
        if (!event.getMessage().getAttachments().isEmpty() || !event.getMessage().getStickers().isEmpty()) {
            hasAttachment = true;
            attachmentCount = event.getMessage().getAttachments().size() + event.getMessage().getStickers().size();
            traits.add(Integer.toString(attachmentCount));
        }
        if (event.getMessage().getContentDisplay().length() > RRDiscordBridge.instance.getSettings().maxMessageSize) {
            traits.add("T");
            event.getMessage().addReaction(Emoji.fromUnicode("\ud83d\udccf")).queue();
        }
        RRDiscordBridge.instance.getServer().broadcastMessage(String.format("\u00a7d[Discord]%s%s \u00a7e%s\u00a7f: %s%s", replyingTo != null && !replyAuthor.isEmpty() ? String.format(" \u00a7b(RE: \u00a7e%s\u00a7b)", replyAuthor) : "", !traits.isEmpty() ? String.format(" \u00a76(%s)", String.join((CharSequence)", ", traits)) : "", author, text, text.isEmpty() && hasAttachment ? String.format("\u00a76%s attachment(s)", attachmentCount) : ""));
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        DiscordMessageEvent<MessageReceivedEvent, Message, String, String> run;
        String channel = event.getChannel().getId();
        String author = event.getAuthor().getName();
        String authorId = event.getAuthor().getId();
        Message message = event.getMessage();
        boolean sendMc = true;
        if (RRDiscordBridge.instance.getBridgeExtensions() != null) {
            DiscordChatEvent ev = new DiscordChatEvent(message);
            ExtensionEventRegistry.getInstance().invoke(ExtensionEvents.DISCORD_CHAT, ev);
            ModifiableMessage<Message> res = ev.getResult();
            message = (Message)res.message;
            sendMc = res.getShouldSendToMinecraft();
        }
        author = message.getMember() != null ? DiscordBot.getName(message.getMember()) : DiscordBot.getName(message.getAuthor());
        String messageTrimmed = DiscordBot.trimDiscordMessage(message);
        if (channel.equals(RRDiscordBridge.instance.getSettings().consoleChannelId)) {
            this.onConsoleChannelMessageReceived(event, message, author, messageTrimmed);
            return;
        }
        if (!sendMc) {
            return;
        }
        if (channel.equals(RRDiscordBridge.instance.getSettings().relayChannelId) && !authorId.equals(RRDiscordBridge.instance.getBot().self.getId()) && !authorId.equals(RRDiscordBridge.instance.getBot().webhook.getId()) && (run = this.events.get((Object)message.getType())) != null) {
            run.accept(event, message, author, messageTrimmed);
        }
    }
}

