/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.discord.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.game.FormattingCodes;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.FileUpload;

public class AboutCommand
extends ListenerAdapter {
    public String getUptime() {
        long elapsedMillis = System.currentTimeMillis() - RRDiscordBridge.getServerStartTime();
        long seconds = elapsedMillis / 1000L % 60L;
        long minutes = elapsedMillis / 60000L % 60L;
        long hours = elapsedMillis / 3600000L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    @Override
    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        if (!event.getName().equals("about")) {
            return;
        }
        EmbedBuilder builder = new EmbedBuilder().setTitle("About");
        File icon = new File("server-icon.png");
        if (RRDiscordBridge.instance.getSettings().showServerIcon && icon.exists()) {
            builder.setThumbnail("attachment://server-icon.png");
        }
        if (RRDiscordBridge.instance.getSupportedFeatures().canGetServerName()) {
            builder.addField("Name", FormattingCodes.removeDcFormatting(RRDiscordBridge.instance.getServer().getName()), true);
        }
        if (RRDiscordBridge.instance.getSupportedFeatures().canGetServerMotd()) {
            builder.addField("MOTD", FormattingCodes.removeDcFormatting(RRDiscordBridge.instance.getServer().getMotd()), true);
        }
        builder.addField("Version", RRDiscordBridge.instance.getServer().getVersion(), true);
        if (RRDiscordBridge.instance.getSettings().publicOperatorNames) {
            if (RRDiscordBridge.instance.getSupportedFeatures().canQueryServerOperators()) {
                CharSequence[] ops = RRDiscordBridge.instance.getServer().getOperators();
                builder.addField("Operators", ops.length > 0 ? " - " + String.join((CharSequence)"\n - ", ops) : "No operators", false);
            } else {
                String dir = new File(".").getAbsolutePath();
                Path opsTxt = Paths.get(dir, "ops.txt");
                List<String> ops = null;
                try {
                    if (opsTxt.toFile().exists()) {
                        ops = Files.readAllLines(opsTxt.toAbsolutePath());
                        builder.addField("Operators", !ops.isEmpty() ? " - " + String.join((CharSequence)"\n - ", ops) : "No operators", false);
                    }
                }
                catch (IOException e) {
                    RRDiscordBridge.logger.warn(String.format("Couldn't get the OPs list at %s", opsTxt.toAbsolutePath()), e);
                }
            }
        }
        String uptime = RRDiscordBridge.instance.getSettings().useDiscordRelativeTimestamp ? String.format("<t:%d:R>", RRDiscordBridge.getServerStartTime() / 1000L) : this.getUptime();
        builder.addField("Uptime", uptime, false);
        builder.setFooter(String.format("RRDiscordBridge v%s running on %s", RRDiscordBridge.getVersion(), RRDiscordBridge.instance.getServer().getSoftwareName()));
        MessageEmbed embed = builder.build();
        ReplyCallbackAction callback = event.replyEmbeds(embed, new MessageEmbed[0]);
        if (icon.exists()) {
            callback.addFiles(FileUpload.fromData(icon, "server-icon.png"));
        }
        callback.queue();
    }
}

