/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extension;

import com.vdurmont.semver4j.Semver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.extension.AbstractBridgeExtension;
import me.dexrn.rrdiscordbridge.extension.loader.EventExtensionLoader;
import me.dexrn.rrdiscordbridge.extension.loader.IExtensionLoader;
import me.dexrn.rrdiscordbridge.extension.loader.JarExtensionLoader;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BridgeExtensionManager {
    public List<AbstractBridgeExtension> extensions = new ArrayList<AbstractBridgeExtension>();
    public List<AbstractBridgeExtension> enabledExtensions = new ArrayList<AbstractBridgeExtension>();
    private final List<IExtensionLoader> loaders = new ArrayList<IExtensionLoader>();

    public BridgeExtensionManager() {
        this.loaders.add(new EventExtensionLoader());
        this.loaders.add(new JarExtensionLoader());
    }

    public void registerExtensions() {
        this.loaders.forEach(l -> l.registerExtensions(this));
    }

    public AbstractBridgeExtension getExtension(String extensionName) {
        return this.extensions.stream().filter(x -> x.getName().equals(extensionName)).findFirst().orElse(null);
    }

    public boolean isEnabled(String extensionName) {
        return this.enabledExtensions.stream().filter(x -> x.getName().equals(extensionName)).findFirst().orElse(null) != null;
    }

    public boolean isEnabled(AbstractBridgeExtension ext) {
        return this.enabledExtensions.stream().filter(x -> x.equals(ext)).findFirst().orElse(null) != null;
    }

    public void sort() {
        this.enabledExtensions.sort(Comparator.comparingInt(e -> e.getPriority().getPriority()));
        this.extensions.sort(Comparator.comparingInt(e -> e.getPriority().getPriority()));
    }

    public void register(Class<? extends AbstractBridgeExtension> ext) {
        try {
            this.register(ext.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            RRDiscordBridge.logger.error(String.format("Failed to register extension %s: ", ext.getName()), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void register(AbstractBridgeExtension ext) {
        try {
            this.extensions.add(ext);
            ext.onRegister(RRDiscordBridge.instance);
            if (!RRDiscordBridge.instance.getSettings().disabledExtensions.contains(ext.getName())) {
                this.enabledExtensions.add(ext);
                ext.onEnable();
            }
            if (ext == null) return;
        }
        catch (Exception e) {
            try {
                RRDiscordBridge.logger.error(String.format("Failed to register extension %s: %s", ext.getName(), e.toString()), e);
                if (ext == null) return;
            }
            catch (Throwable throwable) {
                if (ext == null) throw throwable;
                RRDiscordBridge.logger.info(String.format("Registered extension %s v%s", ext.getName(), ext.getVersion()));
                throw throwable;
            }
            RRDiscordBridge.logger.info(String.format("Registered extension %s v%s", ext.getName(), ext.getVersion()));
            return;
        }
        RRDiscordBridge.logger.info(String.format("Registered extension %s v%s", ext.getName(), ext.getVersion()));
        return;
    }

    void unregister(AbstractBridgeExtension ext) {
        ext.onDisable();
        this.enabledExtensions.remove(ext);
        this.extensions.remove(ext);
        RRDiscordBridge.logger.info(String.format("Unregistered extension %s", ext.getName()));
    }

    public void disable(AbstractBridgeExtension ext) {
        ext.onDisable();
        this.enabledExtensions.remove(ext);
        RRDiscordBridge.instance.getSettings().disabledExtensions.add(ext.getName());
        RRDiscordBridge.logger.info(String.format("Disabled extension %s", ext.getName()));
    }

    public void enable(AbstractBridgeExtension ext) {
        ext.onEnable();
        this.enabledExtensions.add(ext);
        RRDiscordBridge.instance.getSettings().disabledExtensions.remove(ext.getName());
        RRDiscordBridge.logger.info(String.format("Enabled extension '%s' v%s", ext.getName(), ext.getVersion()));
        Semver compat = ext.getCompatibleVersion();
        Semver current = RRDiscordBridge.getSemver();
        if (current.isGreaterThan(compat)) {
            RRDiscordBridge.logger.warn(String.format("Extension '%s' (v%s) was made for an older version of RRDiscordBridge (v%s > v%s), bugs may arise.", ext.getName(), ext.getVersion(), current, compat));
        }
        if (current.isLowerThan(compat)) {
            RRDiscordBridge.logger.warn(String.format("Extension '%s' (v%s) was made for a newer version of RRDiscordBridge (v%s < v%s), bugs may arise.", ext.getName(), ext.getVersion(), current, compat));
        }
    }

    public void shutdown(RRDiscordBridge instance, boolean reloading) {
        for (AbstractBridgeExtension ext : this.enabledExtensions) {
            ext.onShutdown(instance, reloading);
        }
        this.enabledExtensions.clear();
        this.extensions.clear();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.enabledExtensions).append(this.extensions).toString();
    }
}

