/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extension.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import com.vdurmont.semver4j.Semver;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.config.IConfig;
import me.dexrn.rrdiscordbridge.config.adapter.SemverTypeAdapter;
import me.dexrn.rrdiscordbridge.extension.config.options.AbstractExtensionOptions;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ExtensionConfig
implements IConfig {
    protected transient String name;
    protected transient Semver version;
    public transient Path CONFIG_PATH;
    @Expose
    @SerializedName(value="version")
    protected Semver configVersion;
    @Expose
    @SerializedName(value="options")
    public AbstractExtensionOptions options;

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.version).append(this.options).toString();
    }

    ExtensionConfig(Semver version, String name, Path configPath) {
        this.version = version;
        this.configVersion = version;
        this.name = name;
        this.CONFIG_PATH = configPath;
    }

    public ExtensionConfig(AbstractExtensionOptions options, Semver version, String name) {
        this.version = version;
        this.configVersion = version;
        this.name = name;
        this.options = options;
        this.options.type = name;
        this.CONFIG_PATH = Paths.get(RRDiscordBridge.configDir.getPath(), "extensions", "config", name + ".json");
    }

    public <T extends AbstractExtensionOptions> Gson getGson(Class<? extends AbstractExtensionOptions> type) {
        RuntimeTypeAdapterFactory<? extends AbstractExtensionOptions> configAdapterFactory = RuntimeTypeAdapterFactory.of(AbstractExtensionOptions.class, "type", true).registerSubtype(type, this.name);
        GsonBuilder builder = new GsonBuilder().registerTypeHierarchyAdapter(Semver.class, new SemverTypeAdapter()).registerTypeAdapter((Type)((Object)ExtensionConfig.class), new GsonInstanceCreator(this.version, this.name, this.CONFIG_PATH)).registerTypeAdapterFactory(configAdapterFactory).excludeFieldsWithoutExposeAnnotation().setPrettyPrinting();
        builder = this.options.configGsonBuilder(builder);
        return builder.create();
    }

    @Override
    public ExtensionConfig load() throws IOException {
        ExtensionConfig config;
        if (!Files.exists(this.CONFIG_PATH, new LinkOption[0])) {
            this.create();
        }
        try (FileReader reader = new FileReader(this.CONFIG_PATH.toFile());){
            Gson gson = this.getGson(this.options.getClass());
            config = gson.fromJson((Reader)reader, ExtensionConfig.class).upgrade(gson);
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while reading the config file for extension " + this.name + ": " + e.getMessage());
            throw e;
        }
        catch (JsonParseException e) {
            RRDiscordBridge.logger.error(String.format("Exception while deserializing the config file for extension %s: %s\nIs the JSON valid? Make sure the 'type' field is intact and hasn't been changed/removed.", this.name, e.getMessage()));
            throw e;
        }
        config.save();
        return config;
    }

    @Override
    public ExtensionConfig upgrade(Gson gson) {
        this.options = (AbstractExtensionOptions)this.options.upgrade(this.version, this.configVersion);
        return this;
    }

    @Override
    public void create() {
        Path parent = this.CONFIG_PATH.getParent();
        try {
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!Files.exists(this.CONFIG_PATH, new LinkOption[0])) {
                try {
                    Files.createFile(this.CONFIG_PATH, new FileAttribute[0]);
                    this.save();
                }
                catch (IOException e) {
                    RRDiscordBridge.logger.error("Exception while creating config file for extension '" + this.name + "': ", e);
                }
            }
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while creating config dir for extension '" + this.name + "': ", e);
        }
    }

    @Override
    public void save() {
        try (FileWriter writer = new FileWriter(this.CONFIG_PATH.toFile());){
            this.getGson(this.options.getClass()).toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            RRDiscordBridge.logger.error("Exception while writing the config for extension '" + this.name + "': " + e.getMessage());
        }
    }

    private static class GsonInstanceCreator
    implements InstanceCreator<ExtensionConfig> {
        private final Path configPath;
        private final Semver version;
        private final String name;

        public GsonInstanceCreator(Semver version, String name, Path configPath) {
            this.version = version;
            this.name = name;
            this.configPath = configPath;
        }

        @Override
        public ExtensionConfig createInstance(Type type) {
            return new ExtensionConfig(this.version, this.name, this.configPath);
        }
    }
}

