/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extension.event.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.dexrn.rrdiscordbridge.extension.AbstractBridgeExtension;
import me.dexrn.rrdiscordbridge.extension.event.ExtensionEvent;
import me.dexrn.rrdiscordbridge.extension.event.ExtensionEventType;
import me.dexrn.rrdiscordbridge.extension.event.IExtensionEventHandler;
import me.dexrn.rrdiscordbridge.extension.event.registry.EventHandlerHolder;

public class ExtensionEventRegistry {
    private final Map<ExtensionEventType<? extends ExtensionEvent>, List<EventHandlerHolder<? extends ExtensionEvent>>> events = new HashMap<ExtensionEventType<? extends ExtensionEvent>, List<EventHandlerHolder<? extends ExtensionEvent>>>();
    private static final ExtensionEventRegistry INSTANCE = new ExtensionEventRegistry();

    public static ExtensionEventRegistry getInstance() {
        return INSTANCE;
    }

    public <T extends ExtensionEvent> EventHandlerHolder<? extends ExtensionEvent> register(AbstractBridgeExtension owner, ExtensionEventType<T> type, IExtensionEventHandler<T> handler) {
        EventHandlerHolder<T> t = new EventHandlerHolder<T>(owner, type, handler);
        this.events.computeIfAbsent(type, e -> new ArrayList()).add(t);
        return t;
    }

    public <T extends ExtensionEvent> void unregister(EventHandlerHolder<? extends ExtensionEvent> r) {
        List<EventHandlerHolder<? extends ExtensionEvent>> h = this.events.get(r.getType());
        if (h != null) {
            h.remove(r);
        }
    }

    public void unregisterAll(AbstractBridgeExtension owner) {
        this.events.values().forEach(h -> h.removeIf(rh -> rh.getOwner().equals(owner)));
    }

    public <T extends ExtensionEvent> void invoke(ExtensionEventType<T> type, T event) {
        for (EventHandlerHolder h : this.events.getOrDefault(type, Collections.emptyList())) {
            h.getHandler().invoke(event);
        }
    }
}

