/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extension.event.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.dexrn.rrdiscordbridge.extension.event.ExtensionEvent;
import me.dexrn.rrdiscordbridge.extension.event.ExtensionEventType;

public class ExtensionEventTypeRegistry {
    private final Map<String, ExtensionEventType<? extends ExtensionEvent>> types = new HashMap<String, ExtensionEventType<? extends ExtensionEvent>>();
    private static final ExtensionEventTypeRegistry INSTANCE = new ExtensionEventTypeRegistry();

    private ExtensionEventTypeRegistry() {
    }

    public static ExtensionEventTypeRegistry getInstance() {
        return INSTANCE;
    }

    public synchronized <T extends ExtensionEvent> ExtensionEventType<T> register(String name, Class<T> clazz) {
        if (this.types.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Event type '%s' already exists!", name));
        }
        ExtensionEventType<T> t = new ExtensionEventType<T>(name, clazz);
        this.types.put(name, t);
        return t;
    }

    public ExtensionEventType<? extends ExtensionEvent> get(String name) {
        return this.types.get(name);
    }

    public Collection<ExtensionEventType<? extends ExtensionEvent>> getAll() {
        return Collections.unmodifiableCollection(this.types.values());
    }
}

