/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extension.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.extension.AbstractBridgeExtension;
import me.dexrn.rrdiscordbridge.extension.BridgeExtensionManager;
import me.dexrn.rrdiscordbridge.extension.loader.IExtensionLoader;

public class JarExtensionLoader
implements IExtensionLoader {
    @Override
    public void registerExtensions(BridgeExtensionManager manager) {
        File e = Paths.get(RRDiscordBridge.configDir.getPath(), "extensions").toFile();
        if (!e.exists()) {
            e.mkdirs();
        }
        URL[] jars = (URL[])Arrays.stream(Objects.requireNonNull(e.listFiles())).filter(j -> j.getName().endsWith(".jar")).map(j -> {
            try {
                return j.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                RRDiscordBridge.logger.error(String.format("Failed to load extension from %s: ", j.getName()), ex);
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        try (URLClassLoader l = new URLClassLoader(jars, this.getClass().getClassLoader());){
            ServiceLoader<AbstractBridgeExtension> loader = ServiceLoader.load(AbstractBridgeExtension.class, l);
            loader.forEach(manager::register);
        }
        catch (IOException ex) {
            RRDiscordBridge.logger.error("Couldn't load extensions: ", ex);
        }
    }
}

