/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extensions;

import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.util.List;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.discord.DiscordBot;
import me.dexrn.rrdiscordbridge.extension.AbstractBridgeExtension;
import me.dexrn.rrdiscordbridge.extension.config.ExtensionConfig;
import me.dexrn.rrdiscordbridge.extension.event.events.ExtensionEvents;
import me.dexrn.rrdiscordbridge.extension.event.events.chat.DiscordChatEvent;
import me.dexrn.rrdiscordbridge.extension.event.events.chat.MinecraftChatEvent;
import me.dexrn.rrdiscordbridge.extension.event.registry.ExtensionEventRegistry;
import me.dexrn.rrdiscordbridge.extension.types.ModifiableMessage;
import me.dexrn.rrdiscordbridge.extensions.options.OpChatExtensionOptions;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import org.jetbrains.annotations.Nullable;

public class OpChatExtension
extends AbstractBridgeExtension {
    private final Semver version = new Semver("1.2.1", Semver.SemverType.LOOSE);
    public WebhookClient opcWebhookClient;
    public Webhook opcWebhook;
    private ExtensionConfig config;
    private OpChatExtensionOptions options;

    @Override
    public String getName() {
        return "OpChat";
    }

    @Override
    public String getAuthor() {
        return "\u00a73Dexrn ZacAttack";
    }

    @Override
    public String getDescription() {
        return "\u00a7bA MCGalaxy inspired extension that allows players to send messages to all online OPs, and optionally a discord channel. \u00a79Syntax: \u00a7a## \u00a72<msg>";
    }

    @Override
    public void onEnable() {
        try {
            this.config = new ExtensionConfig(new OpChatExtensionOptions(), this.version, this.getName()).load();
            this.options = (OpChatExtensionOptions)this.config.options;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.options.channelId.isEmpty()) {
            RRDiscordBridge.logger.warn("OPChat channel ID was not specified. Disabling extension.");
            this.disable();
            return;
        }
        TextChannel opcChannel = RRDiscordBridge.instance.getBot().jda.getTextChannelById(this.options.channelId);
        if (opcChannel == null) {
            RRDiscordBridge.logger.warn("Failed to find OPChat channel with ID " + this.options.channelId);
            RRDiscordBridge.instance.getBridgeExtensions().enabledExtensions.remove(this);
            this.onDisable();
            return;
        }
        List<Webhook> webhooks = opcChannel.retrieveWebhooks().complete();
        this.opcWebhook = webhooks.stream().filter(hook -> {
            User owner = hook.getOwnerAsUser();
            if (owner == null) {
                return false;
            }
            return owner.getId().equals(RRDiscordBridge.instance.getBot().jda.getSelfUser().getId());
        }).findFirst().orElseGet(() -> (Webhook)opcChannel.createWebhook("RRMCBridgeOpChat").complete());
        WebhookClientBuilder opcBuilder = new WebhookClientBuilder(this.opcWebhook.getUrl());
        opcBuilder.setThreadFactory(job -> {
            Thread thread = new Thread(job);
            thread.setName("OpChatClient");
            thread.setDaemon(true);
            return thread;
        });
        opcBuilder.setWait(true);
        this.opcWebhookClient = opcBuilder.build();
        ExtensionEventRegistry.getInstance().register(this, ExtensionEvents.MINECRAFT_CHAT, this::onMinecraftChat);
        ExtensionEventRegistry.getInstance().register(this, ExtensionEvents.DISCORD_CHAT, this::onDiscordChat);
    }

    public void onMinecraftChat(MinecraftChatEvent ev) {
        IPlayer player = ev.getPlayer();
        ModifiableMessage<String> res = ev.getResult();
        if (!((String)res.message).trim().startsWith("##")) {
            return;
        }
        res.message = ((String)res.message).trim().substring(2).trim();
        if (((String)res.message).isEmpty()) {
            return;
        }
        res.cancelSendToDiscord();
        res.cancelSendToMinecraft();
        ExtensionConfig config = this.getConfig();
        if (config == null || !player.isOperator() && !((OpChatExtensionOptions)config.options).nonOpsCanSendMessages) {
            player.sendMessage("\u00a7cOnly operators are allowed to talk in OpChat.");
            return;
        }
        String opcMsg = String.format("\u00a7b[\u00a7r%s \u00a7b-> \u00a76OPs\u00a7b] \u00a7r%s", player.getName(), res.message);
        RRDiscordBridge.logger.info(String.format("[%s -> OPs] %s", player.getName(), res.message));
        player.sendMessage(opcMsg);
        for (IPlayer p : player.getServer().getOnlinePlayers()) {
            if (!p.isOperator() || p.getName().equals(player.getName())) continue;
            p.sendMessage(opcMsg);
        }
        if (!this.options.channelId.isEmpty()) {
            DiscordBot.sendPlayerMessage(player.getName(), (String)res.message, this.opcWebhookClient);
        }
    }

    public void onDiscordChat(DiscordChatEvent ev) {
        Message message = ev.getMessage();
        ModifiableMessage<Message> res = ev.getResult();
        String author = message.getAuthor().getId();
        if (message.getChannelId().equals(this.options.channelId) && !author.equals(RRDiscordBridge.instance.getBot().self.getId()) && !author.equals(this.opcWebhook.getId()) && !author.equals(RRDiscordBridge.instance.getBot().webhook.getId())) {
            ev.getResult().cancelSendToMinecraft();
            String msg = String.format("\u00a7b[\u00a76OPChat\u00a7b - \u00a7e%s\u00a7b]\u00a7r %s", DiscordBot.getName(message.getAuthor()), message.getContentRaw());
            RRDiscordBridge.logger.info(msg);
            for (IPlayer p : RRDiscordBridge.instance.getServer().getOnlinePlayers()) {
                if (!p.isOperator()) continue;
                p.sendMessage(msg);
            }
        }
    }

    @Override
    public void onDisable() {
        ExtensionEventRegistry.getInstance().unregisterAll(this);
        this.config = null;
        this.opcWebhook = null;
        if (this.opcWebhookClient != null) {
            this.opcWebhookClient.close();
            this.opcWebhookClient = null;
        }
    }

    @Override
    public void onRegister(RRDiscordBridge instance) {
    }

    @Override
    @Nullable
    public ExtensionConfig getConfig() {
        return this.config;
    }

    @Override
    public Semver getVersion() {
        return this.version;
    }
}

