/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.extensions;

import club.minnced.discord.webhook.send.AllowedMentions;
import club.minnced.discord.webhook.send.WebhookEmbed;
import club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import club.minnced.discord.webhook.send.WebhookMessage;
import club.minnced.discord.webhook.send.WebhookMessageBuilder;
import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.extension.AbstractBridgeExtension;
import me.dexrn.rrdiscordbridge.extension.config.ExtensionConfig;
import me.dexrn.rrdiscordbridge.extension.event.events.ExtensionEvents;
import me.dexrn.rrdiscordbridge.extension.event.events.chat.MinecraftChatEvent;
import me.dexrn.rrdiscordbridge.extension.event.registry.ExtensionEventRegistry;
import me.dexrn.rrdiscordbridge.extension.types.ModifiableMessage;
import me.dexrn.rrdiscordbridge.extensions.options.WaypointExtensionOptions;
import me.dexrn.rrdiscordbridge.extensions.waypoints.Waypoint;
import me.dexrn.rrdiscordbridge.extensions.waypoints.WaypointType;
import me.dexrn.rrdiscordbridge.helpers.ColorHelper;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import org.jetbrains.annotations.Nullable;

public class WaypointExtension
extends AbstractBridgeExtension {
    private final Semver version = new Semver("1.2.1", Semver.SemverType.LOOSE);
    public WaypointExtensionOptions options;
    public ExtensionConfig config;

    @Override
    public String getName() {
        return "Waypoints";
    }

    @Override
    public String getAuthor() {
        return "\u00a73Dexrn ZacAttack";
    }

    @Override
    public String getDescription() {
        return "\u00a7bSends a human readable webhook message to Discord instead of the normal waypoint text that most mods send.";
    }

    @Override
    public void onRegister(RRDiscordBridge instance) {
    }

    @Override
    public void onEnable() {
        try {
            this.config = new ExtensionConfig(new WaypointExtensionOptions(), this.version, this.getName()).load();
            this.options = (WaypointExtensionOptions)this.config.options;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ExtensionEventRegistry.getInstance().register(this, ExtensionEvents.MINECRAFT_CHAT, this::onMinecraftChat);
    }

    @Override
    public void onDisable() {
        ExtensionEventRegistry.getInstance().unregisterAll(this);
    }

    public void onMinecraftChat(MinecraftChatEvent ev) {
        String message = ev.getMessage();
        IPlayer player = ev.getPlayer();
        ModifiableMessage<String> res = ev.getResult();
        try {
            Waypoint waypoint = Arrays.stream(WaypointType.values()).filter(w -> w.getValidator().test(message)).findFirst().map(w -> w.getFromString().apply(message)).orElseThrow(() -> new IllegalArgumentException("Invalid waypoint: " + message));
            AllowedMentions allowedMentions = new AllowedMentions().withParseUsers(true).withParseEveryone(false);
            WebhookEmbedBuilder embedBuilder = new WebhookEmbedBuilder();
            embedBuilder.setAuthor(new WebhookEmbed.EmbedAuthor(String.format("%s shared %swaypoint", player.getName(), waypoint.getType() == WaypointType.XAEROS ? "an Xaero's Minimap " : "a JourneyMap/VoxelMap "), null, null)).setTitle(new WebhookEmbed.EmbedTitle(waypoint.getName(), null)).addField(new WebhookEmbed.EmbedField(true, "X", waypoint.getX())).addField(new WebhookEmbed.EmbedField(true, "Y", waypoint.getY())).addField(new WebhookEmbed.EmbedField(true, "Z", waypoint.getZ()));
            String badge = URLEncoder.encode(waypoint.getBadge(), "UTF-8");
            if (this.options.waypointBadge.useBadgeImage && waypoint.getColor() != null && !badge.isEmpty()) {
                embedBuilder.setThumbnailUrl(String.format(this.options.waypointBadge.url, this.options.waypointBadge.width, this.options.waypointBadge.height, ColorHelper.getRgbHex(waypoint.getColor().getRGB()), ColorHelper.getRgbHex(this.options.waypointBadge.textColor), badge));
            }
            if (!waypoint.getDimension().isEmpty()) {
                embedBuilder.setFooter(new WebhookEmbed.EmbedFooter(waypoint.getDimension(), null));
            }
            if (waypoint.getColor() != null) {
                embedBuilder.setColor(waypoint.getColor().getRGB());
            }
            WebhookEmbed embed = embedBuilder.build();
            WebhookMessage wMessage = new WebhookMessageBuilder().setUsername(player.getName()).setAvatarUrl(String.format(RRDiscordBridge.instance.getSettings().skinProvider, player.getName())).addEmbeds(embed).setAllowedMentions(allowedMentions).build();
            RRDiscordBridge.instance.getBot().webhookClient.send(wMessage);
            ev.getResult().cancelSendToDiscord();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public ExtensionConfig getConfig() {
        return this.config;
    }

    @Override
    public Semver getVersion() {
        return this.version;
    }
}

