/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.game;

import java.awt.Color;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;

public enum FormattingCodes {
    BLACK('0', new Color(0, 0, 0)),
    DARK_BLUE('1', new Color(0, 0, 170)),
    DARK_GREEN('2', new Color(0, 170, 0)),
    DARK_AQUA('3', new Color(0, 170, 170)),
    DARK_RED('4', new Color(170, 0, 0)),
    DARK_PURPLE('5', new Color(170, 0, 170)),
    GOLD('6', new Color(255, 170, 0)),
    GRAY('7', new Color(170, 170, 170)),
    DARK_GRAY('8', new Color(85, 85, 85)),
    BLUE('9', new Color(85, 85, 255)),
    GREEN('a', new Color(85, 255, 85)),
    AQUA('b', new Color(85, 255, 255)),
    RED('c', new Color(255, 85, 85)),
    LIGHT_PURPLE('d', new Color(255, 85, 255)),
    YELLOW('e', new Color(255, 255, 85)),
    WHITE('f', new Color(255, 255, 255)),
    OBFUSCATED('k', null),
    BOLD('l', null),
    STRIKETHROUGH('m', null),
    UNDERLINE('n', null),
    ITALIC('o', null),
    RESET('r', null);

    private final char code;
    private final Color color;

    private FormattingCodes(char code, Color color) {
        this.code = code;
        this.color = color;
    }

    public static FormattingCodes fromCode(char code) {
        for (FormattingCodes formattingCode : FormattingCodes.values()) {
            if (formattingCode.code != code) continue;
            return formattingCode;
        }
        throw new IllegalArgumentException("Invalid formatting code: " + code);
    }

    public static String removeDcFormatting(String s) {
        if (s == null) {
            return null;
        }
        if (RRDiscordBridge.instance.getSettings().stripMc2DcFormatting) {
            return FormattingCodes.removeFormatting(s);
        }
        return s;
    }

    public char getCode() {
        return this.code;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return "\u00a7" + this.code;
    }

    public static char getPrefix() {
        return '\u00a7';
    }

    public static String removeFormatting(String s) {
        char[] c = s.toCharArray();
        StringBuilder n = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == FormattingCodes.getPrefix() && i + 1 < c.length) {
                try {
                    FormattingCodes.fromCode(c[i + 1]);
                    ++i;
                }
                catch (IllegalArgumentException ignored) {
                    n.append(c[i]);
                }
                continue;
            }
            n.append(c[i]);
        }
        return n.toString();
    }

    public boolean isFormattingOnly() {
        return this.color == null;
    }
}

