/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.impls;

import java.util.function.Function;
import me.dexrn.rrdiscordbridge.RRDiscordBridge;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import me.dexrn.rrdiscordbridge.interfaces.IServer;

public abstract class AbstractEventHandler<ServerT extends IServer, PlayerT extends IPlayer, MinecraftServerT, MinecraftPlayerT> {
    private final Function<MinecraftServerT, ServerT> serverFactory;
    private final Function<MinecraftPlayerT, PlayerT> playerFactory;

    public AbstractEventHandler(Function<MinecraftServerT, ServerT> server, Function<MinecraftPlayerT, PlayerT> player) {
        RRDiscordBridge.logger.info(String.format("Registered mod event handler '%s'", this.getClass().getName()));
        this.serverFactory = server;
        this.playerFactory = player;
    }

    public PlayerT createPlayer(MinecraftPlayerT p) {
        return (PlayerT)((IPlayer)this.playerFactory.apply(p));
    }

    public ServerT createServer(MinecraftServerT s) {
        return (ServerT)((IServer)this.serverFactory.apply(s));
    }
}

