/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.impls.vanilla;

import java.util.Objects;
import me.dexrn.rrdiscordbridge.impls.vanilla.ModernMinecraftServer;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import me.dexrn.rrdiscordbridge.interfaces.IServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ModernMinecraftPlayer
implements IPlayer {
    protected final ServerPlayer player;

    public ModernMinecraftPlayer(ServerPlayer player) {
        this.player = player;
    }

    @Override
    public boolean isOperator() {
        return Objects.requireNonNull(this.player.getServer()).getProfilePermissions(this.player.getGameProfile()) > 1;
    }

    @Override
    public String getName() {
        return this.player.getName().getString();
    }

    @Override
    public void sendMessage(String message) {
        this.player.displayClientMessage((Component)Component.literal((String)message), false);
    }

    @Override
    public boolean hasPlayedBefore() {
        return true;
    }

    @Override
    public IServer getServer() {
        return new ModernMinecraftServer(this.player.getServer());
    }
}

