/*
 * Decompiled with CFR 0.152.
 */
package me.dexrn.rrdiscordbridge.impls.vanilla;

import java.io.InputStream;
import java.util.Objects;
import java.util.UUID;
import me.dexrn.rrdiscordbridge.impls.vanilla.ModernMinecraftPlayer;
import me.dexrn.rrdiscordbridge.interfaces.IPlayer;
import me.dexrn.rrdiscordbridge.interfaces.IServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;

public class ModernMinecraftServer
implements IServer {
    protected final MinecraftServer server;

    public ModernMinecraftServer(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void broadcastMessage(String message) {
        this.server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)message), false);
    }

    @Override
    public IPlayer[] getOnlinePlayers() {
        return (IPlayer[])this.server.getPlayerList().getPlayers().stream().filter(Objects::nonNull).map(ModernMinecraftPlayer::new).toArray(IPlayer[]::new);
    }

    @Override
    public String[] getOperators() {
        return this.server.getPlayerList().getOps().getUserList();
    }

    @Override
    public IPlayer getPlayer(String name) {
        return new ModernMinecraftPlayer(this.server.getPlayerList().getPlayerByName(name));
    }

    public IPlayer getPlayer(UUID id) {
        return new ModernMinecraftPlayer(this.server.getPlayerList().getPlayer(id));
    }

    @Override
    public InputStream getResource(String path) {
        return null;
    }

    @Override
    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getMotd() {
        return this.server.getMotd();
    }

    @Override
    public String getVersion() {
        return "Minecraft " + this.server.getServerVersion();
    }

    @Override
    public String getSoftwareName() {
        return "Minecraft";
    }

    @Override
    public void runCommand(String command) {
        if (this.server.isDedicatedServer()) {
            ((DedicatedServer)this.server).handleConsoleInput(command, this.server.createCommandSourceStack());
        }
    }
}

