/*
 * Decompiled with CFR 0.152.
 */
package me.scarsz.jdaappender;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import me.scarsz.jdaappender.HandlerConfig;
import me.scarsz.jdaappender.IChannelLoggingHandler;
import me.scarsz.jdaappender.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogItem {
    public static final int CLIPPING_MAX_LENGTH = 1980;
    private final IChannelLoggingHandler handler;
    private final String logger;
    private final long timestamp;
    private final LogLevel level;
    @Nullable
    private String message;
    @Nullable
    private final Throwable throwable;
    private static final Pattern colorPattern = Pattern.compile("\u001b\\[[\\d;]*m");

    public LogItem(IChannelLoggingHandler handler, String logger, LogLevel level, String message) {
        this(handler, logger, System.currentTimeMillis(), level, message, null);
    }

    public LogItem(IChannelLoggingHandler handler, String logger, long timestamp, LogLevel level, @Nullable String message, @Nullable Throwable throwable) {
        this.handler = handler;
        this.logger = logger;
        this.timestamp = timestamp;
        this.level = level;
        this.message = message;
        this.throwable = throwable;
    }

    protected String format(@NotNull HandlerConfig config) {
        String s;
        StringBuilder builder = new StringBuilder();
        if (config.getPrefixer() != null) {
            builder.append(config.getPrefixer().apply(this));
        }
        if (this.message != null) {
            builder.append(config.isUseCodeBlocks() ? this.message.replace("```", "`\u200b`\u200b`\u200b") : this.handler.escapeMarkdown(this.message));
        }
        if (config.getSuffixer() != null) {
            builder.append(config.getSuffixer().apply(this));
        }
        if (this.throwable != null) {
            try (StringWriter stringWriter2 = new StringWriter();
                 PrintWriter printWriter = new PrintWriter(stringWriter2);){
                this.throwable.printStackTrace(printWriter);
                builder.append('\n');
                builder.append(stringWriter2);
            }
            catch (IOException stringWriter2) {
                // empty catch block
            }
        }
        return (s = builder.toString()).length() > 1980 ? s.substring(0, 1980) : s;
    }

    protected LogItem clip(@NotNull HandlerConfig config) {
        Iterator<LogItem> clip = this.clip(config, 1).iterator();
        return clip.hasNext() ? clip.next() : null;
    }

    protected Set<LogItem> clip(@NotNull HandlerConfig config, int max) {
        LinkedHashSet<LogItem> items = new LinkedHashSet<LogItem>();
        LogItem bottom = this;
        int formattingLength = config.getFormattingLength(bottom);
        int i = 0;
        while (this.message != null && !this.message.isEmpty() && i < max && this.message.length() + formattingLength >= 1980) {
            formattingLength = config.getFormattingLength(bottom);
            int cutoff = 1980 - formattingLength;
            int pulledCharacterCount = Math.min(cutoff, bottom.message.length());
            String remaining = this.substring(bottom.message, pulledCharacterCount);
            bottom.message = LogItem.substring(bottom.message, 0, pulledCharacterCount);
            if (remaining == null || remaining.isEmpty() || ++i == max) break;
            bottom = this.clone(remaining);
            if (bottom.message == null) {
                return items;
            }
            items.add(bottom);
        }
        return items;
    }

    public static String stripColors(@NotNull String str) {
        return colorPattern.matcher(str).replaceAll("");
    }

    @Nullable
    private String substring(String str, int start) {
        return LogItem.substring(str, start, str.length());
    }

    @Nullable
    private static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end += str.length();
        }
        if (start < 0) {
            start = 0;
        }
        if (end > str.length()) {
            end = str.length();
        }
        return start > end ? "" : str.substring(start, end);
    }

    public int getFormattedLength(HandlerConfig config) {
        return this.format(config).length();
    }

    public LogItem clone(String message) {
        return new LogItem(this.handler, this.logger, this.timestamp, this.level, message, this.throwable);
    }

    public String toString() {
        return "LogItem{logger='" + this.logger + '\'' + ", level=" + (Object)((Object)this.level) + (this.message != null ? ", message[" + this.message.length() + "]='" + (this.message.length() <= 100 ? this.message : this.message.substring(0, 100)) + '\'' : ", message[]=\"null") + '}';
    }

    @Generated
    public IChannelLoggingHandler getHandler() {
        return this.handler;
    }

    @Generated
    public String getLogger() {
        return this.logger;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public LogLevel getLevel() {
        return this.level;
    }

    @Nullable
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @Generated
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Generated
    void setMessage(@Nullable String message) {
        this.message = message;
    }
}

