/*
 * Decompiled with CFR 0.152.
 */
package me.scarsz.jdaappender.adapter;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import me.scarsz.jdaappender.IChannelLoggingHandler;
import me.scarsz.jdaappender.LogItem;
import me.scarsz.jdaappender.LogLevel;

public class JavaLoggingAdapter
extends Handler {
    private final IChannelLoggingHandler handler;

    public JavaLoggingAdapter(IChannelLoggingHandler handler) {
        this.handler = handler;
    }

    @Override
    public void publish(LogRecord record) {
        LogLevel level;
        LogLevel logLevel = record.getLevel() == Level.INFO ? LogLevel.INFO : (record.getLevel() == Level.WARNING ? LogLevel.WARN : (record.getLevel() == Level.SEVERE ? LogLevel.ERROR : (level = record.getLevel() == Level.FINE ? LogLevel.DEBUG : null)));
        if (level != null) {
            this.handler.enqueue(new LogItem(this.handler, record.getLoggerName(), record.getMillis(), level, LogItem.stripColors(record.getMessage()), record.getThrown()));
        }
    }

    @Override
    public void flush() {
        this.handler.flush();
    }

    @Override
    public void close() throws SecurityException {
        ScheduledFuture<?> f = this.handler.getScheduledFuture();
        if (f != null) {
            f.cancel(false);
            try {
                f.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

