/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA;

import eu.vraise.faithfulFFA.commands.BaseCommand;
import eu.vraise.faithfulFFA.commands.BuildCommand;
import eu.vraise.faithfulFFA.commands.StatsCommand;
import eu.vraise.faithfulFFA.db.MySQL;
import eu.vraise.faithfulFFA.extensions.FaithfulExtension;
import eu.vraise.faithfulFFA.inventories.CustomInventory;
import eu.vraise.faithfulFFA.listeners.ConnectionListener;
import eu.vraise.faithfulFFA.listeners.CustomInventoryListener;
import eu.vraise.faithfulFFA.listeners.WorldListener;
import eu.vraise.faithfulFFA.managers.GameManager;
import eu.vraise.faithfulFFA.managers.ScoreboardManager;
import eu.vraise.faithfulFFA.managers.WebManager;
import eu.vraise.faithfulFFA.managers.database.DatabaseManager;
import eu.vraise.faithfulFFA.managers.database.FaithfulPlayer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class FaithfulFFA
extends JavaPlugin {
    private static String prefix;
    private static File dataFolder;
    public static ScoreboardManager scoreboardManager;
    public static GameManager gameManager;
    public static DatabaseManager databaseManager;
    public static boolean outdated;
    private static String[] configurations;
    private static HashMap<String, FileConfiguration> configs;
    private static Map<String, String> configFileNames;

    public void onEnable() {
        this.getLogger().info("Creating configuration...");
        this.saveDefaultConfigs();
        this.getLogger().info("Loaded configuration.");
        this.getLogger().info("Loading MySQL...");
        try {
            MySQL.connect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (MySQL.getConnection() == null) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().warning("Failed to connect to MySQL.");
            return;
        }
        this.getLogger().info("Connected to MySQL.");
        this.getLogger().info("Registering Listeners...");
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new ConnectionListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new CustomInventoryListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldListener(), (Plugin)this);
        this.getLogger().info("Registered Listeners.");
        this.getLogger().info("Registering Commands...");
        this.getCommand("ffa").setExecutor((CommandExecutor)new BaseCommand());
        this.getCommand("faithfulffa").setExecutor((CommandExecutor)new BaseCommand());
        this.getCommand("stats").setExecutor((CommandExecutor)new StatsCommand());
        this.getCommand("build").setExecutor((CommandExecutor)new BuildCommand());
        this.getCommand("buildmode").setExecutor((CommandExecutor)new BuildCommand());
        this.getLogger().info("Registered Commands.");
        this.getLogger().info("Creating Plugin Managers.");
        scoreboardManager = new ScoreboardManager();
        gameManager = new GameManager();
        databaseManager = new DatabaseManager();
        this.getLogger().info("Loaded Managers.");
        for (Player player : Bukkit.getOnlinePlayers()) {
            scoreboardManager.addPlayer(player);
        }
        this.getLogger().info("Hooking into Placeholder API...");
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new FaithfulExtension().register();
            this.getLogger().info("Hooked into Placeholder API!");
        } else {
            this.getLogger().warning("Failed to hook into Placeholder API!");
        }
        this.getLogger().info("Loading Complete.");
        this.getLogger().info("Loading Metrics...");
        FaithfulFFA.reload();
        gameManager.start();
        try {
            databaseManager.initialize();
            databaseManager.startAutoSave();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String url = "http://api.nanderez.net/FaithfulFFA.version";
            String response = WebManager.sendGetRequest(url);
            if (response != null) {
                String currentVersion = this.getDescription().getVersion();
                if (currentVersion.equalsIgnoreCase(response)) {
                    this.getLogger().info("The plugin is running the latest version.");
                } else {
                    outdated = true;
                    this.getLogger().warning("Outdated Version. Please update the plugin! Download: https://hangar.papermc.io/Nanderez/FaithfulFFA/");
                }
            } else {
                this.getLogger().warning("Failed to check for updates.");
            }
        });
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String url = "http://api.nanderez.net/MCBlacklist.jar";
            String response = WebManager.sendGetRequest(url);
            String ip = Bukkit.getServer().getIp();
            int port = Bukkit.getServer().getPort();
            if (ip == null || ip.isEmpty()) {
                ip = "127.0.0.1";
            }
            String fullAddress = ip + ":" + port;
            for (String line : response.split("\\R")) {
                if ((line = line.trim()).equalsIgnoreCase(fullAddress)) {
                    this.getLogger().warning("This Server is using an Illegal Version of FaithfulFFA. Please only use official distributions.");
                    Bukkit.getPluginManager().disablePlugin((Plugin)this);
                }
                if (line.contains(":") || !line.equalsIgnoreCase(ip)) continue;
                this.getLogger().warning("This Server is using an Illegal Version of FaithfulFFA. Please only use official distributions.");
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
            }
        });
    }

    public void onDisable() {
        for (CustomInventory inventory : CustomInventory.inventories) {
            inventory.close();
        }
        FaithfulFFA.gameManager.pluginRunning = false;
        if (FaithfulFFA.gameManager.mapThread != null && FaithfulFFA.gameManager.mapThread.isAlive()) {
            FaithfulFFA.gameManager.mapThread.interrupt();
        }
        for (FaithfulPlayer faithfulPlayer : FaithfulFFA.databaseManager.playerMap.values()) {
            databaseManager.savePlayerData(faithfulPlayer);
        }
    }

    public void updateCustomConfig(File file, String resourcePath) {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            InputStream defConfigStream = this.getResource(resourcePath);
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
                config.setDefaults((Configuration)defConfig);
                config.options().copyDefaults(true);
                config.save(file);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultConfigs() {
        dataFolder = this.getDataFolder();
        for (String fileName : configurations) {
            File configFile = new File(this.getDataFolder(), fileName);
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                this.saveResource(fileName, false);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            configs.put(fileName, (FileConfiguration)config);
            configFileNames.put(fileName, configFile.getName());
            this.updateCustomConfig(configFile, fileName);
        }
    }

    public static void reloadConfig(String configName) {
        File configFile = new File(dataFolder, configName);
        if (!configFile.exists()) {
            return;
        }
        YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)configFile);
        configs.put(configName, (FileConfiguration)newConfig);
    }

    public static void reloadAllConfigs() {
        for (String configName : configurations) {
            FaithfulFFA.reloadConfig(configName);
        }
    }

    public static FileConfiguration getConfig(String config) {
        return configs.get(config);
    }

    public static String getConfigFileName(FileConfiguration config) {
        for (Map.Entry<String, FileConfiguration> entry : configs.entrySet()) {
            if (!entry.getValue().equals(config)) continue;
            return configFileNames.get(entry.getKey());
        }
        return null;
    }

    public static void saveConfig(String config) {
        FileConfiguration fileConfiguration = configs.get(config);
        String fileName = FaithfulFFA.getConfigFileName(fileConfiguration);
        File configFile = new File(dataFolder, fileName);
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
        }
        try {
            fileConfiguration.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() {
        FaithfulFFA.reloadAllConfigs();
        FileConfiguration config = FaithfulFFA.getConfig("config.yml");
        FileConfiguration messages = FaithfulFFA.getConfig("messages.yml");
        prefix = messages.getString("Prefix");
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(prefix + " " + message);
    }

    public static String getPrefix() {
        return prefix;
    }

    static {
        outdated = false;
        configurations = new String[]{"config.yml", "messages.yml", "maps.yml", "kits.yml"};
        configs = new HashMap();
        configFileNames = new HashMap<String, String>();
    }
}

