/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.db;

import eu.vraise.faithfulFFA.FaithfulFFA;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class MySQL {
    public static boolean allow_usage = false;
    private static Connection connection;

    public static void connect() throws SQLException {
        PreparedStatement ps;
        if (connection != null && !connection.isClosed()) {
            return;
        }
        FileConfiguration config = FaithfulFFA.getConfig("config.yml");
        String host = config.getString("Storage.Host");
        int port = config.getInt("Storage.Port");
        String database = config.getString("Storage.Database");
        String username = config.getString("Storage.Username");
        String password = config.getString("Storage.Password");
        String url = "jdbc:mysql://" + host + ":" + port + "/" + database;
        connection = DriverManager.getConnection(url, username, password);
        if (connection != null && !connection.isClosed()) {
            allow_usage = true;
        }
        Bukkit.getLogger().info("Creating default ffa_faithful table!");
        PreparedStatement statement = MySQL.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS ffa_faithful (uuid VARCHAR(999) UNIQUE NOT NULL,kills INT(255) DEFAULT 0,deaths INT(255) DEFAULT 0,blocksPlaced BIGINT DEFAULT 0,killStreak INT(255) DEFAULT 0,kit VARCHAR(255) DEFAULT 'default');");
        statement.executeUpdate();
        Bukkit.getLogger().info("Created MySQL table ffa_faithful!");
        String alterTable = "ALTER TABLE ffa_faithful ADD COLUMN IF NOT EXISTS killStreak INT(255) DEFAULT 0;";
        try {
            ps = MySQL.getConnection().prepareStatement(alterTable);
            try {
                ps.execute();
                System.out.println("Patched 'killStreak' to ffa_faithful table. (since 0.0.4-beta)");
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        alterTable = "ALTER TABLE ffa_faithful ADD COLUMN IF NOT EXISTS kit VARCHAR(255) DEFAULT 'default';";
        try {
            ps = MySQL.getConnection().prepareStatement(alterTable);
            try {
                ps.execute();
                System.out.println("Patched 'kit' to ffa_faithful table. (since 0.0.5-beta)");
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Bukkit.getLogger().info("Patched ffa_faithful for latest update!");
    }

    public static void disconnect() throws SQLException {
        if (connection != null && !connection.isClosed()) {
            connection.close();
            Bukkit.getLogger().info("MySQL disconnected.");
        }
    }

    public static Connection getConnection() {
        if (!allow_usage) {
            return null;
        }
        try {
            if (connection == null || connection.isClosed()) {
                MySQL.connect();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return connection;
    }
}

