/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.extensions;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.managers.database.FaithfulPlayer;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class FaithfulExtension
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "faithful";
    }

    @NotNull
    public String getAuthor() {
        return "Nanderez";
    }

    @NotNull
    public String getVersion() {
        return ((FaithfulFFA)FaithfulFFA.getPlugin(FaithfulFFA.class)).getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        switch (identifier.toLowerCase()) {
            case "online": {
                return "" + Bukkit.getOnlinePlayers().size();
            }
            case "max_online": {
                return "" + Bukkit.getServer().getMaxPlayers();
            }
            case "kills": {
                return String.valueOf(FaithfulFFA.databaseManager.getPlayer((UUID)player.getUniqueId()).kills);
            }
            case "deaths": {
                return String.valueOf(FaithfulFFA.databaseManager.getPlayer((UUID)player.getUniqueId()).deaths);
            }
            case "killstreak": {
                return String.valueOf(FaithfulFFA.databaseManager.getPlayer((UUID)player.getUniqueId()).killStreak);
            }
            case "kit": {
                return String.valueOf(FaithfulFFA.databaseManager.getPlayer((UUID)player.getUniqueId()).kit);
            }
            case "kd": {
                FaithfulPlayer faithfulPlayer = FaithfulFFA.databaseManager.getPlayer(player.getUniqueId());
                double kd = faithfulPlayer.deaths == 0 ? (double)faithfulPlayer.kills : (double)faithfulPlayer.kills / (double)faithfulPlayer.deaths;
                return String.format("%.2f", kd);
            }
            case "map": {
                return FaithfulFFA.gameManager.name;
            }
            case "time_remaining": {
                long end = FaithfulFFA.gameManager.endTime;
                long currentTime = System.currentTimeMillis();
                long remainingTime = end - currentTime;
                if (remainingTime < 0L) {
                    remainingTime = 0L;
                }
                long hours = remainingTime / 3600000L;
                long minutes = remainingTime % 3600000L / 60000L;
                long seconds = remainingTime % 60000L / 1000L;
                String timeFormatted = hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
                return timeFormatted;
            }
        }
        return null;
    }
}

