/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.guis;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.guis.Gui;
import eu.vraise.faithfulFFA.guis.KitPreviewGui;
import eu.vraise.faithfulFFA.managers.database.FaithfulPlayer;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitGui
extends Gui {
    public KitGui(Player player) {
        super(player, FaithfulFFA.getConfig("messages.yml").getString("Gui.Kits.Title"), 6);
    }

    @Override
    public void onUpdate() {
        FileConfiguration messageConfig = FaithfulFFA.getConfig("messages.yml");
        FileConfiguration kitsConfig = FaithfulFFA.getConfig("kits.yml");
        ItemStack closeStack = new ItemStack(Material.BOOK);
        ItemMeta closeMeta = closeStack.getItemMeta();
        closeMeta.setDisplayName(messageConfig.getString("Gui.Kits.Close"));
        closeStack.setItemMeta(closeMeta);
        int kits = kitsConfig.getConfigurationSection("Kits").getKeys(false).size();
        boolean kitIndex = false;
        int[] slots = new int[]{4, 12, 14, 20, 24, 28, 34, 38, 42};
        ArrayList<Integer> usedSlots = new ArrayList<Integer>();
        int i = 0;
        for (String index : kitsConfig.getConfigurationSection("Kits").getKeys(false)) {
            ConfigurationSection kitSection = kitsConfig.getConfigurationSection("Kits." + index);
            ItemStack kitStack = new ItemStack(Material.valueOf((String)kitSection.getString("Preview")), 1);
            ItemMeta kitMeta = kitStack.getItemMeta();
            kitMeta.setDisplayName(kitSection.getString("Name"));
            ArrayList<String> kitLore = new ArrayList<String>();
            for (Object lore : kitSection.getList("Description")) {
                kitLore.add(lore.toString());
            }
            kitMeta.setLore(kitLore);
            kitStack.setItemMeta(kitMeta);
            this.inventory.setItem(slots[i], kitStack);
            usedSlots.add(slots[i]);
            ++i;
        }
        for (Object slot : (Object)slots) {
            if (usedSlots.contains((int)slot)) continue;
            ItemStack unknownStack = new ItemStack(Material.BARRIER, 1);
            ItemMeta unknownMeta = unknownStack.getItemMeta();
            unknownMeta.setDisplayName(messageConfig.getString("Gui.Kits.Unknown.Name"));
            ArrayList<String> kitLore = new ArrayList<String>();
            for (Object lore : messageConfig.getConfigurationSection("Gui.Kits.Unknown").getList("Description")) {
                kitLore.add(lore.toString());
            }
            unknownMeta.setLore(kitLore);
            unknownStack.setItemMeta(unknownMeta);
            this.inventory.setItem((int)slot, unknownStack);
        }
        this.inventory.setItem(this.inventory.getSize() - 5, closeStack);
        super.onUpdate();
    }

    @Override
    public void onClick(int slot, ClickType clickType) {
        if (slot == this.inventory.getSize() - 5) {
            this.player.closeInventory();
            super.close();
        }
        int[] slots = new int[]{4, 12, 14, 20, 24, 28, 34, 38, 42};
        FileConfiguration kitsConfig = FaithfulFFA.getConfig("kits.yml");
        FileConfiguration messageConfig = FaithfulFFA.getConfig("messages.yml");
        int i = 0;
        for (String index : kitsConfig.getConfigurationSection("Kits").getKeys(false)) {
            ConfigurationSection kitSection = kitsConfig.getConfigurationSection("Kits." + index);
            if (slot == slots[i]) {
                if (clickType.isLeftClick()) {
                    FaithfulPlayer faithfulPlayer = FaithfulFFA.databaseManager.getPlayer(this.player);
                    if (this.player.hasPermission("faithful.kits." + index)) {
                        faithfulPlayer.kit = index;
                        FaithfulFFA.sendMessage(this.player, messageConfig.getString("Player.Kit").replaceAll("%kit%", kitSection.getString("Name")));
                        this.player.closeInventory();
                        super.close();
                    } else {
                        FaithfulFFA.sendMessage(this.player, messageConfig.getString("Player.KitNoPerms").replaceAll("%permission%", "faithful.kits." + index));
                        this.player.closeInventory();
                        super.close();
                    }
                } else if (clickType.isRightClick()) {
                    this.player.closeInventory();
                    super.close();
                    KitPreviewGui kitPreviewGui = new KitPreviewGui(this.player, index);
                    kitPreviewGui.load();
                }
            }
            ++i;
        }
        super.onClick(slot, clickType);
    }
}

