/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.guis;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.guis.Gui;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitPreviewGui
extends Gui {
    public String kit;

    public KitPreviewGui(Player player, String kit) {
        super(player, FaithfulFFA.getConfig("messages.yml").getString("Gui.KitPreview.Title").replaceAll("%kit%", FaithfulFFA.getConfig("kits.yml").getString("Kits." + kit + ".Name")), 4);
        this.kit = kit;
    }

    @Override
    public void onUpdate() {
        ItemStack filler;
        int i;
        FileConfiguration messageConfig = FaithfulFFA.getConfig("messages.yml");
        FileConfiguration kitsConfig = FaithfulFFA.getConfig("kits.yml");
        for (i = 9; i < 18; ++i) {
            filler = new ItemStack(Material.AIR, 1);
            this.inventory.setItem(i, filler);
        }
        for (i = 18; i < this.inventory.getSize() - 9; ++i) {
            filler = new ItemStack(Material.AIR, 1);
            this.inventory.setItem(i, filler);
        }
        ItemStack closeStack = new ItemStack(Material.BOOK);
        ItemMeta closeMeta = closeStack.getItemMeta();
        closeMeta.setDisplayName(messageConfig.getString("Gui.Kits.Close"));
        closeStack.setItemMeta(closeMeta);
        ConfigurationSection kitSection = kitsConfig.getConfigurationSection("Kits." + this.kit);
        ItemStack previewStack = new ItemStack(Material.valueOf((String)kitSection.getString("Preview")));
        ItemMeta previewMeta = previewStack.getItemMeta();
        previewMeta.setDisplayName(kitSection.getString("Name"));
        ArrayList<String> kitLore = new ArrayList<String>();
        for (Object lore : kitSection.getList("Description")) {
            kitLore.add(lore.toString());
        }
        previewMeta.setLore(kitLore);
        previewStack.setItemMeta(previewMeta);
        int negativeExpand = 0;
        ConfigurationSection itemsSection = kitSection.getConfigurationSection("Items");
        for (String itemKey : itemsSection.getKeys(false)) {
            ConfigurationSection itemConfig = itemsSection.getConfigurationSection(itemKey);
            Material material = Material.valueOf((String)itemConfig.getString("Item"));
            int amount = itemConfig.getInt("Count");
            String name = itemConfig.getString("Name");
            int slot = itemConfig.getInt("Slot");
            ItemStack item = new ItemStack(material, amount);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(name);
            ConfigurationSection enchantsSection = itemConfig.getConfigurationSection("Enchantments");
            if (enchantsSection != null) {
                for (String enchantKey : enchantsSection.getKeys(false)) {
                    Enchantment enchant = Enchantment.getByName((String)enchantKey.toUpperCase());
                    int level = enchantsSection.getInt(enchantKey);
                    if (enchant == null) continue;
                    meta.addEnchant(enchant, level, true);
                }
            }
            item.setItemMeta(meta);
            if (slot != -1) {
                if (slot >= 9) {
                    this.inventory.setItem(26 - negativeExpand, item);
                    ++negativeExpand;
                    continue;
                }
                this.inventory.setItem(9 + slot, item);
                continue;
            }
            if (item.getType().name().toLowerCase().contains("helmet")) {
                slot = 18;
            } else if (item.getType().name().toLowerCase().contains("chestplate")) {
                slot = 19;
            } else if (item.getType().name().toLowerCase().contains("leggings")) {
                slot = 20;
            } else if (item.getType().name().toLowerCase().contains("boots")) {
                slot = 21;
            }
            this.inventory.setItem(slot, item);
        }
        this.inventory.setItem(4, previewStack);
        this.inventory.setItem(this.inventory.getSize() - 5, closeStack);
    }

    @Override
    public void onClick(int slot, ClickType clickType) {
        if (slot == this.inventory.getSize() - 5) {
            this.player.closeInventory();
            super.close();
        }
    }
}

