/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.inventories;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomInventory {
    public String name;
    public static CopyOnWriteArrayList<CustomInventory> inventories = new CopyOnWriteArrayList();
    public Player player;
    private HashMap<Integer, ItemStack> items = new HashMap();
    private HashMap<Integer, ItemStack> originalInventory = new HashMap();

    public static boolean playerHasInventory(Player player) {
        for (CustomInventory inventory : inventories) {
            if (inventory.player != player) continue;
            return true;
        }
        return false;
    }

    public static CustomInventory getInventory(Player player) {
        for (CustomInventory inventory : inventories) {
            if (inventory.player != player) continue;
            return inventory;
        }
        return null;
    }

    public CustomInventory(String name, Player player) {
        this.name = name;
        this.player = player;
    }

    public void setItemInSlot(int slot, ItemStack itemStack) {
        this.items.put(slot, itemStack);
    }

    public void load() {
        for (CustomInventory inventory : inventories) {
            if (!inventory.player.equals((Object)this.player)) continue;
            inventory.close();
        }
        ItemStack[] contents = this.player.getInventory().getContents();
        for (int slot = 0; slot < contents.length; ++slot) {
            ItemStack item = contents[slot];
            if (item == null) continue;
            this.originalInventory.put(slot, item.clone());
        }
        inventories.add(this);
        this.onUpdate();
    }

    public void close() {
        ItemStack[] contents = new ItemStack[36];
        for (Map.Entry<Integer, ItemStack> entry : this.originalInventory.entrySet()) {
            int slot = entry.getKey();
            if (slot < 0 || slot >= contents.length) continue;
            contents[slot] = entry.getValue().clone();
        }
        this.player.getInventory().setContents(contents);
        inventories.remove(this);
        this.player.setGameMode(GameMode.SURVIVAL);
    }

    public void onUpdate() {
        this.player.getInventory().clear();
        for (Map.Entry<Integer, ItemStack> item : this.items.entrySet()) {
            int slot = item.getKey();
            if (slot == 100) {
                this.player.getInventory().setHelmet(item.getValue());
                continue;
            }
            if (slot == 101) {
                this.player.getInventory().setChestplate(item.getValue());
                continue;
            }
            if (slot == 102) {
                this.player.getInventory().setLeggings(item.getValue());
                continue;
            }
            if (slot == 103) {
                this.player.getInventory().setBoots(item.getValue());
                continue;
            }
            this.player.getInventory().setItem(slot, item.getValue());
        }
    }

    public void onSwing(int slot) {
    }
}

