/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.listeners;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.guis.Gui;
import eu.vraise.faithfulFFA.inventories.CustomInventory;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomInventoryListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            if (!CustomInventory.playerHasInventory(player)) {
                return;
            }
            event.setCancelled(true);
            if (Gui.openGuis.containsKey(player)) {
                Gui gui = Gui.openGuis.get(player);
                if (player.getOpenInventory().getTopInventory().getTitle().equalsIgnoreCase(gui.name)) {
                    gui.onClick(event.getSlot(), event.getClick());
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            if (!CustomInventory.playerHasInventory(player)) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        if (!CustomInventory.playerHasInventory(event.getPlayer())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onItemPickup(PlayerPickupItemEvent event) {
        if (!CustomInventory.playerHasInventory(event.getPlayer())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (!CustomInventory.playerHasInventory(player)) {
            return;
        }
        final Block block = event.getBlock();
        CustomInventory customInventory = CustomInventory.getInventory(player);
        if (customInventory.name != "Kit" || !FaithfulFFA.gameManager.isRunning || (double)block.getY() >= FaithfulFFA.gameManager.buildHeight) {
            event.setCancelled(true);
            return;
        }
        ++FaithfulFFA.databaseManager.getPlayer((Player)player).blocksPlaced;
        FaithfulFFA.gameManager.playerBlocks.add(block);
        if (block.getType().isSolid()) {
            new BukkitRunnable(this){
                final /* synthetic */ CustomInventoryListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (FaithfulFFA.gameManager.playerBlocks.contains(block)) {
                        block.setType(Material.REDSTONE_BLOCK);
                    }
                }
            }.runTaskLater((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), 100L);
            new BukkitRunnable(this){
                final /* synthetic */ CustomInventoryListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (FaithfulFFA.gameManager.playerBlocks.contains(block)) {
                        block.getWorld().playSound(block.getLocation(), Sound.DIG_STONE, 1.0f, 1.0f);
                        block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                        block.setType(Material.AIR);
                    }
                }
            }.runTaskLater((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), 120L);
        } else {
            new BukkitRunnable(this){
                final /* synthetic */ CustomInventoryListener this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (FaithfulFFA.gameManager.playerBlocks.contains(block)) {
                        block.setType(Material.AIR);
                    }
                }
            }.runTaskLater((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), 120L);
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!CustomInventory.playerHasInventory(event.getPlayer())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onSwing(PlayerAnimationEvent event) {
        if (event.getAnimationType() == PlayerAnimationType.ARM_SWING) {
            Player player = event.getPlayer();
            if (!CustomInventory.playerHasInventory(player)) {
                return;
            }
            CustomInventory customInventory = CustomInventory.getInventory(player);
            customInventory.onSwing(player.getInventory().getHeldItemSlot());
        }
    }

    @EventHandler
    public void onPlayerRightClick(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            if (!CustomInventory.playerHasInventory(player)) {
                return;
            }
            CustomInventory customInventory = CustomInventory.getInventory(player);
            customInventory.onSwing(player.getInventory().getHeldItemSlot());
        }
    }
}

