/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.listeners;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.inventories.CustomInventory;
import eu.vraise.faithfulFFA.inventories.KitInventory;
import eu.vraise.faithfulFFA.inventories.LobbyInventory;
import eu.vraise.faithfulFFA.managers.database.FaithfulPlayer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class WorldListener
implements Listener {
    public static final Set<UUID> recentlyDied = new HashSet<UUID>();

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (FaithfulFFA.gameManager.isRunning) {
            event.setRespawnLocation(FaithfulFFA.gameManager.spawnLocation);
        }
    }

    @EventHandler
    public void onPlayerTrample(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        if (event.getClickedBlock() != null && event.getClickedBlock().getType() == Material.SOIL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (CustomInventory.playerHasInventory(event.getPlayer())) {
            return;
        }
        FaithfulPlayer faithfulPlayer = FaithfulFFA.databaseManager.getPlayer(event.getPlayer());
        if (faithfulPlayer.buildmode) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (CustomInventory.playerHasInventory(event.getPlayer())) {
            return;
        }
        FaithfulPlayer faithfulPlayer = FaithfulFFA.databaseManager.getPlayer(event.getPlayer());
        if (faithfulPlayer.buildmode) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onFireSpread(BlockSpreadEvent event) {
        if (event.getSource().getType() == Material.FIRE) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.getCause() == BlockIgniteEvent.IgniteCause.SPREAD) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        player.setFoodLevel(20);
        FaithfulPlayer faithfulPlayer = FaithfulFFA.databaseManager.getPlayer(player);
        player.setLevel(faithfulPlayer.killStreak);
        if (faithfulPlayer.buildmode) {
            return;
        }
        if (FaithfulFFA.gameManager.isRunning && player.getLocation().getY() <= FaithfulFFA.gameManager.voidHeight && event.getPlayer().getHealth() > 0.0) {
            if (System.currentTimeMillis() - FaithfulFFA.gameManager.startTime > 1500L) {
                event.getPlayer().setHealth(0.0);
            }
        } else if (FaithfulFFA.gameManager.isRunning && player.getLocation().getY() <= FaithfulFFA.gameManager.buildHeight && event.getPlayer().getHealth() > 0.0) {
            if (CustomInventory.getInventory(player) != null && CustomInventory.getInventory((Player)player).name != "Kit") {
                CustomInventory.getInventory(player).close();
            }
            if (CustomInventory.getInventory(player) == null) {
                FileConfiguration kitsConfig = FaithfulFFA.getConfig("kits.yml");
                KitInventory kitInventory = new KitInventory("Kit", player);
                String selectedKit = faithfulPlayer.kit;
                ConfigurationSection kit = kitsConfig.getConfigurationSection("Kits." + selectedKit);
                ConfigurationSection itemsSection = kit.getConfigurationSection("Items");
                for (String itemKey : itemsSection.getKeys(false)) {
                    ConfigurationSection itemConfig = itemsSection.getConfigurationSection(itemKey);
                    Material material = Material.valueOf((String)itemConfig.getString("Item"));
                    int amount = itemConfig.getInt("Count");
                    String name = itemConfig.getString("Name");
                    int slot = itemConfig.getInt("Slot");
                    ItemStack item = new ItemStack(material, amount);
                    ItemMeta meta = item.getItemMeta();
                    if (meta != null) {
                        meta.setDisplayName(name);
                        ConfigurationSection enchantsSection = itemConfig.getConfigurationSection("Enchantments");
                        if (enchantsSection != null) {
                            for (String enchantKey : enchantsSection.getKeys(false)) {
                                Enchantment enchant = Enchantment.getByName((String)enchantKey.toUpperCase());
                                int level = enchantsSection.getInt(enchantKey);
                                if (enchant == null) continue;
                                meta.addEnchant(enchant, level, true);
                            }
                        }
                        item.setItemMeta(meta);
                    }
                    if (slot != -1) {
                        kitInventory.setItemInSlot(slot, item);
                        continue;
                    }
                    if (item.getType().name().toLowerCase().contains("helmet")) {
                        slot = 100;
                    } else if (item.getType().name().toLowerCase().contains("chestplate")) {
                        slot = 101;
                    } else if (item.getType().name().toLowerCase().contains("leggings")) {
                        slot = 102;
                    } else if (item.getType().name().toLowerCase().contains("boots")) {
                        slot = 103;
                    }
                    kitInventory.setItemInSlot(slot, item);
                }
                kitInventory.load();
            }
        }
    }

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            Player player = event.getPlayer();
            if (FaithfulFFA.gameManager.isRunning && event.getTo().getY() > FaithfulFFA.gameManager.buildHeight) {
                event.setCancelled(true);
            } else if (recentlyDied.contains(player.getUniqueId())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        event.getDrops().clear();
        event.setDroppedExp(0);
        Player deceased = event.getEntity();
        Player killer = deceased.getKiller();
        FaithfulPlayer deceasedF = FaithfulFFA.databaseManager.getPlayer(deceased);
        ++deceasedF.deaths;
        deceasedF.killStreak = 0;
        FileConfiguration config = FaithfulFFA.getConfig("config.yml");
        FileConfiguration messageConfig = FaithfulFFA.getConfig("messages.yml");
        deceased.playSound(deceased.getLocation(), Sound.BAT_DEATH, 1.0f, 1.0f);
        if (killer != null) {
            ArrayList<String> rescueLore;
            ItemMeta rescueMeta;
            ItemStack rescuePlatform;
            FaithfulPlayer killerF = FaithfulFFA.databaseManager.getPlayer(killer);
            ++killerF.kills;
            ++killerF.killStreak;
            if (killer.getHealth() > 0.0) {
                killer.setHealth(20.0);
            }
            event.setDeathMessage(null);
            FaithfulFFA.sendMessage(killer, messageConfig.getString("Player.Kill").replaceAll("%player%", deceased.getName()));
            FaithfulFFA.sendMessage(deceased, messageConfig.getString("Player.Killed").replaceAll("%player%", killer.getName()));
            killer.playSound(killer.getLocation(), Sound.LEVEL_UP, 1.0f, 1.0f);
            if (config.getBoolean("FFA.Notifications.Killstreaks.Enabled") && killerF.killStreak % config.getInt("FFA.Notifications.Killstreaks.Count") == 0) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    FaithfulFFA.sendMessage(player, messageConfig.getString("Player.Killstreak").replaceAll("%player%", killer.getName()).replaceAll("%count%", killerF.killStreak + ""));
                }
            }
            if (config.getBoolean("FFA.Rewards.Enderpearl.Enabled") && killerF.killStreak % config.getInt("FFA.Rewards.Enderpearl.Count") == 0) {
                rescuePlatform = new ItemStack(Material.valueOf((String)messageConfig.getString("Items.Enderpearl.Item")));
                rescueMeta = rescuePlatform.getItemMeta();
                rescueMeta.setDisplayName(messageConfig.getString("Items.Enderpearl.Name"));
                rescueLore = new ArrayList<String>();
                for (Object lore : messageConfig.getConfigurationSection("Items.Enderpearl").getList("Lore")) {
                    rescueLore.add(lore.toString());
                }
                rescueMeta.setLore(rescueLore);
                rescuePlatform.setItemMeta(rescueMeta);
                killer.getInventory().addItem(new ItemStack[]{rescuePlatform});
            }
            if (config.getBoolean("FFA.Rewards.RescuePlatform.Enabled") && killerF.killStreak % config.getInt("FFA.Rewards.RescuePlatform.Count") == 0) {
                rescuePlatform = new ItemStack(Material.valueOf((String)messageConfig.getString("Items.RescuePlatform.Item")));
                rescueMeta = rescuePlatform.getItemMeta();
                rescueMeta.setDisplayName(messageConfig.getString("Items.RescuePlatform.Name"));
                rescueLore = new ArrayList();
                for (Object lore : messageConfig.getConfigurationSection("Items.RescuePlatform").getList("Lore")) {
                    rescueLore.add(lore.toString());
                }
                rescueMeta.setLore(rescueLore);
                rescuePlatform.setItemMeta(rescueMeta);
                killer.getInventory().addItem(new ItemStack[]{rescuePlatform});
            }
        } else {
            event.setDeathMessage(null);
            FaithfulFFA.sendMessage(deceased, messageConfig.getString("Player.Died"));
        }
        recentlyDied.add(deceased.getUniqueId());
        event.getEntity().getServer().getScheduler().runTaskLater((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), () -> recentlyDied.remove(deceased.getUniqueId()), 120L);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (CustomInventory.getInventory(player) != null) {
            CustomInventory.getInventory(player).close();
        }
        LobbyInventory lobbyInventory = new LobbyInventory("Lobby", player);
        lobbyInventory.load();
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerAttack(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            CustomInventory customInventory = CustomInventory.getInventory(player);
            if (customInventory != null) {
                if (customInventory.name == "Kit") {
                    if (FaithfulFFA.gameManager.isRunning && player.getLocation().getY() > FaithfulFFA.gameManager.buildHeight) {
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            } else {
                event.setCancelled(true);
            }
        }
    }
}

