/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.managers;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.inventories.CustomInventory;
import eu.vraise.faithfulFFA.inventories.LobbyInventory;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameManager {
    public String name = "";
    public long startTime = 0L;
    public long endTime = 0L;
    public boolean isRunning = false;
    public boolean pluginRunning = true;
    public Thread mapThread;
    public World world;
    public Location spawnLocation;
    public double voidHeight;
    public double buildHeight;
    public CopyOnWriteArrayList<Block> playerBlocks = new CopyOnWriteArrayList();

    public void start() {
        final FileConfiguration config = FaithfulFFA.getConfig("config.yml");
        FileConfiguration mapConfig = FaithfulFFA.getConfig("maps.yml");
        final FileConfiguration messageConfig = FaithfulFFA.getConfig("messages.yml");
        if (mapConfig.get("maps") == null) {
            Bukkit.getLogger().warning("Please create a Map using /ffa setup and restart your server.");
            return;
        }
        final ConfigurationSection mapsSection = (ConfigurationSection)mapConfig.get("maps");
        if (mapsSection != null) {
            Set keys = mapsSection.getKeys(false);
            int size = keys.size();
            if (size <= 0) {
                Bukkit.getLogger().warning("Please create a Map using /ffa setup and restart your server.");
                return;
            }
        } else {
            Bukkit.getLogger().warning("Please delete FaithfulFFA/maps.yml and restart your server.");
            return;
        }
        new BukkitRunnable(this){
            final /* synthetic */ GameManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.mapThread = new Thread(() -> {
                    while (this.this$0.pluginRunning) {
                        String nextMap = this.this$0.nextMap();
                        ConfigurationSection map = mapsSection.getConfigurationSection(nextMap);
                        Bukkit.getLogger().info("Loading next map: " + nextMap);
                        World _world = Bukkit.getWorld((String)map.getString("world"));
                        if (_world == null) {
                            Bukkit.getLogger().info("Map " + nextMap + " does not exist. Skipping to next Map.");
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        FaithfulFFA.gameManager.world = _world;
                        FaithfulFFA.gameManager.spawnLocation = new Location(_world, map.getDouble("spawn.x"), map.getDouble("spawn.y"), map.getDouble("spawn.z"), (float)map.getDouble("spawn.yaw"), (float)map.getDouble("spawn.pitch"));
                        FaithfulFFA.gameManager.voidHeight = map.getDouble("voidheight");
                        FaithfulFFA.gameManager.buildHeight = map.getDouble("buildheight");
                        FaithfulFFA.gameManager.name = map.getString("displayname");
                        FaithfulFFA.gameManager.startTime = System.currentTimeMillis();
                        FaithfulFFA.gameManager.endTime = FaithfulFFA.gameManager.startTime + (long)config.getDouble("FFA.Rounds.Duration") * 1000L;
                        FaithfulFFA.gameManager.isRunning = true;
                        Bukkit.getLogger().info("Map " + nextMap + " has been loaded. Round started.");
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            Bukkit.getScheduler().runTask((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), () -> player.teleport(FaithfulFFA.gameManager.spawnLocation));
                            if (CustomInventory.getInventory(player) != null) {
                                CustomInventory.getInventory(player).close();
                            }
                            LobbyInventory lobbyInventory = new LobbyInventory("Lobby", player);
                            lobbyInventory.load();
                            player.sendTitle("\u00a7a" + map.getString("displayname"), "");
                            player.playSound(player.getLocation(), Sound.NOTE_PLING, 1.0f, 1.0f);
                        }
                        long gameLength = (long)config.getDouble("FFA.Rounds.Duration") * 1000L;
                        if (gameLength < 11000L) {
                            gameLength = 11000L;
                        }
                        if (!this.this$0.pluginRunning) break;
                        try {
                            Thread.sleep(gameLength - 10000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            FaithfulFFA.sendMessage(player, messageConfig.getString("Player.Round.End").replaceAll("%seconds%", "10"));
                        }
                        if (!this.this$0.pluginRunning) break;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            FaithfulFFA.sendMessage(player, messageConfig.getString("Player.Round.End").replaceAll("%seconds%", "5"));
                        }
                        if (!this.this$0.pluginRunning) break;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            FaithfulFFA.sendMessage(player, messageConfig.getString("Player.Round.End").replaceAll("%seconds%", "3"));
                        }
                        if (!this.this$0.pluginRunning) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            FaithfulFFA.sendMessage(player, messageConfig.getString("Player.Round.End").replaceAll("%seconds%", "2"));
                        }
                        if (!this.this$0.pluginRunning) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            FaithfulFFA.sendMessage(player, messageConfig.getString("Player.Round.End").replaceAll("%seconds%", "1"));
                        }
                        if (!this.this$0.pluginRunning) break;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Bukkit.getLogger().info("The current round has ended.");
                        for (Block block : new ArrayList<Block>(this.this$0.playerBlocks)) {
                            Bukkit.getScheduler().runTask((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), () -> {
                                block.setType(Material.AIR);
                                this.this$0.playerBlocks.remove(block);
                            });
                            try {
                                Thread.sleep(5L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                this.this$0.mapThread.start();
            }
        }.runTask((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class));
    }

    private String nextMap() {
        FileConfiguration mapConfig = FaithfulFFA.getConfig("maps.yml");
        Set keys = mapConfig.getConfigurationSection("maps").getKeys(false);
        ArrayList keyList = new ArrayList(keys);
        return (String)keyList.get(ThreadLocalRandom.current().nextInt(keyList.size()));
    }

    public void loadMap(String mapName) {
    }
}

