/*
 * Decompiled with CFR 0.152.
 */
package eu.vraise.faithfulFFA.managers.database;

import eu.vraise.faithfulFFA.FaithfulFFA;
import eu.vraise.faithfulFFA.db.MySQL;
import eu.vraise.faithfulFFA.managers.database.FaithfulPlayer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DatabaseManager {
    public HashMap<UUID, FaithfulPlayer> playerMap = new HashMap();

    public void initialize() {
        String query = "SELECT * FROM ffa_faithful";
        try {
            PreparedStatement statement = MySQL.getConnection().prepareStatement(query);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String kit;
                int killStreak;
                int deaths;
                int kills;
                String uuid = resultSet.getString("uuid");
                FaithfulPlayer faithfulPlayer = this.createPlayer(UUID.fromString(uuid));
                faithfulPlayer.kills = kills = resultSet.getInt("kills");
                faithfulPlayer.deaths = deaths = resultSet.getInt("deaths");
                long blocksPlaced = resultSet.getLong("blocksPlaced");
                faithfulPlayer.blocksPlaced = (int)blocksPlaced;
                faithfulPlayer.killStreak = killStreak = resultSet.getInt("killStreak");
                faithfulPlayer.kit = kit = resultSet.getString("kit");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public FaithfulPlayer createPlayer(UUID uuid) {
        FaithfulPlayer p = new FaithfulPlayer(uuid);
        this.playerMap.put(uuid, p);
        return p;
    }

    public FaithfulPlayer getPlayer(Player player) {
        return this.getPlayer(player.getUniqueId());
    }

    public FaithfulPlayer getPlayer(UUID uuid) {
        if (this.playerMap.get(uuid) == null) {
            return this.createPlayer(uuid);
        }
        return this.playerMap.get(uuid);
    }

    public void savePlayerData(FaithfulPlayer player) {
        if (MySQL.getConnection() == null) {
            Bukkit.getLogger().warning("Failed to save Playerdata. MySQL connection is null!");
            return;
        }
        String query = "INSERT INTO ffa_faithful (uuid, kills, deaths, blocksPlaced, killStreak, kit) VALUES (?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE kills = VALUES(kills), deaths = VALUES(deaths), blocksPlaced = VALUES(blocksPlaced), killStreak = VALUES(killStreak), kit = VALUES(kit)";
        try {
            PreparedStatement stmt = MySQL.getConnection().prepareStatement(query);
            stmt.setString(1, player.uuid.toString());
            stmt.setInt(2, player.kills);
            stmt.setInt(3, player.deaths);
            stmt.setLong(4, player.blocksPlaced);
            stmt.setLong(5, player.killStreak);
            stmt.setString(6, player.kit);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void startAutoSave() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getLogger().info("Saving Playerdata to MySQL...");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    DatabaseManager.this.getPlayer(player);
                }
                for (FaithfulPlayer faithfulPlayer : DatabaseManager.this.playerMap.values()) {
                    DatabaseManager.this.savePlayerData(faithfulPlayer);
                }
                Bukkit.getLogger().info("Saved Playerdata to MySQL.");
            }
        }.runTaskTimer((Plugin)FaithfulFFA.getPlugin(FaithfulFFA.class), 0L, 600L);
    }
}

