/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.oierbravo.createsifter.ModLang;
import com.oierbravo.createsifter.content.contraptions.components.meshes.AbstractAdvancedMesh;
import com.oierbravo.createsifter.content.contraptions.components.meshes.MeshUtils;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.infrastucture.config.MConfigs;
import com.oierbravo.createsifter.register.ModRecipes;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.DynamicCycleBehavior;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.RecipeRequirementsBehaviour;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.mechanicals.foundation.recipe.RecipeRequirementType;
import com.oierbravo.mechanicals.register.MechanicalRecipeRequirementTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.sound.SoundScapes;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSifterBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
DynamicCycleBehavior.DynamicCycleBehaviorSpecifics,
RecipeRequirementsBehaviour.RecipeRequirementsSpecifics<SiftingRecipe> {
    public float DEFAULT_MINIMUM_SPEED;
    protected float minimumSpeed = this.getDefaultMinimumSpeed();
    protected int itemsProcessedPerCycle = 1;
    private final ItemStackHandler inputInventory = this.createInputInventory();
    private final ItemStackHandler outputInventory = this.createOutputInventory();
    public ItemStackHandler meshInventory = this.createMeshInventory();
    protected IItemHandler inputAndMeshCombined = new SifterInventoryHandler(this.inputInventory, this.outputInventory);
    public DynamicCycleBehavior dynamicCycleBehaviour;
    public RecipeRequirementsBehaviour<SiftingRecipe> recipeRequirementsBehaviour;

    protected abstract boolean isValidMesh(ItemStack var1);

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.dynamicCycleBehaviour = new DynamicCycleBehavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.dynamicCycleBehaviour);
        this.recipeRequirementsBehaviour = new RecipeRequirementsBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.recipeRequirementsBehaviour);
    }

    public AbstractSifterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    private ItemStackHandler createMeshInventory() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return MeshUtils.isMeshItem(stack);
            }

            protected void onContentsChanged(int slot) {
                AbstractSifterBlockEntity.this.sendData();
            }
        };
    }

    protected ItemStackHandler createInputInventory() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return AbstractSifterBlockEntity.this.hasMesh();
            }

            protected void onContentsChanged(int slot) {
                AbstractSifterBlockEntity.this.sendData();
            }
        };
    }

    protected ItemStackHandler createOutputInventory() {
        return new ItemStackHandler(((Integer)MConfigs.server().sifter.outputCapacity.get()).intValue());
    }

    public ItemStackHandler getInputInventory() {
        return this.inputInventory;
    }

    public ItemStackHandler getOutputInventory() {
        return this.outputInventory;
    }

    public ItemStackHandler getMeshInventory() {
        return this.meshInventory;
    }

    @Nullable
    public IItemHandler getItemHandler() {
        return this.inputAndMeshCombined;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addedRequirements;
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!this.meshInventory.getStackInSlot(0).isEmpty()) {
            ModLang.translate("tooltip.mesh", this.meshInventory.getStackInSlot(0).getDisplayName().getString()).style(ChatFormatting.GREEN).forGoggles(tooltip);
            added = true;
        }
        if (addedRequirements = this.recipeRequirementsBehaviour.addToGoggleTooltip(tooltip, isPlayerSneaking, added)) {
            added = true;
        }
        return added;
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public boolean tryProcess(boolean simulate) {
        Optional<SiftingRecipe> recipe = this.getRecipe();
        if (recipe.isEmpty()) {
            this.recipeRequirementsBehaviour.cleanRequirements();
            return false;
        }
        if (!this.isSpeedRequirementFulfilled()) {
            return false;
        }
        SiftingRecipe siftingRecipe = recipe.get();
        if (!this.recipeRequirementsBehaviour.checkRequirements((IRecipeWithRequirements)siftingRecipe)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack stackInSlot = this.inputInventory.getStackInSlot(0);
        if (!stackInSlot.isEmpty()) {
            stackInSlot.shrink(1);
            this.inputInventory.setStackInSlot(0, stackInSlot);
            siftingRecipe.rollResults().forEach(stack -> this.tryToInsertOutputItem(this.outputInventory, (ItemStack)stack, false));
        }
        return true;
    }

    private Optional<SiftingRecipe> getRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        Optional<SiftingRecipe> recipe = ModRecipes.findMergedRecipesWithMatchingIngredients(this);
        return recipe;
    }

    protected void tryToInsertOutputItem(ItemStackHandler outputInv, ItemStack stack, boolean simulate) {
        ItemHandlerHelper.insertItemStacked((IItemHandler)outputInv, (ItemStack)stack, (boolean)simulate);
    }

    protected int getItemsProcessedPerCycle() {
        return this.itemsProcessedPerCycle;
    }

    public void showParticles() {
        if (this.inputInventory.getStackInSlot(0).isEmpty() || this.meshInventory.getStackInSlot(0).isEmpty()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, this.inputInventory.getStackInSlot(0));
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly((Vec3)target.subtract(offset), (RandomSource)this.level.random, (float)0.0078125f);
        this.level.addParticle((ParticleOptions)data, center.x, center.y, center.z, target.x, target.y, target.z);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("InputInventory", (Tag)this.inputInventory.serializeNBT(registries));
        compound.put("OutputInventory", (Tag)this.outputInventory.serializeNBT(registries));
        compound.put("MeshInventory", (Tag)this.meshInventory.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.inputInventory.deserializeNBT(registries, compound.getCompound("InputInventory"));
        this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        this.meshInventory.deserializeNBT(registries, compound.getCompound("MeshInventory"));
        super.read(compound, registries, clientPacket);
    }

    public boolean isSpeedRequirementFulfilled() {
        Optional<SiftingRecipe> recipe = this.getRecipe();
        if (recipe.isEmpty()) {
            return this.getAbsSpeed() >= this.minimumSpeed;
        }
        if (recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MIN_SPEED.get()).isPresent()) {
            return ((IRecipeRequirement)recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MIN_SPEED.get()).get()).test(this.level, (BlockEntity)this);
        }
        if (recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MAX_SPEED.get()).isPresent()) {
            return ((IRecipeRequirement)recipe.get().getRequirement((RecipeRequirementType)MechanicalRecipeRequirementTypes.MAX_SPEED.get()).get()).test(this.level, (BlockEntity)this);
        }
        return super.isSpeedRequirementFulfilled();
    }

    protected float getDefaultMinimumSpeed() {
        return this.DEFAULT_MINIMUM_SPEED;
    }

    public void insertMesh(ItemStack meshStack, Player player) {
        if (!this.isValidMesh(meshStack)) {
            return;
        }
        ItemStack meshToInsert = meshStack.copy();
        meshToInsert.setCount(1);
        if (this.getMeshItemStack().is(meshStack.getItem())) {
            return;
        }
        meshStack.shrink(1);
        if (!this.meshInventory.getStackInSlot(0).isEmpty()) {
            this.removeMesh(player);
        }
        this.meshInventory.setStackInSlot(0, meshToInsert);
        this.setChanged();
    }

    public boolean hasMesh() {
        return !this.getMeshItemStack().isEmpty();
    }

    public ItemStack getMeshItemStack() {
        return this.meshInventory.getStackInSlot(0);
    }

    public boolean hasAdvancedMesh() {
        return !this.meshInventory.getStackInSlot(0).isEmpty() && this.meshInventory.getStackInSlot(0).getItem() instanceof AbstractAdvancedMesh;
    }

    public void removeMesh(Player player) {
        player.getInventory().placeItemBackInInventory(this.meshInventory.getStackInSlot(0));
        this.meshInventory.setStackInSlot(0, ItemStack.EMPTY);
        this.minimumSpeed = this.getDefaultMinimumSpeed();
        this.sendData();
    }

    public boolean isWaterlogged() {
        return (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.WATERLOGGED);
    }

    public float getAbsSpeed() {
        return Math.abs(this.getSpeed());
    }

    public ItemStack getInputItemStack() {
        return this.inputInventory.getStackInSlot(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playRunningSound() {
        float pitch = Mth.clamp((float)(Math.abs(this.getSpeed()) / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        SoundScapes.play((SoundScapes.AmbienceGroup)SoundScapes.AmbienceGroup.MILLING, (BlockPos)this.worldPosition, (float)pitch);
    }

    public boolean matchesIngredients(SiftingRecipe siftingRecipeRecipeHolder) {
        boolean incorrectInput = Arrays.stream(siftingRecipeRecipeHolder.getInput().getItems()).filter(itemStack -> ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)this.inputInventory.getStackInSlot(0))).toList().isEmpty();
        if (incorrectInput) {
            return false;
        }
        return ItemStack.isSameItem((ItemStack)this.meshInventory.getStackInSlot(0), (ItemStack)siftingRecipeRecipeHolder.getMesh());
    }

    public boolean hasEnoughOutputSpace(SiftingRecipe siftingRecipe) {
        return true;
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public int getProcessingTime() {
        if (this.getRecipe().isEmpty()) {
            return 1;
        }
        return this.getRecipe().get().getProcessingTime();
    }

    private class SifterInventoryHandler
    extends CombinedInvWrapper {
        public SifterInventoryHandler(ItemStackHandler inputInventory, ItemStackHandler outputInventory) {
            super(new IItemHandlerModifiable[]{inputInventory, outputInventory});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (AbstractSifterBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (AbstractSifterBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (AbstractSifterBlockEntity.this.inputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

