/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.infrastucture.data.recipe;

import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeBuilder;
import com.oierbravo.createsifter.register.ModBlocks;
import com.oierbravo.createsifter.register.ModItems;
import com.oierbravo.mechanicals.foundation.data.AbstractMechanicalRecipeGenerator;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class SiftingRecipeGen
extends AbstractMechanicalRecipeGenerator<SiftingRecipeBuilder> {
    public SiftingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String namespace, String recipeTypeId, Supplier<SiftingRecipeBuilder> builderSupplier, String displayName) {
        super(output, registries, namespace, recipeTypeId, builderSupplier, displayName);
    }

    public SiftingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this(output, registries, "createsifter", "sifting", SiftingRecipeBuilder::new, "Sifting recipes");
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.createAndesite("gravel").require(Blocks.GRAVEL).output(0.3f, () -> ((ItemEntry)AllItems.COPPER_NUGGET).get(), 1).output(0.4f, () -> ((ItemEntry)AllItems.ZINC_NUGGET).get(), 1).output(0.4f, (ItemLike)Items.IRON_NUGGET, 1).output(0.2f, (ItemLike)Items.GOLD_NUGGET, 1).output(0.1f, (ItemLike)Items.COAL, 1).output(0.5f, (ItemLike)Items.FLINT, 1).save(recipeOutput);
        this.createBrass("gravel").require(Blocks.GRAVEL).output(0.1f, () -> ((ItemEntry)AllItems.CRUSHED_COPPER).get(), 1).output(0.1f, () -> ((ItemEntry)AllItems.CRUSHED_ZINC).get(), 1).output(0.05f, () -> ((ItemEntry)AllItems.CRUSHED_GOLD).get(), 1).output(0.1f, () -> ((ItemEntry)AllItems.CRUSHED_IRON).get(), 1).output(0.1f, (ItemLike)Items.LAPIS_LAZULI, 1).output(0.35f, (ItemLike)Items.COAL, 1).output(0.1f, (ItemLike)Items.FLINT, 1).output(0.1f, (ItemLike)Items.AMETHYST_SHARD, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAdvancedBrass("gravel").require(Blocks.GRAVEL).output(0.1f, () -> ((ItemEntry)AllItems.CRUSHED_COPPER).get(), 1).output(0.1f, () -> ((ItemEntry)AllItems.CRUSHED_ZINC).get(), 1).output(0.05f, () -> ((ItemEntry)AllItems.CRUSHED_GOLD).get(), 1).output(0.15f, () -> ((ItemEntry)AllItems.CRUSHED_IRON).get(), 1).output(0.1f, (ItemLike)Items.LAPIS_LAZULI, 1).output(0.05f, (ItemLike)Items.DIAMOND, 1).output(0.02f, (ItemLike)Items.EMERALD, 1).output(0.1f, (ItemLike)Items.AMETHYST_SHARD, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAndesite("sand").require(Blocks.SAND).output(0.1f, (ItemLike)Items.REDSTONE, 2).output(0.15f, (ItemLike)Items.GOLD_NUGGET, 1).output(0.15f, (ItemLike)Items.CACTUS, 1).output(0.1f, (ItemLike)Items.GUNPOWDER, 1).output(0.15f, (ItemLike)Items.BONE, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createBrass("sand").require(Blocks.SAND).output(0.15f, (ItemLike)Items.REDSTONE, 2).output(0.05f, (ItemLike)Items.BLAZE_POWDER, 1).output(0.25f, () -> ((ItemEntry)AllItems.CRUSHED_GOLD).get(), 1).output(0.25f, (ItemLike)Items.CACTUS, 1).output(0.15f, (ItemLike)Items.GUNPOWDER, 1).output(0.25f, (ItemLike)Items.BONE, 1).output(0.2f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAndesite("dust").require((ItemLike)ModBlocks.DUST).output(0.2f, (ItemLike)Items.REDSTONE, 2).output(0.1f, (ItemLike)Items.GLOWSTONE_DUST, 1).output(0.4f, (ItemLike)Items.BONE_MEAL, 1).output(0.01f, (ItemLike)Items.BLAZE_POWDER, 1).output(0.2f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createBrass("dust").require((ItemLike)ModBlocks.DUST).output(0.35f, (ItemLike)Items.REDSTONE, 2).output(0.2f, (ItemLike)Items.GLOWSTONE_DUST, 1).output(0.6f, (ItemLike)Items.BONE_MEAL, 1).output(0.05f, (ItemLike)Items.BLAZE_POWDER, 1).output(0.2f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createString("leaves").require((TagKey<Item>)ItemTags.LEAVES).output(0.1f, (ItemLike)Items.OAK_SAPLING).output(0.1f, (ItemLike)Items.SPRUCE_SAPLING).output(0.1f, (ItemLike)Items.BIRCH_SAPLING).output(0.1f, (ItemLike)Items.JUNGLE_SAPLING).output(0.1f, (ItemLike)Items.ACACIA_SAPLING).output(0.1f, (ItemLike)Items.DARK_OAK_SAPLING).output(0.1f, (ItemLike)Items.CHERRY_SAPLING).save(recipeOutput);
        this.createAndesite("leaves").require((TagKey<Item>)ItemTags.LEAVES).output(0.1f, (ItemLike)Items.OAK_SAPLING).output(0.1f, (ItemLike)Items.SPRUCE_SAPLING).output(0.1f, (ItemLike)Items.BIRCH_SAPLING).output(0.1f, (ItemLike)Items.JUNGLE_SAPLING).output(0.1f, (ItemLike)Items.ACACIA_SAPLING).output(0.1f, (ItemLike)Items.DARK_OAK_SAPLING).output(0.1f, (ItemLike)Items.CHERRY_SAPLING).save(recipeOutput);
        this.createString("dirt").require(Blocks.DIRT).output(0.5f, (ItemLike)ModItems.PEBBLE_STONE).output(0.45f, (ItemLike)ModItems.PEBBLE_ANDESITE).output(0.25f, (ItemLike)ModItems.PEBBLE_GRANITE).output(0.25f, (ItemLike)ModItems.PEBBLE_DIORITE).output(0.1f, (ItemLike)Items.WHEAT_SEEDS).output(0.05f, (ItemLike)Items.BEETROOT_SEEDS).output(0.05f, (ItemLike)Items.SUGAR_CANE).output(0.05f, (ItemLike)Items.BAMBOO).output(0.1f, (ItemLike)Items.SHORT_GRASS).output(0.01f, (ItemLike)Items.MELON_SEEDS).output(0.01f, (ItemLike)Items.PUMPKIN_SEEDS).output(0.01f, (ItemLike)Items.POTATO).output(0.01f, (ItemLike)Items.CARROT).output(0.01f, (ItemLike)Items.SWEET_BERRIES).save(recipeOutput);
        this.createAndesite("dirt").require(Blocks.DIRT).output(0.8f, (ItemLike)ModItems.PEBBLE_STONE).output(0.55f, (ItemLike)ModItems.PEBBLE_ANDESITE).output(0.45f, (ItemLike)ModItems.PEBBLE_GRANITE).output(0.45f, (ItemLike)ModItems.PEBBLE_DIORITE).output(0.2f, (ItemLike)Items.WHEAT_SEEDS).output(0.1f, (ItemLike)Items.BEETROOT_SEEDS).output(0.15f, (ItemLike)Items.SUGAR_CANE).output(0.15f, (ItemLike)Items.BAMBOO).output(0.1f, (ItemLike)Items.SHORT_GRASS).output(0.05f, (ItemLike)Items.MELON_SEEDS).output(0.05f, (ItemLike)Items.PUMPKIN_SEEDS).output(0.05f, (ItemLike)Items.POTATO).output(0.05f, (ItemLike)Items.CARROT).output(0.05f, (ItemLike)Items.SWEET_BERRIES).output(0.05f, (ItemLike)Items.BROWN_MUSHROOM).output(0.05f, (ItemLike)Items.RED_MUSHROOM).save(recipeOutput);
        this.createString("dirt", true).require(Blocks.DIRT).output(0.3f, (ItemLike)Items.KELP).output(0.2f, (ItemLike)Items.SEAGRASS).output(0.05f, (ItemLike)Items.TUBE_CORAL).output(0.05f, (ItemLike)Items.BRAIN_CORAL).output(0.05f, (ItemLike)Items.BUBBLE_CORAL).output(0.05f, (ItemLike)Items.FIRE_CORAL).output(0.05f, (ItemLike)Items.HORN_CORAL).save(recipeOutput);
        this.createBrass("dirt", true).require(Blocks.DIRT).output(0.4f, (ItemLike)Items.KELP).output(0.3f, (ItemLike)Items.SEAGRASS).output(0.1f, (ItemLike)Items.TUBE_CORAL).output(0.1f, (ItemLike)Items.BRAIN_CORAL).output(0.1f, (ItemLike)Items.BUBBLE_CORAL).output(0.1f, (ItemLike)Items.FIRE_CORAL).output(0.1f, (ItemLike)Items.HORN_CORAL).output(0.2f, (ItemLike)Items.PRISMARINE_SHARD).output(0.1f, (ItemLike)Items.PRISMARINE_CRYSTALS).save(recipeOutput);
        this.createBrass("soul_sand").require(Blocks.SOUL_SAND).output(0.1f, (ItemLike)Items.QUARTZ, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAdvancedBrass("soul_sand").require(Blocks.SOUL_SAND).output(0.45f, (ItemLike)Items.QUARTZ, 1).output(0.15f, (ItemLike)Items.QUARTZ, 1).output(0.05f, (ItemLike)Items.GHAST_TEAR, 1).output(0.2f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createBrass("crushed_netherrack").require((ItemLike)ModBlocks.CRUSHED_NETHERRACK).output(0.5f, (ItemLike)ModItems.PEBBLE_BASALT).output(0.4f, (ItemLike)ModItems.PEBBLE_BLACKSTONE).output(0.1f, (ItemLike)Items.GOLD_NUGGET).output(0.05f, (ItemLike)Items.QUARTZ).output(0.1f, (ItemLike)Items.BLAZE_POWDER, 1).output(0.01f, (ItemLike)Items.NETHERITE_SCRAP, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAdvancedBrass("crushed_netherrack").require((ItemLike)ModBlocks.CRUSHED_NETHERRACK).output(0.8f, (ItemLike)ModItems.PEBBLE_BASALT).output(0.6f, (ItemLike)ModItems.PEBBLE_BLACKSTONE).output(0.3f, (ItemLike)Items.GOLD_NUGGET).output(0.1f, (ItemLike)Items.QUARTZ).output(0.2f, (ItemLike)Items.BLAZE_POWDER, 1).output(0.5f, (ItemLike)Items.NETHERITE_SCRAP, 1).output(0.4f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createSturdy("crushed_basalt").require((ItemLike)ModBlocks.CRUSHED_BASALT).output(0.02f, (ItemLike)Items.ANCIENT_DEBRIS, 1).output(0.01f, (ItemLike)Items.NETHERITE_SCRAP, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAdvancedSturdy("crushed_basalt").require((ItemLike)ModBlocks.CRUSHED_BASALT).output(0.05f, (ItemLike)Items.ANCIENT_DEBRIS, 1).output(0.02f, (ItemLike)Items.NETHERITE_SCRAP, 1).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createSturdy("crushed_end_stone").require((ItemLike)ModBlocks.CRUSHED_END_STONE).output(0.05f, (ItemLike)Items.ENDER_PEARL).output(0.1f, (ItemLike)Items.CHORUS_FLOWER).output(0.5f, (ItemLike)Items.CHORUS_FRUIT).output(0.05f, (ItemLike)Items.SHULKER_SHELL).output(0.1f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
        this.createAdvancedSturdy("crushed_end_stone").require((ItemLike)ModBlocks.CRUSHED_END_STONE).output(0.1f, (ItemLike)Items.ENDER_PEARL).output(0.1f, (ItemLike)Items.CHORUS_FLOWER).output(0.1f, (ItemLike)Items.SHULKER_SHELL).output(0.3f, (ItemLike)AllItems.EXP_NUGGET.get(), 1).save(recipeOutput);
    }

    public SiftingRecipeBuilder createString(String name) {
        return this.createString(name, false);
    }

    public SiftingRecipeBuilder createString(String name, boolean waterlogged) {
        SiftingRecipeBuilder builder = ((SiftingRecipeBuilder)this.create(this.generateRecipeName(name, "string", waterlogged))).requiredMesh((ItemLike)ModItems.STRING_MESH);
        if (waterlogged) {
            return builder.isWaterlogged();
        }
        return builder;
    }

    public SiftingRecipeBuilder createAndesite(String name) {
        return this.createAndesite(name, false);
    }

    public SiftingRecipeBuilder createAndesite(String name, boolean waterlogged) {
        SiftingRecipeBuilder builder = ((SiftingRecipeBuilder)this.create(this.generateRecipeName(name, "andesite", waterlogged))).requiredMesh((ItemLike)ModItems.ANDESITE_MESH);
        if (waterlogged) {
            return builder.isWaterlogged();
        }
        return builder;
    }

    public SiftingRecipeBuilder createBrass(String name) {
        return this.createBrass(name, false);
    }

    public SiftingRecipeBuilder createBrass(String name, boolean waterlogged) {
        SiftingRecipeBuilder builder = ((SiftingRecipeBuilder)this.create(this.generateRecipeName(name, "brass", waterlogged))).requiredMesh((ItemLike)ModItems.BRASS_MESH);
        if (waterlogged) {
            builder.isWaterlogged();
        }
        return builder;
    }

    public SiftingRecipeBuilder createSturdy(String name) {
        return this.createSturdy(name, false);
    }

    public SiftingRecipeBuilder createSturdy(String name, boolean waterlogged) {
        SiftingRecipeBuilder builder = ((SiftingRecipeBuilder)this.create(this.generateRecipeName(name, "sturdy", waterlogged))).requiredMesh((ItemLike)ModItems.STURDY_MESH);
        if (waterlogged) {
            builder.isWaterlogged();
        }
        return builder;
    }

    public SiftingRecipeBuilder createAdvancedBrass(String name) {
        return this.createAdvancedBrass(name, false);
    }

    public SiftingRecipeBuilder createAdvancedBrass(String name, boolean waterlogged) {
        SiftingRecipeBuilder builder = ((SiftingRecipeBuilder)this.create(this.generateRecipeName(name, "advanced_brass", waterlogged))).requiredMesh((ItemLike)ModItems.ADVANCED_BRASS_MESH);
        if (waterlogged) {
            builder.isWaterlogged();
        }
        return builder;
    }

    public SiftingRecipeBuilder createAdvancedSturdy(String name) {
        return this.createAdvancedSturdy(name, false);
    }

    public SiftingRecipeBuilder createAdvancedSturdy(String name, boolean waterlogged) {
        SiftingRecipeBuilder builder = ((SiftingRecipeBuilder)this.create(this.generateRecipeName(name, "advance_sturdy", waterlogged))).requiredMesh((ItemLike)ModItems.ADVANCED_STURDY_MESH);
        if (waterlogged) {
            builder.isWaterlogged();
        }
        return builder;
    }

    private String generateRecipeName(String baseName, String mesh, boolean waterlogged) {
        String id = baseName + "_" + mesh;
        if (waterlogged) {
            id = id + "_waterlogged";
        }
        return id;
    }
}

