/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.register;

import com.oierbravo.createsifter.ModConstants;
import com.oierbravo.createsifter.content.contraptions.components.sifter.AbstractSifterBlockEntity;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeBuilder;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeSerializer;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRecipes {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"createsifter");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"createsifter");
    public static final Supplier<RecipeType<SiftingRecipe>> SIFTING_TYPE = RECIPE_TYPES.register("sifting_type", () -> RecipeType.simple((ResourceLocation)ModConstants.asResource("sifting_type")));
    public static final Supplier<SiftingRecipeSerializer> SIFTING_SERIALIZER = SERIALIZERS.register("sifting", () -> SiftingRecipeSerializer.INSTANCE);

    public static void register(IEventBus eventBus) {
        SERIALIZERS.register(eventBus);
        RECIPE_TYPES.register(eventBus);
    }

    public static Predicate<RecipeHolder<? extends Recipe<?>>> matchesKey(SiftingRecipeCacheKey key) {
        return recipeHolder -> {
            Recipe patt0$temp = recipeHolder.value();
            if (!(patt0$temp instanceof SiftingRecipe)) {
                return false;
            }
            SiftingRecipe siftingRecipe = (SiftingRecipe)patt0$temp;
            if (siftingRecipe.getInput().isEmpty() || !siftingRecipe.getInput().test(key.input)) {
                return false;
            }
            if (siftingRecipe.getMesh().isEmpty() || !siftingRecipe.getMesh().is(key.mesh.getItem())) {
                return false;
            }
            return siftingRecipe.isWaterlogged() == key.waterlogged;
        };
    }

    public static <EXB extends AbstractSifterBlockEntity> List<SiftingRecipe> findRecipesWithMatchingIngredients(EXB sifter) {
        return ModRecipes.findRecipesWithMatchingIngredients(sifter.getLevel(), sifter.getMeshItemStack(), sifter.getInputItemStack(), sifter.isWaterlogged());
    }

    public static <EXB extends AbstractSifterBlockEntity> Optional<SiftingRecipe> findMergedRecipesWithMatchingIngredients(EXB sifter) {
        return ModRecipes.findMergedRecipesWithMatchingIngredients(sifter.getLevel(), new SiftingRecipeCacheKey(sifter));
    }

    public static Optional<SiftingRecipe> findMergedRecipesWithMatchingIngredients(Level level, SiftingRecipeCacheKey key) {
        return Optional.ofNullable(ModRecipes.mergeRecipes(key, ModRecipes.findRecipesWithMatchingIngredients(level, key), false));
    }

    public static Optional<SiftingRecipe> findMergedRecipesWithMatchingIngredients(Level level, SiftingRecipeCacheKey key, boolean byHand) {
        return Optional.ofNullable(ModRecipes.mergeRecipes(key, ModRecipes.findRecipesWithMatchingIngredients(level, key), byHand));
    }

    public static List<SiftingRecipe> findRecipesWithMatchingIngredients(Level level, SiftingRecipeCacheKey key) {
        List recipes = RecipeFinder.get((Object)key, (Level)level, ModRecipes.matchesKey(key));
        return recipes.stream().map(recipeHolder -> (SiftingRecipe)recipeHolder.value()).toList();
    }

    public static List<SiftingRecipe> findRecipesWithMatchingIngredients(Level level, ItemStack mesh, ItemStack input, boolean waterlogged) {
        SiftingRecipeCacheKey key = new SiftingRecipeCacheKey(mesh, input, waterlogged, List.of());
        return ModRecipes.findRecipesWithMatchingIngredients(level, key);
    }

    public static List<RecipeHolder<SiftingRecipe>> getAllHolders() {
        return Objects.requireNonNull(Minecraft.getInstance().getConnection()).getRecipeManager().getAllRecipesFor((RecipeType)SiftingRecipe.Type.INSTANCE);
    }

    public static SiftingRecipe mergeRecipes(ISiftingRecipeCacheKey key, List<SiftingRecipe> recipes, boolean byHand) {
        if (recipes.isEmpty()) {
            return null;
        }
        if (byHand) {
            recipes = recipes.stream().filter(siftingRecipe -> !siftingRecipe.usesAdvancedMesh()).toList();
        }
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder();
        recipes.forEach(siftingRecipe -> ((SiftingRecipeBuilder)builder.output((List<ProcessingOutput>)siftingRecipe.getResults()).withId(ModRecipes.generateMergedResourceLocation(key))).waterlogged(key.getWaterlogged()).requiredMesh(key.getMesh()).require(key.getInput()).withRequirements(key.getRecipeRequirements()));
        return builder.build();
    }

    public static ResourceLocation generateMergedResourceLocation(ISiftingRecipeCacheKey key) {
        return ModConstants.asResource(key.toString());
    }

    public record SiftingRecipeCacheKey(ItemStack mesh, ItemStack input, boolean waterlogged, List<IRecipeRequirement> recipeRequirements) implements ISiftingRecipeCacheKey
    {
        public SiftingRecipeCacheKey(AbstractSifterBlockEntity sifter) {
            this(sifter.getMeshItemStack(), sifter.getInputItemStack(), sifter.isWaterlogged(), List.of());
        }

        @Override
        public String toString() {
            String name = String.valueOf(this.input.getItem()) + "_" + String.valueOf(this.mesh.getItem());
            if (this.waterlogged) {
                name = name + "_waterlogged";
            }
            return name.replace(":", "_");
        }

        @Override
        public Ingredient getInput() {
            return Ingredient.of((ItemStack[])new ItemStack[]{this.input});
        }

        @Override
        public ItemStack getMesh() {
            return this.mesh;
        }

        @Override
        public boolean getWaterlogged() {
            return this.waterlogged;
        }

        @Override
        public List<IRecipeRequirement> getRecipeRequirements() {
            return this.recipeRequirements;
        }
    }

    public static interface ISiftingRecipeCacheKey {
        public String toString();

        public Ingredient getInput();

        public ItemStack getMesh();

        public boolean getWaterlogged();

        public List<IRecipeRequirement> getRecipeRequirements();
    }

    public record SiftingRecipeJEICacheKey(ItemStack mesh, Ingredient input, boolean waterlogged, List<IRecipeRequirement> recipeRequirements) implements ISiftingRecipeCacheKey
    {
        public SiftingRecipeJEICacheKey(SiftingRecipe recipe) {
            this(recipe.getMesh(), recipe.getInput(), recipe.isWaterlogged(), recipe.getRecipeRequirements());
        }

        @Override
        public String toString() {
            String name = this.input.toString() + "_" + String.valueOf(this.mesh.getItem());
            if (this.waterlogged) {
                name = name + "_waterlogged";
            }
            return name.replace(":", "_");
        }

        @Override
        public Ingredient getInput() {
            return this.input;
        }

        @Override
        public ItemStack getMesh() {
            return this.mesh;
        }

        @Override
        public boolean getWaterlogged() {
            return this.waterlogged;
        }

        @Override
        public List<IRecipeRequirement> getRecipeRequirements() {
            return this.recipeRequirements;
        }
    }
}

