/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.emi;

import com.oierbravo.createsifter.compat.emi.CreteSifterEMI;
import com.oierbravo.createsifter.compat.emi.animations.AnimatedSifter;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.oierbravo.mechanicals.utility.LibLang;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class SiftingEmiRecipe
implements EmiRecipe {
    private static AllGuiTextures arrowTexture = AllGuiTextures.JEI_DOWN_ARROW;
    private static AllGuiTextures shadow = AllGuiTextures.JEI_SHADOW;
    ResourceLocation id;
    SiftingRecipe recipe;
    private List<EmiIngredient> inputs;
    private List<EmiStack> outputs;

    public SiftingEmiRecipe(SiftingRecipe recipe, ResourceLocation id) {
        this.recipe = recipe;
        this.id = id.withPrefix("/");
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.getInput()), EmiStack.of((ItemStack)recipe.getMesh()));
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        for (ProcessingOutput output : recipe.getRollableResults()) {
            outputs.add(EmiStack.of((ItemStack)output.getStack()).setChance(output.getChance()));
        }
        this.outputs = outputs;
    }

    public EmiRecipeCategory getCategory() {
        return CreteSifterEMI.SIFTING_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 177;
    }

    public int getDisplayHeight() {
        return 78 + this.outputs.size() / 10 * 19;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(SiftingEmiRecipe.shadow.location, 11, 42, shadow.getWidth(), shadow.getHeight(), shadow.getStartX(), shadow.getStartY());
        widgets.addTexture(SiftingEmiRecipe.arrowTexture.location, 21, 3, arrowTexture.getWidth(), arrowTexture.getHeight(), arrowTexture.getStartX(), arrowTexture.getStartY());
        widgets.addTexture(SiftingEmiRecipe.arrowTexture.location, 52, 33, arrowTexture.getWidth(), arrowTexture.getHeight(), arrowTexture.getStartX(), arrowTexture.getStartY());
        widgets.addSlot(this.inputs.get(0), 3, 3);
        widgets.addSlot(this.inputs.get(1), 3, 22);
        boolean single = this.outputs.size() == 1;
        int i = 0;
        for (EmiStack output : this.outputs) {
            int xOffset = i % 9 * 19;
            int yOffset = i / 9 * 19;
            widgets.addSlot((EmiIngredient)output, single ? 45 : 4 + xOffset, 60 + yOffset).recipeContext((EmiRecipe)this);
            ++i;
        }
        AnimatedSifter.sifter(widgets, 27, 47, this.recipe.isWaterlogged(), this.recipe.requiresAdvancedSifter());
        this.drawRequirements((IRecipeWithRequirements)this.recipe, widgets, 67, 4);
    }

    private void drawRequirements(IRecipeWithRequirements recipe, WidgetHolder widgets, int x, int y) {
        Minecraft minecraft = Minecraft.getInstance();
        Font fontRenderer = minecraft.font;
        int index = 0;
        int distance = 9;
        int offsetX = 5;
        int offsetY = 14;
        widgets.addText((Component)LibLang.translate((String)"ui.recipe.requirements.title", (Object[])new Object[0]).component().withStyle(new ChatFormatting[0]), x, y, -1, true);
        List jeiRequirementTooltips = recipe.getJeiRequirementsTooltips();
        if (jeiRequirementTooltips.isEmpty()) {
            widgets.addText((Component)LibLang.translate((String)"ui.recipe_requirement.none.tooltip", (Object[])new Object[0]).component().withStyle(new ChatFormatting[0]), x + offsetX, y + offsetY, -8355712, false);
        } else {
            for (Pair pair : jeiRequirementTooltips) {
                int oneLinerLenght = ((Component)pair.getSecond()).getString().length() + ((Component)pair.getSecond()).getString().length();
                if (oneLinerLenght < 19) {
                    widgets.addText((Component)((Component)pair.getFirst()).plainCopy().append(" ").append((Component)pair.getSecond()), x + offsetX, y + offsetY + distance * index, -8355712, false);
                    ++index;
                    continue;
                }
                widgets.addText((Component)pair.getFirst(), x + offsetX, y + offsetY + distance * index, -8355712, false);
                widgets.addText((Component)pair.getSecond(), x + offsetX, y + offsetY + distance * ++index, -8355712, false);
                ++index;
            }
        }
    }
}

