/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter.brass;

import com.oierbravo.createsifter.content.contraptions.components.sifter.AbstractSifterBlock;
import com.oierbravo.createsifter.content.contraptions.components.sifter.brass.BrassSifterBlockEntity;
import com.oierbravo.createsifter.register.ModBlockEntities;
import com.simibubi.create.content.kinetics.base.IRotate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BrassSifterBlock
extends AbstractSifterBlock<BrassSifterBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BrassSifterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn.isClientSide) {
            return;
        }
        if (!worldIn.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            worldIn.scheduleTick(pos, (Block)this, 0);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public Class<BrassSifterBlockEntity> getBlockEntityClass() {
        return BrassSifterBlockEntity.class;
    }

    public BlockEntityType<? extends BrassSifterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.BRASS_SIFTER.get();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.POWERED});
        super.createBlockStateDefinition(builder);
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return super.getMinimumRequiredSpeedLevel();
    }
}

