/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.recipe.SiftingRecipeBuilder;
import com.oierbravo.mechanicals.foundation.recipe.AbstractMechanicalRecipe;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeRequirement;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.List;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class SiftingRecipeSerializer
implements RecipeSerializer<SiftingRecipe> {
    public static final SiftingRecipeSerializer INSTANCE = new SiftingRecipeSerializer();
    public final StreamCodec<RegistryFriendlyByteBuf, SiftingRecipe> STREAM_CODEC = StreamCodec.of(this::toNetwork, this::fromNetwork);
    public static final MapCodec<SiftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(SiftingRecipe::getInput), (App)ProcessingOutput.CODEC_NEW.listOf().fieldOf("results").forGetter(SiftingRecipe::getResults), (App)ItemStack.CODEC.fieldOf("mesh").forGetter(SiftingRecipe::getMesh), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("processingTime", (Object)0).forGetter(SiftingRecipe::getProcessingTime), (App)Codec.BOOL.optionalFieldOf("advancedSifter", (Object)false).forGetter(SiftingRecipe::advancedSifter), (App)Codec.BOOL.optionalFieldOf("waterlogged", (Object)false).forGetter(SiftingRecipe::isWaterlogged), (App)IRecipeRequirement.LIST_CODEC.optionalFieldOf("requirements", List.of()).forGetter(SiftingRecipe::getRecipeRequirements), (App)ICondition.LIST_CODEC.optionalFieldOf("neoforge:conditions", List.of()).forGetter(AbstractMechanicalRecipe::getConditions)).apply((Applicative)instance, (input, processingOutput, mesh, processingTime, advancedSifter, waterlogged, requirements, iConditions) -> ((SiftingRecipeBuilder)((SiftingRecipeBuilder)new SiftingRecipeBuilder().require((Ingredient)input).output((List<ProcessingOutput>)processingOutput).requiredMesh((ItemStack)mesh).processingTime((int)processingTime).requiresAdvancedSifter((boolean)advancedSifter).waterlogged((boolean)waterlogged).withRequirements((List)requirements)).withConditions((List)iConditions)).build()));

    private SiftingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack mesh = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        NonNullList result = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        int processingTime = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
        boolean advancedSifter = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
        boolean waterlogged = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
        List recipeRequirements = (List)IRecipeRequirement.LIST_STREAM_CODEC.decode((Object)buffer);
        return ((SiftingRecipeBuilder)new SiftingRecipeBuilder().require(input).requiredMesh(mesh).output((List<ProcessingOutput>)result).processingTime(processingTime).requiresAdvancedSifter(advancedSifter).waterlogged(waterlogged).withRequirements(recipeRequirements)).build();
    }

    private void toNetwork(RegistryFriendlyByteBuf buffer, SiftingRecipe siftingRecipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)siftingRecipe.getInput());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)siftingRecipe.getMesh());
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).encode((Object)buffer, siftingRecipe.getResults());
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)siftingRecipe.getProcessingTime());
        ByteBufCodecs.BOOL.encode((Object)buffer, (Object)siftingRecipe.advancedSifter());
        ByteBufCodecs.BOOL.encode((Object)buffer, (Object)siftingRecipe.isWaterlogged());
        IRecipeRequirement.LIST_STREAM_CODEC.encode((Object)buffer, siftingRecipe.getRecipeRequirements());
    }

    @NotNull
    public MapCodec<SiftingRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, SiftingRecipe> streamCodec() {
        return this.STREAM_CODEC;
    }
}

