/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.currency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.command.CommandFlags;
import su.nightexpress.coinsengine.command.currency.CommandBuilder;
import su.nightexpress.coinsengine.command.currency.CommandData;
import su.nightexpress.coinsengine.command.currency.CommandProvider;
import su.nightexpress.coinsengine.command.currency.CommandVariant;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.currency.CurrencyOperations;
import su.nightexpress.coinsengine.currency.operation.ConsoleOperation;
import su.nightexpress.coinsengine.currency.operation.OperationProvider;
import su.nightexpress.coinsengine.currency.operation.impl.AddOperation;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.command.experimental.CommandContext;
import su.nightexpress.nightcore.command.experimental.RootCommand;
import su.nightexpress.nightcore.command.experimental.ServerCommand;
import su.nightexpress.nightcore.command.experimental.argument.ArgumentTypes;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArguments;
import su.nightexpress.nightcore.command.experimental.builder.ChainedNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.DirectNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.FlagBuilder;
import su.nightexpress.nightcore.command.experimental.builder.NodeBuilder;
import su.nightexpress.nightcore.command.experimental.node.ChainedNode;
import su.nightexpress.nightcore.command.experimental.node.CommandNode;
import su.nightexpress.nightcore.command.experimental.node.DirectNode;
import su.nightexpress.nightcore.command.experimental.node.NodeExecutor;
import su.nightexpress.nightcore.config.FileConfig;

public class CurrencyCommands {
    private static final String FILE = FileConfig.withExtension((String)"commands");
    public static final String DEFAULT_TOP_ALIAS = "top";
    private static final Map<String, CommandData> DEFAULTS_MAP = new LinkedHashMap<String, CommandData>();
    private static final Map<String, CommandData> DATA_MAP = new HashMap<String, CommandData>();
    private static final Map<String, CommandProvider> PROVIDER_MAP = new HashMap<String, CommandProvider>();
    private static CoinsEnginePlugin plugin;
    private static Set<ServerCommand> economyCommands;

    public static void load(@NotNull CoinsEnginePlugin instance) {
        plugin = instance;
        economyCommands = new HashSet<ServerCommand>();
        FileConfig config = FileConfig.loadOrExtract((NightCorePlugin)plugin, (String)FILE);
        CurrencyCommands.loadDefaults();
        CurrencyCommands.loadCommandData(config);
        config.saveChanges();
    }

    public static void clear() {
        DEFAULTS_MAP.clear();
        DATA_MAP.clear();
        PROVIDER_MAP.clear();
        economyCommands.clear();
        plugin = null;
    }

    private static void loadDefaults() {
        CurrencyCommands.addDefault("balance", CommandVariant.enabled("balance"), CommandVariant.enabled("balance", "bal"), true, CurrencyCommands::buildBalance);
        CurrencyCommands.addDefault("pay", CommandVariant.enabled("pay", "send"), CommandVariant.enabled("pay"), CurrencyCommands::buildPay, Currency::isTransferAllowed);
        CurrencyCommands.addDefault("payments", CommandVariant.enabled("payments"), CommandVariant.enabled("paytoggle"), CurrencyCommands::buildPayments, Currency::isTransferAllowed);
        if (Config.isTopsEnabled()) {
            CurrencyCommands.addDefault(DEFAULT_TOP_ALIAS, CommandVariant.enabled(DEFAULT_TOP_ALIAS), CommandVariant.enabled("balancetop", "baltop"), CurrencyCommands::buildTop, Currency::isLeaderboardEnabled);
        }
        CurrencyCommands.addDefault("add", CommandVariant.enabled("give"), CommandVariant.disabled("addmoney"), CurrencyCommands::buildGive);
        CurrencyCommands.addDefault("addall", CommandVariant.enabled("giveall"), CommandVariant.disabled("addmoneyall"), CurrencyCommands::buildGiveAll);
        CurrencyCommands.addDefault("set", CommandVariant.enabled("set"), CommandVariant.disabled("setmoney"), CurrencyCommands::buildSet);
        CurrencyCommands.addDefault("remove", CommandVariant.enabled("take", "remove"), CommandVariant.disabled("takemoney"), CurrencyCommands::buildRemove);
        CurrencyCommands.addDefault("exchange", CommandVariant.enabled("exchange"), CommandVariant.disabled("exchange"), CurrencyCommands::buildExchange, Currency::isExchangeAllowed);
    }

    private static void loadCommandData(@NotNull FileConfig config) {
        DEFAULTS_MAP.forEach((id, data) -> {
            String path = "Commands." + id;
            if (!config.contains(path)) {
                config.set(path, data);
            }
            CommandData fresh = CommandData.read(config, path);
            DATA_MAP.put((String)id, fresh);
        });
    }

    private static void addDefault(@NotNull String id, @NotNull CommandVariant children, @NotNull CommandVariant dedicated, @NotNull CommandBuilder provider) {
        CurrencyCommands.addDefault(id, children, dedicated, false, provider);
    }

    private static void addDefault(@NotNull String id, @NotNull CommandVariant children, @NotNull CommandVariant dedicated, boolean fallback, @NotNull CommandBuilder provider) {
        CurrencyCommands.addDefault(id, children, dedicated, fallback, provider, null);
    }

    private static void addDefault(@NotNull String id, @NotNull CommandVariant children, @NotNull CommandVariant dedicated, @NotNull CommandBuilder provider, @Nullable Predicate<Currency> predicate) {
        CurrencyCommands.addDefault(id, children, dedicated, false, provider, predicate);
    }

    private static void addDefault(@NotNull String id, @NotNull CommandVariant children, @NotNull CommandVariant dedicated, boolean fallback, @NotNull CommandBuilder provider, @Nullable Predicate<Currency> predicate) {
        DEFAULTS_MAP.put(id, new CommandData(children, dedicated, fallback));
        PROVIDER_MAP.put(id, new CommandProvider(provider, predicate));
    }

    public static void loadCommands(@NotNull Currency currency, boolean isEconomy) {
        RootCommand command = RootCommand.chained((NightCorePlugin)plugin, (String[])currency.getCommandAliases(), builder -> ((ChainedNodeBuilder)builder.permission(currency.isPermissionRequired() ? currency.getPermission() : null)).description((String)currency.replacePlaceholders().apply(Lang.COMMAND_CURRENCY_ROOT_DESC.getString())));
        ChainedNode root = (ChainedNode)command.getNode();
        DATA_MAP.forEach((id, data) -> {
            CommandProvider provider = PROVIDER_MAP.get(id);
            if (provider == null) {
                return;
            }
            if (!provider.canProvide(currency)) {
                return;
            }
            if (isEconomy) {
                CurrencyCommands.loadCommand(currency, data.getDedicatedVariant(), provider, builder -> economyCommands.add((ServerCommand)RootCommand.build((NightCorePlugin)plugin, (NodeBuilder)builder)));
            }
            CurrencyCommands.loadCommand(currency, data.getChildrenVariant(), provider, builder -> {
                DirectNode node = builder.build();
                root.addChildren((CommandNode)node);
                if (data.isFallback()) {
                    root.setFallback((NodeExecutor)node);
                }
            });
        });
        plugin.getCommandManager().registerCommand((ServerCommand)command);
        economyCommands.forEach(serverCommand -> plugin.getCommandManager().registerCommand(serverCommand));
    }

    private static void loadCommand(@NotNull Currency currency, @NotNull CommandVariant variant, @NotNull CommandProvider provider, @NotNull Consumer<DirectNodeBuilder> consumer) {
        if (!variant.isEnabled()) {
            return;
        }
        DirectNodeBuilder builder = DirectNode.builder((NightCorePlugin)plugin, (String[])variant.getAliases());
        provider.build(currency, builder);
        consumer.accept(builder);
    }

    public static void unloadForCurrency(@NotNull Currency currency) {
        plugin.getCommandManager().unregisterServerCommand(currency.getCommandAliases()[0]);
    }

    public static void unloadForEconomy() {
        economyCommands.forEach(serverCommand -> plugin.getCommandManager().unregisterCommand(serverCommand));
        economyCommands.clear();
    }

    private static void buildBalance(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_BALANCE)).description(Lang.COMMAND_CURRENCY_BALANCE_DESC)).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_CURRENCY_BALANCE_OTHERS)).executes((context, arguments) -> CurrencyCommands.showBalance(currency, context, arguments));
    }

    private static void buildPay(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)builder.playerOnly()).permission(Perms.COMMAND_CURRENCY_SEND)).description(Lang.COMMAND_CURRENCY_SEND_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).executes((context, arguments) -> CurrencyCommands.send(currency, context, arguments));
    }

    private static void buildTop(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_TOP)).description(Lang.COMMAND_CURRENCY_TOP_DESC)).withArgument(ArgumentTypes.integerAbs((String)"amount").localized(Lang.COMMAND_ARGUMENT_NAME_PAGE).withSamples(context -> IntStream.range(1, 11).boxed().map(String::valueOf).toList())).executes((context, arguments) -> CurrencyCommands.showTop(currency, context, arguments));
    }

    private static void buildGive(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_GIVE)).description(Lang.COMMAND_CURRENCY_GIVE_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.editBalance(currency, CurrencyOperations::forAdd, context, arguments));
    }

    private static void buildGiveAll(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_GIVE_ALL)).description(Lang.COMMAND_CURRENCY_GIVE_ALL_DESC)).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.giveAll(currency, context, arguments));
    }

    private static void buildSet(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_SET)).description(Lang.COMMAND_CURRENCY_SET_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.editBalance(currency, CurrencyOperations::forSet, context, arguments));
    }

    private static void buildRemove(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_TAKE)).description(Lang.COMMAND_CURRENCY_TAKE_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).withArgument(CommandArguments.amount().required()).withFlag((FlagBuilder)CommandFlags.silent()).withFlag((FlagBuilder)CommandFlags.silentOutput()).executes((context, arguments) -> CurrencyCommands.editBalance(currency, CurrencyOperations::forRemove, context, arguments));
    }

    private static void buildPayments(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)builder.permission(Perms.COMMAND_CURRENCY_PAYMENTS)).description(Lang.COMMAND_CURRENCY_PAYMENTS_DESC)).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_CURRENCY_PAYMENTS_OTHERS)).withFlag(CommandFlags.silent().permission(Perms.COMMAND_CURRENCY_PAYMENTS_OTHERS)).executes((context, arguments) -> CurrencyCommands.togglePayments(currency, context, arguments));
    }

    private static void buildExchange(@NotNull Currency currency, @NotNull DirectNodeBuilder builder) {
        ((DirectNodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)builder.playerOnly()).permission(Perms.COMMAND_CURRENCY_EXCHANGE)).description(Lang.COMMAND_CURRENCY_EXCHANGE_DESC)).withArgument(CommandArguments.currency(plugin).required().withSamples(context -> plugin.getCurrencyManager().getCurrencies().stream().filter(currency::canExchangeTo).map(Currency::getId).toList())).withArgument(CommandArguments.amount().required()).executes((context, arguments) -> CurrencyCommands.exchange(currency, context, arguments));
    }

    private static boolean showBalance(@NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getStringArgument("player", context.getSender().getName());
        plugin.getCurrencyManager().showBalance(context.getSender(), name, currency);
        return true;
    }

    private static boolean exchange(@NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player player = context.getPlayerOrThrow();
        Currency targetCurrency = (Currency)arguments.getArgument("currency", Currency.class);
        double amount = arguments.getDoubleArgument("amount");
        return plugin.getCurrencyManager().exchange(player, currency, targetCurrency, amount);
    }

    private static boolean giveAll(@NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        double amount = arguments.getDoubleArgument("amount");
        if (amount <= 0.0) {
            return false;
        }
        CommandSender sender = context.getSender();
        plugin.getServer().getOnlinePlayers().forEach(player -> {
            CoinsUser user = (CoinsUser)plugin.getUserManager().getOrFetch((Player)player);
            AddOperation operation = CurrencyOperations.forAdd(currency, amount, user, sender);
            operation.setFeedback(false);
            operation.setNotify(!arguments.hasFlag("s"));
            plugin.getCurrencyManager().performOperation(operation);
        });
        if (!arguments.hasFlag("sf")) {
            currency.sendPrefixed(Lang.COMMAND_CURRENCY_GIVE_ALL_DONE, sender, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%amount%", (Object)currency.format(amount)));
        }
        return true;
    }

    private static boolean togglePayments(@NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getStringArgument("player", context.getSender().getName());
        boolean silent = arguments.hasFlag("s");
        plugin.getCurrencyManager().togglePayments(context.getSender(), name, currency, silent);
        return true;
    }

    private static boolean send(@NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        Player from = context.getPlayerOrThrow();
        String targetName = arguments.getStringArgument("player");
        double amount = arguments.getDoubleArgument("amount");
        return plugin.getCurrencyManager().sendCurrency(from, targetName, currency, amount);
    }

    private static boolean showTop(@NotNull Currency currency, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        int page = arguments.getIntArgument("amount", 1);
        plugin.getTopManager().ifPresent(tops -> tops.showLeaderboard(context.getSender(), currency, page));
        return true;
    }

    private static <T extends ConsoleOperation<CommandSender>> boolean editBalance(@NotNull Currency currency, @NotNull OperationProvider<T> provider, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        double amount = arguments.getDoubleArgument("amount");
        if (amount < 0.0) {
            return false;
        }
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            ConsoleOperation operation = (ConsoleOperation)provider.provide(currency, amount, (CoinsUser)((Object)user), context.getSender());
            operation.setFeedback(!arguments.hasFlag("sf"));
            operation.setNotify(!arguments.hasFlag("s"));
            plugin.getCurrencyManager().performOperation(operation);
        });
        return true;
    }
}

