/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.command.impl;

import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.command.CommandArguments;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.coinsengine.currency.operation.impl.ResetOperation;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.command.experimental.CommandContext;
import su.nightexpress.nightcore.command.experimental.RootCommand;
import su.nightexpress.nightcore.command.experimental.ServerCommand;
import su.nightexpress.nightcore.command.experimental.argument.ArgumentTypes;
import su.nightexpress.nightcore.command.experimental.argument.ParsedArguments;
import su.nightexpress.nightcore.command.experimental.builder.DirectNodeBuilder;
import su.nightexpress.nightcore.command.experimental.builder.NodeBuilder;
import su.nightexpress.nightcore.command.experimental.impl.ReloadCommand;
import su.nightexpress.nightcore.command.experimental.node.ChainedNode;
import su.nightexpress.nightcore.command.experimental.node.DirectNode;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.wrapper.UniPermission;

public class BasicCommands {
    public static void load(@NotNull CoinsEnginePlugin plugin) {
        ChainedNode rootNode = plugin.getRootNode();
        rootNode.addChildren((NodeBuilder)ReloadCommand.builder((NightCorePlugin)plugin, (UniPermission)Perms.COMMAND_RELOAD));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"create"}).permission(Perms.COMMAND_CREATE)).description(Lang.COMMAND_CREATE_DESC)).withArgument(ArgumentTypes.string((String)"name").required().localized(Lang.COMMAND_ARGUMENT_NAME_NAME)).withArgument(ArgumentTypes.string((String)"symbol").required().localized(Lang.COMMAND_ARGUMENT_NAME_SYMBOL)).withArgument(ArgumentTypes.bool((String)"decimals").localized(Lang.COMMAND_ARGUMENT_NAME_DECIMAL).withSamples(context -> Lists.newList((Object[])new String[]{"true", "false"}))).executes((context, arguments) -> BasicCommands.createCurrency(plugin, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"reset"}).permission(Perms.COMMAND_RESET)).description(Lang.COMMAND_RESET_DESC)).withArgument(ArgumentTypes.playerName((String)"player").required()).executes((context, arguments) -> BasicCommands.reset(plugin, context, arguments)));
        rootNode.addChildren((NodeBuilder)((DirectNodeBuilder)((DirectNodeBuilder)DirectNode.builder((NightCorePlugin)plugin, (String[])new String[]{"resetall"}).permission(Perms.COMMAND_RESET_ALL)).description(Lang.COMMAND_RESET_ALL_DESC)).withArgument(CommandArguments.currency(plugin)).executes((context, arguments) -> BasicCommands.resetAll(plugin, context, arguments)));
        if (Config.isWalletEnabled()) {
            RootCommand command = RootCommand.direct((NightCorePlugin)plugin, (String[])((String[])Config.WALLET_ALIASES.get()), builder -> ((DirectNodeBuilder)((DirectNodeBuilder)builder.description(Lang.COMMAND_WALLET_DESC)).permission(Perms.COMMAND_WALLET)).withArgument(ArgumentTypes.playerName((String)"player").permission(Perms.COMMAND_WALLET_OTHERS)).executes((context, arguments) -> BasicCommands.showWallet(plugin, context, arguments)));
            plugin.getCommandManager().registerCommand((ServerCommand)command);
        }
    }

    private static boolean createCurrency(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getStringArgument("name");
        String symbol = arguments.getStringArgument("symbol");
        boolean decimals = arguments.getBooleanArgument("decimals", true);
        return plugin.getCurrencyManager().createCurrency(context.getSender(), name, symbol, decimals);
    }

    private static boolean showWallet(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        String name = arguments.getStringArgument("player", context.getSender().getName());
        plugin.getCurrencyManager().showWallet(context.getSender(), name);
        return true;
    }

    private static boolean reset(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        plugin.getUserManager().manageUser(arguments.getStringArgument("player"), user -> {
            if (user == null) {
                context.errorBadPlayer();
                return;
            }
            CommandSender sender = context.getSender();
            plugin.getCurrencyManager().getCurrencies().forEach(currency -> {
                ResetOperation operation = new ResetOperation((Currency)currency, (CoinsUser)((Object)user), sender);
                operation.setFeedback(false);
                plugin.getCurrencyManager().performOperation(operation);
            });
            Lang.COMMAND_RESET_DONE.getMessage().send(sender, replacer -> replacer.replace("%player_name%", (Object)user.getName()));
        });
        return true;
    }

    private static boolean resetAll(@NotNull CoinsEnginePlugin plugin, @NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        if (arguments.hasArgument("currency")) {
            Currency currency = (Currency)arguments.getArgument("currency", Currency.class);
            plugin.getCurrencyManager().resetBalances(context.getSender(), currency);
        } else {
            plugin.getCurrencyManager().resetBalances(context.getSender());
        }
        return true;
    }
}

