/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.config;

import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class Config {
    public static final String DIR_CURRENCIES = "/currencies/";
    public static final String DIR_MENU = "/menu/";
    public static final String LOG_FILENAME = "operations.log";
    public static final ConfigValue<Boolean> GENERAL_PLACEHOLDER_API_FOR_CURRENCY_FORMAT = ConfigValue.create((String)"General.PlaceholderAPI_For_Currency_Format", (boolean)true, (String[])new String[]{"Sets whether to apply PlaceholderAPI placeholders for currency 'Format' setting.", "Allows you to use custom images from Oraxen or ItemsAdder, as well as any other player unrelated placeholders."});
    public static final ConfigValue<Boolean> TOPS_ENABLED = ConfigValue.create((String)"Top.Enabled", (boolean)true, (String[])new String[]{"Controls whether Tops feature is enabled.", "[*] This feature is required for the 'server balance' placeholders to work.", "https://nightexpressdev.com/coinsengine/features/leaderboards"});
    public static final ConfigValue<Boolean> TOPS_USE_GUI = ConfigValue.create((String)"Top.Use_GUI", (boolean)true, (String[])new String[]{"Controls whether GUI is preferred to display balance leaderboard.", "[*] Disable if you want it be text only."});
    public static final ConfigValue<Integer> TOPS_ENTRIES_PER_PAGE = ConfigValue.create((String)"Top.Entries_Per_Page", (int)10, (String[])new String[]{"Sets how many entries displayed per page for currency top commands.", "[*] Works only for text leaderboards. GUI settings available in the '/menu/' directory."});
    public static final ConfigValue<Integer> TOPS_UPDATE_INTERVAL = ConfigValue.create((String)"Top.Update_Interval", (int)900, (String[])new String[]{"Sets update interval (in seconds) for currency top balance lists.", "[Asynchronous]", "[Default is 900 (15 minutes)]"});
    public static final ConfigValue<Boolean> CURRENCY_PREFIX_ENABLED = ConfigValue.create((String)"Currency.Prefix.Enabled", (boolean)true, (String[])new String[]{"Controls whether or not currency messages will use custom prefix instead of the plugin's one.", "https://nightexpressdev.com/coinsengine/features/prefix"});
    public static final ConfigValue<String> CURRENCY_PREFIX_FORMAT = ConfigValue.create((String)"Currency.Prefix.Format", (String)(Tags.LIGHT_YELLOW.wrap(Tags.BOLD.wrap("%currency_prefix%")) + Tags.DARK_GRAY.wrap(" \u00bb ") + Tags.GRAY.getBracketsName()), (String[])new String[]{"Sets custom prefix format for currency messages.", "You can use 'Currency' placeholders: https://nightexpressdev.com/coinsengine/placeholders"});
    public static final ConfigValue<Boolean> WALLET_ENABLED = ConfigValue.create((String)"Wallet.Enabled", (boolean)true, (String[])new String[]{"Controls whether Wallet feature is enabled.", "https://nightexpressdev.com/coinsengine/features/wallet"});
    public static final ConfigValue<String[]> WALLET_ALIASES = ConfigValue.create((String)"Wallet.Command_Aliases", (String[])new String[]{"wallet"}, (String[])new String[]{"Command aliases for the Wallet feature."});
    public static final ConfigValue<Boolean> MIGRATION_ENABLED = ConfigValue.create((String)"Migration.Enabled", (boolean)true, (String[])new String[]{"Controls whether Migration feature is available.", "Disable if you don't plan to migrate from other plugins to save some RAM.", "https://nightexpressdev.com/coinsengine/features/migration"});
    public static final ConfigValue<Boolean> LOGS_TO_CONSOLE = ConfigValue.create((String)"Logs.Enabled.Console", (boolean)false, (String[])new String[]{"Controls whether currency operations will be logged to console."});
    public static final ConfigValue<Boolean> LOGS_TO_FILE = ConfigValue.create((String)"Logs.Enabled.File", (boolean)true, (String[])new String[]{"Controls whether currency operations will be logged to a file."});
    public static final ConfigValue<String> LOGS_DATE_FORMAT = ConfigValue.create((String)"Logs.DateFormat", (String)"dd/MM/yyyy HH:mm:ss", (String[])new String[]{"Logs date format."});
    public static final ConfigValue<Integer> LOGS_WRITE_INTERVAL = ConfigValue.create((String)"Logs.Write_Interval", (int)5, (String[])new String[]{"Controls how often currency operations writes to the log file."});

    public static boolean isTopsEnabled() {
        return (Boolean)TOPS_ENABLED.get();
    }

    public static boolean isWalletEnabled() {
        return (Boolean)WALLET_ENABLED.get();
    }

    public static boolean isMigrationEnabled() {
        return (Boolean)MIGRATION_ENABLED.get();
    }

    public static boolean useCurrencyFormatPAPI() {
        return (Boolean)GENERAL_PLACEHOLDER_API_FOR_CURRENCY_FORMAT.get() != false && Plugins.hasPlaceholderAPI();
    }
}

