/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.api.currency.CurrencyOperation;
import su.nightexpress.coinsengine.api.currency.OperationResult;
import su.nightexpress.coinsengine.command.currency.CurrencyCommands;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.currency.CurrencyLogger;
import su.nightexpress.coinsengine.currency.impl.ConfigCurrency;
import su.nightexpress.coinsengine.currency.operation.impl.ExchangeOperation;
import su.nightexpress.coinsengine.currency.operation.impl.SendOperation;
import su.nightexpress.coinsengine.data.DataHandler;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.data.impl.CurrencySettings;
import su.nightexpress.coinsengine.hook.vault.VaultHook;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.db.AbstractUser;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class CurrencyManager
extends AbstractManager<CoinsEnginePlugin> {
    private final Map<String, Currency> currencyMap = new HashMap<String, Currency>();
    private boolean operationsAllowed;
    private CurrencyLogger logger;

    public CurrencyManager(@NotNull CoinsEnginePlugin plugin) {
        super((NightCorePlugin)plugin);
        this.allowOperations();
    }

    protected void onLoad() {
        this.createDefaults();
        for (File file : FileUtil.getConfigFiles((String)this.getDirectory())) {
            ConfigCurrency currency = new ConfigCurrency((CoinsEnginePlugin)this.plugin, file);
            this.loadCurrency(currency);
        }
        this.loadLogger();
    }

    protected void onShutdown() {
        if (Plugins.hasVault()) {
            VaultHook.shutdown();
        }
        this.getCurrencies().forEach(this::unregisterCurrency);
        this.currencyMap.clear();
        if (this.logger != null) {
            this.logger.shutdown();
        }
        this.disableOperations();
    }

    private void createDefaults() {
        File dir = new File(this.getDirectory());
        if (dir.exists()) {
            return;
        }
        boolean needEconomy = Plugins.hasVault() && !VaultHook.hasEconomy();
        this.createCurrency("coins", currency -> {
            currency.setSymbol("\u26c2");
            currency.setIcon(NightItem.fromType((Material)Material.SUNFLOWER));
            currency.setDecimal(false);
        });
        this.createCurrency("money", currency -> {
            currency.setSymbol("$");
            currency.setFormat("%currency_symbol%%amount%");
            currency.setFormat(currency.getFormat());
            currency.setIcon(NightItem.fromType((Material)Material.GOLD_NUGGET));
            currency.setDecimal(true);
            currency.setVaultEconomy(needEconomy);
        });
    }

    private void loadCurrency(@NotNull ConfigCurrency currency) {
        if (currency.load()) {
            this.registerCurrency(currency);
        }
    }

    private void loadLogger() {
        try {
            this.logger = new CurrencyLogger((CoinsEnginePlugin)this.plugin);
            this.addAsyncTask(this::writeLogs, (Integer)Config.LOGS_WRITE_INTERVAL.get());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private void writeLogs() {
        this.logger.write();
    }

    @NotNull
    public String getDirectory() {
        return String.valueOf(((CoinsEnginePlugin)this.plugin).getDataFolder()) + "/currencies/";
    }

    public void registerCurrency(@NotNull Currency currency) {
        if (this.getCurrency(currency.getId()) != null) {
            ((CoinsEnginePlugin)this.plugin).error("Could not register duplicated currency: '" + currency.getId() + "'!");
            return;
        }
        if (DataHandler.isCurrencyColumnCached(currency)) {
            ((CoinsEnginePlugin)this.plugin).error("Currency '" + currency.getId() + "' tried to use column '" + currency.getColumnName() + "' which is already used by other currency!");
            return;
        }
        ((CoinsEnginePlugin)this.plugin).getDataHandler().onCurrencyRegister(currency);
        boolean isEconomy = false;
        if (currency.isVaultEconomy() && this.getVaultCurrency().isEmpty()) {
            if (Plugins.hasVault()) {
                VaultHook.setup((CoinsEnginePlugin)this.plugin, currency);
                isEconomy = true;
            } else {
                ((CoinsEnginePlugin)this.plugin).error("Found Vault Economy currency, but Vault is not installed!");
            }
        }
        CurrencyCommands.loadCommands(currency, isEconomy);
        this.currencyMap.put(currency.getId(), currency);
        ((CoinsEnginePlugin)this.plugin).info("Currency registered: '" + currency.getId() + "'.");
    }

    public boolean unregisterCurrency(@NotNull Currency currency) {
        return this.unregisterCurrency(currency.getId());
    }

    public boolean unregisterCurrency(@NotNull String id) {
        Currency currency = this.currencyMap.remove(id);
        if (currency == null) {
            return false;
        }
        CurrencyCommands.unloadForCurrency(currency);
        if (currency.isVaultEconomy()) {
            CurrencyCommands.unloadForEconomy();
        }
        ((CoinsEnginePlugin)this.plugin).getDataHandler().onCurrencyUnload(currency);
        ((CoinsEnginePlugin)this.plugin).info("Currency unregistered: '" + currency.getId() + "'.");
        return true;
    }

    public boolean isRegistered(@NotNull String id) {
        return this.currencyMap.containsKey(id.toLowerCase());
    }

    @Nullable
    public Currency getCurrency(@NotNull String id) {
        return this.currencyMap.get(id.toLowerCase());
    }

    @NotNull
    public Map<String, Currency> getCurrencyMap() {
        return this.currencyMap;
    }

    @NotNull
    public List<String> getCurrencyIds() {
        return new ArrayList<String>(this.currencyMap.keySet());
    }

    @NotNull
    public Optional<Currency> getVaultCurrency() {
        return this.getCurrencies().stream().filter(Currency::isVaultEconomy).findFirst();
    }

    @NotNull
    public Collection<Currency> getCurrencies() {
        return new HashSet<Currency>(this.currencyMap.values());
    }

    @NotNull
    public ConfigCurrency createCurrency(@NotNull String id, @NotNull Consumer<ConfigCurrency> consumer) {
        File file = new File(this.getDirectory(), FileConfig.withExtension((String)id));
        ConfigCurrency currency = new ConfigCurrency((CoinsEnginePlugin)this.plugin, file);
        currency.setName(StringUtil.capitalizeUnderscored((String)id));
        currency.setFormat("%amount%%currency_symbol%");
        currency.setFormatShort("%amount%%currency_symbol%");
        currency.setCommandAliases(new String[]{id});
        currency.setPermissionRequired(false);
        currency.setTransferAllowed(true);
        currency.setStartValue(0.0);
        currency.setMaxValue(-1.0);
        currency.setExchangeAllowed(true);
        consumer.accept(currency);
        currency.save();
        return currency;
    }

    public void allowOperations() {
        this.operationsAllowed = true;
    }

    public void disableOperations() {
        this.operationsAllowed = false;
    }

    public boolean canPerformOperations() {
        return this.operationsAllowed;
    }

    public boolean performOperation(@NotNull CurrencyOperation operation) {
        if (!this.canPerformOperations()) {
            return false;
        }
        OperationResult result = operation.perform();
        if (operation.isLoggable()) {
            if (((Boolean)Config.LOGS_TO_CONSOLE.get()).booleanValue()) {
                ((CoinsEnginePlugin)this.plugin).info(result.getLog());
            }
            if (((Boolean)Config.LOGS_TO_FILE.get()).booleanValue()) {
                this.logger.addOperation(result);
            }
        }
        if (!result.isSuccess()) {
            return false;
        }
        ((CoinsEnginePlugin)this.plugin).getUserManager().save(operation.getUser());
        return true;
    }

    public boolean createCurrency(@NotNull CommandSender sender, @NotNull String name, @NotNull String symbol, boolean decimals) {
        String id = StringUtil.transformForID((String)name);
        if (id.isBlank()) {
            Lang.CURRENCY_CREATE_BAD_NAME.getMessage().send(sender);
            return false;
        }
        if (this.isRegistered(id)) {
            Lang.CURRENCY_CREATE_DUPLICATED.getMessage().send(sender);
            return false;
        }
        ConfigCurrency created = this.createCurrency(id, currency -> {
            currency.setSymbol(symbol);
            currency.setIcon(NightItem.fromType((Material)Material.EMERALD));
            currency.setDecimal(decimals);
        });
        this.loadCurrency(created);
        Lang.CURRENCY_CREATE_SUCCESS.getMessage().send(sender, replacer -> replacer.replace(created.replacePlaceholders()));
        return true;
    }

    public void resetBalances(@NotNull CommandSender sender) {
        this.resetBalances(sender, null);
    }

    public void resetBalances(@NotNull CommandSender sender, @Nullable Currency currency) {
        if (!this.canPerformOperations()) {
            Lang.RESET_ALL_START_BLOCKED.getMessage().send(sender);
            return;
        }
        ((CoinsEnginePlugin)this.plugin).runTaskAsync(task -> {
            this.disableOperations();
            if (currency == null) {
                Lang.RESET_ALL_STARTED_GLOBAL.getMessage().send(sender);
                ((CoinsEnginePlugin)this.plugin).getDataHandler().resetBalances();
                ((CoinsEnginePlugin)this.plugin).getUserManager().getLoaded().forEach(CoinsUser::resetBalance);
                Lang.RESET_ALL_COMPLETED_GLOBAL.getMessage().send(sender);
            } else {
                Lang.RESET_ALL_STARTED_CURRENCY.getMessage().send(sender, replacer -> replacer.replace(currency.replacePlaceholders()));
                ((CoinsEnginePlugin)this.plugin).getDataHandler().resetBalances(currency);
                ((CoinsEnginePlugin)this.plugin).getUserManager().getLoaded().forEach(user -> user.resetBalance(currency));
                Lang.RESET_ALL_COMPLETED_CURRENCY.getMessage().send(sender, replacer -> replacer.replace(currency.replacePlaceholders()));
            }
            this.allowOperations();
        });
    }

    public void showBalance(@NotNull CommandSender sender, @NotNull Currency currency) {
        this.showBalance(sender, sender.getName(), currency);
    }

    public void showBalance(@NotNull CommandSender sender, @NotNull String name, @NotNull Currency currency) {
        boolean isOwn = sender.getName().equalsIgnoreCase(name);
        ((CoinsEnginePlugin)this.plugin).getUserManager().manageUser(name, user -> {
            if (user == null) {
                Lang.ERROR_INVALID_PLAYER.getMessage(this.plugin).send(sender);
                return;
            }
            currency.sendPrefixed(isOwn ? Lang.CURRENCY_BALANCE_DISPLAY_OWN : Lang.CURRENCY_BALANCE_DISPLAY_OTHERS, sender, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%balance%", (Object)currency.format(user.getBalance(currency))));
        });
    }

    public void showWallet(@NotNull Player player) {
        this.showWallet((CommandSender)player, player.getName());
    }

    public void showWallet(@NotNull CommandSender sender, @NotNull String name) {
        boolean isOwn = sender.getName().equalsIgnoreCase(name);
        ((CoinsEnginePlugin)this.plugin).getUserManager().manageUser(name, user -> {
            if (user == null) {
                Lang.ERROR_INVALID_PLAYER.getMessage(this.plugin).send(sender);
                return;
            }
            (isOwn ? Lang.CURRENCY_WALLET_OWN : Lang.CURRENCY_WALLET_OTHERS).getMessage().send(sender, replacer -> replacer.replace("%entry%", list -> this.getCurrencies().stream().sorted(Comparator.comparing(Currency::getId)).forEach(currency -> {
                Player player;
                if (sender instanceof Player && !currency.hasPermission(player = (Player)sender)) {
                    return;
                }
                list.add(Replacer.create().replace(currency.replacePlaceholders()).replace("%balance%", (Object)currency.format(user.getBalance((Currency)currency))).apply(Lang.CURRENCY_WALLET_ENTRY.getString()));
            })).replace("%player_name%", (Object)user.getName()));
        });
    }

    public void togglePayments(@NotNull Player player, @NotNull Currency currency) {
        this.togglePayments((CommandSender)player, player.getName(), currency, false);
    }

    public void togglePayments(@NotNull CommandSender sender, @NotNull String name, @NotNull Currency currency, boolean silent) {
        boolean isOwn = sender.getName().equalsIgnoreCase(name);
        ((CoinsEnginePlugin)this.plugin).getUserManager().manageUser(name, user -> {
            CurrencySettings settings;
            if (user == null) {
                Lang.ERROR_INVALID_PLAYER.getMessage(this.plugin).send(sender);
                return;
            }
            settings.setPaymentsEnabled(!(settings = user.getSettings(currency)).isPaymentsEnabled());
            ((CoinsEnginePlugin)this.plugin).getUserManager().save((AbstractUser)user);
            if (!isOwn) {
                currency.sendPrefixed(Lang.COMMAND_CURRENCY_PAYMENTS_TARGET, sender, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%player_name%", (Object)user.getName()).replace("%state%", (Object)Lang.getEnabledOrDisabled((boolean)settings.isPaymentsEnabled())));
            }
            Player target = user.getPlayer();
            if (!silent && target != null) {
                currency.sendPrefixed(Lang.COMMAND_CURRENCY_PAYMENTS_TOGGLE, (CommandSender)target, replacer -> replacer.replace(currency.replacePlaceholders()).replace("%state%", (Object)Lang.getEnabledOrDisabled((boolean)settings.isPaymentsEnabled())));
            }
        });
    }

    public boolean sendCurrency(@NotNull Player from, @NotNull String targetName, @NotNull Currency currency, double rawAmount) {
        double amount = currency.floorIfNeeded(rawAmount);
        if (amount <= 0.0) {
            return false;
        }
        if (from.getName().equalsIgnoreCase(targetName)) {
            Lang.ERROR_COMMAND_NOT_YOURSELF.getMessage().send((CommandSender)from);
            return false;
        }
        double minAmount = currency.getMinTransferAmount();
        if (minAmount > 0.0 && amount < minAmount) {
            currency.sendPrefixed(Lang.CURRENCY_SEND_ERROR_TOO_LOW, (CommandSender)from, replacer -> replacer.replace("%amount%", (Object)currency.format(minAmount)));
            return false;
        }
        CoinsUser fromUser = (CoinsUser)((CoinsEnginePlugin)this.plugin).getUserManager().getOrFetch(from);
        if (amount > fromUser.getBalance(currency)) {
            currency.sendPrefixed(Lang.CURRENCY_SEND_ERROR_NOT_ENOUGH, (CommandSender)from, replacer -> replacer.replace(currency.replacePlaceholders()));
            return false;
        }
        ((CoinsEnginePlugin)this.plugin).getUserManager().manageUser(targetName, targetUser -> {
            if (targetUser == null) {
                Lang.ERROR_INVALID_PLAYER.getMessage(this.plugin).send((CommandSender)from);
                return;
            }
            CurrencySettings settings = targetUser.getSettings(currency);
            if (!settings.isPaymentsEnabled()) {
                currency.sendPrefixed(Lang.CURRENCY_SEND_ERROR_NO_PAYMENTS, (CommandSender)from, replacer -> replacer.replace("%player_name%", (Object)targetUser.getName()).replace(currency.replacePlaceholders()));
                return;
            }
            SendOperation operation = new SendOperation(currency, amount, (CoinsUser)((Object)targetUser), from, fromUser);
            this.performOperation(operation);
            ((CoinsEnginePlugin)this.plugin).getUserManager().save(fromUser);
        });
        return true;
    }

    public boolean exchange(@NotNull Player player, @NotNull Currency from, @NotNull Currency to, double initAmount) {
        if (!from.isExchangeAllowed()) {
            from.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_DISABLED, (CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()));
            return false;
        }
        double amount = from.floorIfNeeded(initAmount);
        if (amount <= 0.0) {
            from.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LOW_AMOUNT, (CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()));
            return false;
        }
        CoinsUser user = (CoinsUser)((CoinsEnginePlugin)this.plugin).getUserManager().getOrFetch(player);
        if (user.getBalance(from) < amount) {
            from.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LOW_BALANCE, (CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()).replace("%amount%", (Object)from.format(amount)));
            return false;
        }
        if (!from.canExchangeTo(to)) {
            from.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_NO_RATE, (CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()).replace("%name%", (Object)to.getName()));
            return false;
        }
        double result = from.getExchangeResult(to, amount);
        if (result <= 0.0) {
            from.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LOW_AMOUNT, (CommandSender)player, replacer -> replacer.replace(from.replacePlaceholders()));
            return false;
        }
        double newBalance = user.getBalance(to) + result;
        if (!to.isUnderLimit(newBalance)) {
            to.sendPrefixed(Lang.CURRENCY_EXCHANGE_ERROR_LIMIT_EXCEED, (CommandSender)player, replacer -> replacer.replace("%amount%", (Object)to.format(result)).replace("%max%", (Object)to.format(to.getMaxValue())));
            return false;
        }
        ExchangeOperation operation = new ExchangeOperation(from, amount, user, player, to);
        this.performOperation(operation);
        return true;
    }
}

