/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.currency.impl;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.Placeholders;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Config;
import su.nightexpress.coinsengine.config.Perms;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.language.entry.LangText;
import su.nightexpress.nightcore.language.message.LangMessage;
import su.nightexpress.nightcore.manager.AbstractFileData;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.number.CompactNumber;
import su.nightexpress.nightcore.util.placeholder.Replacer;

public class ConfigCurrency
extends AbstractFileData<CoinsEnginePlugin>
implements Currency {
    private String name;
    private String symbol;
    private String prefix;
    private String[] commandAliases;
    private String format;
    private String formatShort;
    private NightItem icon;
    private String dataColumn;
    private boolean dataSync;
    private boolean permissionRequired;
    private boolean decimal;
    private double startValue;
    private double maxValue;
    private boolean transferAllowed;
    private double minTransferAmount;
    private boolean vaultEconomy;
    private boolean exchangeAllowed;
    private boolean leaderboardEnabled;
    private final Map<String, Double> exchangeRates = new HashMap<String, Double>();

    public ConfigCurrency(@NotNull CoinsEnginePlugin plugin, @NotNull File file) {
        super((NightCorePlugin)plugin, file);
    }

    protected boolean onLoad(@NotNull FileConfig config) {
        this.setName((String)ConfigValue.create((String)"Name", (String)StringUtil.capitalizeUnderscored((String)this.getId()), (String[])new String[]{"Currency display name.", "https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setSymbol((String)ConfigValue.create((String)"Symbol", (String)this.name, (String[])new String[]{"Currency symbol.", "https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setPrefix((String)ConfigValue.create((String)"Prefix", (String)this.name, (String[])new String[]{"Currency prefix.", "https://nightexpressdev.com/nightcore/configuration/text-formation/", "https://nightexpressdev.com/coinsengine/features/prefix"}).read(config));
        this.setCommandAliases((String[])ConfigValue.create((String)"Command_Aliases", (String[])new String[]{this.getId()}, (String[])new String[]{"Currency command aliases. Split with comma.", "[*] Server reboot is required for the changes to apply.", "https://nightexpressdev.com/coinsengine/commands"}).read(config));
        this.setIcon((NightItem)ConfigValue.create((String)"Icon", (NightItem)NightItem.fromType((Material)Material.GOLD_NUGGET), (String[])new String[]{"Currency icon.", "https://nightexpressdev.com/nightcore/configuration/item-formation/"}).read(config));
        this.setFormat((String)ConfigValue.create((String)"Format", (String)"%amount%%currency_symbol%", (String[])new String[]{"Currency display format.", "Placeholders:", "- %amount% - Amount value.", "- Currency placeholders: https://nightexpressdev.com/coinsengine/placeholders", "- PlaceholderAPI placeholders that are NOT bound to a player (e.g. Oraxen or ItemsAdder %img% placeholders)", "https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setFormatShort((String)ConfigValue.create((String)"Format_Short", (String)"%currency_symbol%%amount%", (String[])new String[]{"Currency short display format.", "- %amount% - Amount value.", "- Currency placeholders: https://nightexpressdev.com/coinsengine/placeholders", "- PlaceholderAPI placeholders that are NOT bound to a player (e.g. Oraxen or ItemsAdder %img% placeholders)", "https://nightexpressdev.com/nightcore/configuration/text-formation/"}).read(config));
        this.setColumnName((String)ConfigValue.create((String)"Column_Name", (String)this.getId(), (String[])new String[]{"Database column name where this currency will be saved.", "https://nightexpressdev.com/coinsengine/features/cross-server"}).read(config));
        this.setSynchronizable((Boolean)ConfigValue.create((String)"Synchronized", (boolean)true, (String[])new String[]{"Controls whether currency is included in data synchronization.", "https://nightexpressdev.com/coinsengine/features/cross-server"}).read(config));
        this.setDecimal((Boolean)ConfigValue.create((String)"Decimal", (boolean)false, (String[])new String[]{"Controls whether decimal values are allowed for this currency."}).read(config));
        this.setPermissionRequired((Boolean)ConfigValue.create((String)"Permission_Required", (boolean)false, (String[])new String[]{"Controls whether permission is required for this currency.", "https://nightexpressdev.com/coinsengine/permissions"}).read(config));
        this.setTransferAllowed((Boolean)ConfigValue.create((String)"Transfer_Allowed", (boolean)true, (String[])new String[]{"Controls whether players can send this currency to other players."}).read(config));
        this.setMinTransferAmount((Double)ConfigValue.create((String)"Transfer_Min_Amount", (double)1.0, (String[])new String[]{"Min. amount to send this currency to other players.", "[*] Set to '-1' for no limit."}).read(config));
        this.setStartValue((Double)ConfigValue.create((String)"Start_Value", (double)0.0, (String[])new String[]{"Start currency value for new players."}).read(config));
        this.setMaxValue((Double)ConfigValue.create((String)"Max_Value", (double)-1.0, (String[])new String[]{"Max. possible value that players can have on their balance.", "[*] Set to '-1' to disable."}).read(config));
        this.setVaultEconomy((Boolean)ConfigValue.create((String)"Economy.Vault", (boolean)false, (String[])new String[]{"Controls whether currency will hook into Vault API to be registered as primary server economy provider.", "https://nightexpressdev.com/coinsengine/hooks/vault"}).read(config));
        this.setExchangeAllowed((Boolean)ConfigValue.create((String)"Exchange.Allowed", (boolean)true, (String[])new String[]{"Controls whether this currency can be exchanged for other ones.", "https://nightexpressdev.com/coinsengine/features/exchange"}).read(config));
        if (config.getSection("Exchange.Rates").isEmpty()) {
            config.set("Exchange.Rates.mystery_coins", (Object)5);
            config.set("Exchange.Rates.magic_coins", (Object)10);
        }
        config.getSection("Exchange.Rates").forEach(sId -> {
            double rate = config.getDouble("Exchange.Rates." + sId);
            this.exchangeRates.put(sId.toLowerCase(), rate);
        });
        this.leaderboardEnabled = (Boolean)ConfigValue.create((String)"Leaderboard.Enabled", (boolean)true, (String[])new String[]{"Controls whether this currency can have a leaderboard.", "[*] Requires the Tops module to be enabled.", "https://nightexpressdev.com/coinsengine/features/leaderboards"}).read(config);
        return true;
    }

    protected void onSave(@NotNull FileConfig config) {
        config.set("Name", (Object)this.name);
        config.set("Symbol", (Object)this.symbol);
        config.set("Prefix", (Object)this.prefix);
        config.set("Command_Aliases", (Object)String.join((CharSequence)",", Arrays.asList(this.commandAliases)));
        config.set("Format", (Object)this.format);
        config.set("Format_Short", (Object)this.formatShort);
        config.set("Icon", (Object)this.icon);
        config.set("Column_Name", (Object)this.dataColumn);
        config.set("Synchronized", (Object)this.dataSync);
        config.set("Permission_Required", (Object)this.permissionRequired);
        config.set("Decimal", (Object)this.decimal);
        config.set("Start_Value", (Object)this.startValue);
        config.set("Max_Value", (Object)this.maxValue);
        config.set("Transfer_Allowed", (Object)this.transferAllowed);
        config.set("Transfer_Min_Amount", (Object)this.minTransferAmount);
        config.set("Economy.Vault", (Object)this.vaultEconomy);
        config.set("Exchange.Allowed", (Object)this.exchangeAllowed);
        config.remove("Exchange.Rates");
        this.exchangeRates.forEach((id, rate) -> config.set("Exchange.Rates." + id, rate));
        config.set("Leaderboard.Enabled", (Object)this.leaderboardEnabled);
    }

    @Override
    @NotNull
    public UnaryOperator<String> replacePlaceholders() {
        return Placeholders.forCurrency(this);
    }

    @Override
    public void sendPrefixed(@NotNull LangText text, @NotNull CommandSender sender) {
        this.sendPrefixed(text, sender, null);
    }

    @Override
    public void sendPrefixed(@NotNull LangText text, @NotNull CommandSender sender, @Nullable Consumer<Replacer> consumer) {
        this.sendPrefixed(text.getMessage(), sender, consumer);
    }

    @Override
    public void sendPrefixed(@NotNull LangMessage message, @NotNull CommandSender sender) {
        this.sendPrefixed(message, sender, null);
    }

    @Override
    public void sendPrefixed(@NotNull LangMessage message, @NotNull CommandSender sender, @Nullable Consumer<Replacer> consumer) {
        if (((Boolean)Config.CURRENCY_PREFIX_ENABLED.get()).booleanValue()) {
            String prefix = (String)this.replacePlaceholders().apply((String)Config.CURRENCY_PREFIX_FORMAT.get());
            message = message.setPrefix(prefix);
        }
        message.send(sender, consumer);
    }

    @Override
    public boolean hasPermission(@NotNull Player player) {
        return !this.permissionRequired || player.hasPermission(this.getPermission()) || player.hasPermission((Permission)Perms.CURRENCY);
    }

    @Override
    public boolean isUnlimited() {
        return this.maxValue <= 0.0;
    }

    @Override
    public boolean isLimited() {
        return !this.isUnlimited();
    }

    @Override
    public boolean isInteger() {
        return !this.decimal;
    }

    @Override
    public boolean isUnderLimit(double value) {
        return this.isUnlimited() || value <= this.maxValue;
    }

    @Override
    public double floorIfNeeded(double amount) {
        return Math.max(0.0, this.decimal ? amount : Math.floor(amount));
    }

    @Override
    public double limitIfNeeded(double amount) {
        return this.isLimited() ? Math.min(amount, this.maxValue) : amount;
    }

    @Override
    public double floorAndLimit(double amount) {
        return this.floorIfNeeded(this.limitIfNeeded(amount));
    }

    @Override
    @NotNull
    public String getPermission() {
        return "coinsengine.currency." + this.getId();
    }

    @Override
    @NotNull
    public CompactNumber compacted(double balance) {
        return NumberUtil.asCompact((double)this.floorIfNeeded(balance));
    }

    @Override
    @NotNull
    public String formatValue(double balance) {
        return NumberUtil.format((double)this.floorIfNeeded(balance));
    }

    @Override
    @NotNull
    public String format(double balance) {
        return this.getFormatted(this.format, balance, this::formatValue);
    }

    @Override
    @NotNull
    public String formatCompact(double balance) {
        return this.getFormatted(this.formatShort, balance, value -> this.compacted((double)value).format());
    }

    @NotNull
    private String getFormatted(@NotNull String originalFormat, double balance, @NotNull Function<Double, String> valueFormatter) {
        if (Config.useCurrencyFormatPAPI()) {
            originalFormat = PlaceholderAPI.setPlaceholders(null, (String)originalFormat);
        }
        return ((String)this.replacePlaceholders().apply(originalFormat)).replace("%amount%", valueFormatter.apply(balance));
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(@NotNull String prefix) {
        this.prefix = prefix;
    }

    @Override
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(@NotNull String symbol) {
        this.symbol = symbol;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@NotNull String format) {
        this.format = format;
    }

    @Override
    @NotNull
    public String getFormatShort() {
        return this.formatShort;
    }

    @Override
    public void setFormatShort(@NotNull String formatShort) {
        this.formatShort = formatShort.replace("%currency_short_symbol%", "");
    }

    @Override
    @NotNull
    public String getColumnName() {
        return this.dataColumn;
    }

    @Override
    public void setColumnName(@NotNull String dataColumn) {
        this.dataColumn = dataColumn;
    }

    @Override
    @NotNull
    public String[] getCommandAliases() {
        return this.commandAliases;
    }

    @Override
    public void setCommandAliases(String[] commandAliases) {
        this.commandAliases = commandAliases;
    }

    @Override
    @Deprecated
    @NotNull
    public ItemStack getIcon() {
        return this.icon.getItemStack();
    }

    @Override
    @Deprecated
    public void setIcon(@NotNull ItemStack icon) {
        this.setIcon(NightItem.fromItemStack((ItemStack)icon));
    }

    @Override
    @NotNull
    public NightItem icon() {
        return this.icon.copy();
    }

    @Override
    public void setIcon(@NotNull NightItem icon) {
        this.icon = icon;
    }

    @Override
    public boolean isDecimal() {
        return this.decimal;
    }

    @Override
    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    @Override
    public boolean isSynchronizable() {
        return this.dataSync;
    }

    @Override
    public void setSynchronizable(boolean dataSync) {
        this.dataSync = dataSync;
    }

    @Override
    public boolean isPermissionRequired() {
        return this.permissionRequired;
    }

    @Override
    public void setPermissionRequired(boolean permissionRequired) {
        this.permissionRequired = permissionRequired;
    }

    @Override
    public boolean isTransferAllowed() {
        return this.transferAllowed;
    }

    @Override
    public void setTransferAllowed(boolean transferAllowed) {
        this.transferAllowed = transferAllowed;
    }

    @Override
    public double getMinTransferAmount() {
        return this.minTransferAmount;
    }

    @Override
    public void setMinTransferAmount(double minTransferAmount) {
        this.minTransferAmount = minTransferAmount;
    }

    @Override
    public double getStartValue() {
        return this.startValue;
    }

    @Override
    public void setStartValue(double startValue) {
        this.startValue = startValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean isVaultEconomy() {
        return this.vaultEconomy;
    }

    @Override
    public void setVaultEconomy(boolean vaultEconomy) {
        this.vaultEconomy = vaultEconomy;
    }

    @Override
    public boolean isExchangeAllowed() {
        return this.exchangeAllowed;
    }

    @Override
    public void setExchangeAllowed(boolean exchangeAllowed) {
        this.exchangeAllowed = exchangeAllowed;
    }

    @Override
    @NotNull
    public Map<String, Double> getExchangeRates() {
        return this.exchangeRates;
    }

    @Override
    public double getExchangeRate(@NotNull Currency currency) {
        return this.getExchangeRate(currency.getId());
    }

    @Override
    public double getExchangeRate(@NotNull String id) {
        return this.exchangeRates.getOrDefault(id.toLowerCase(), 0.0);
    }

    @Override
    public double getExchangeResult(@NotNull Currency other, double amount) {
        double rate = this.getExchangeRate(other);
        return other.floorIfNeeded(amount * rate);
    }

    @Override
    public boolean canExchangeTo(@NotNull Currency other) {
        return this.exchangeRates.containsKey(other.getId());
    }

    @Override
    public boolean isLeaderboardEnabled() {
        return this.leaderboardEnabled;
    }
}

