/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.coinsengine.hook.vault;

import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.coinsengine.CoinsEnginePlugin;
import su.nightexpress.coinsengine.api.currency.Currency;
import su.nightexpress.coinsengine.config.Lang;
import su.nightexpress.coinsengine.currency.CurrencyManager;
import su.nightexpress.coinsengine.currency.CurrencyOperations;
import su.nightexpress.coinsengine.data.impl.CoinsUser;
import su.nightexpress.coinsengine.user.BalanceLookup;

public class CurrencyEconomy
implements Economy {
    private static final EconomyResponse NO_BANKS = new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "CoinsEngine does not support bank accounts!");
    private final CoinsEnginePlugin plugin;
    private final CurrencyManager manager;
    private final Currency currency;

    public CurrencyEconomy(@NotNull CoinsEnginePlugin plugin, @NotNull Currency currency) {
        this.plugin = plugin;
        this.manager = plugin.getCurrencyManager();
        this.currency = currency;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return this.plugin.getName() + "_" + this.currency.getId();
    }

    public String format(double amount) {
        return this.currency.format(amount);
    }

    public int fractionalDigits() {
        return -1;
    }

    public String currencyNamePlural() {
        return this.currency.getName();
    }

    public String currencyNameSingular() {
        return this.currency.getName();
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return false;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer player) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        return this.getBalance(user);
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(String playerName) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        return this.getBalance(user);
    }

    private double getBalance(@Nullable CoinsUser user) {
        return user == null ? 0.0 : user.getBalance(this.currency);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.plugin.getDataHandler().isUserExists(player.getUniqueId());
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(String playerName) {
        return this.plugin.getDataHandler().isUserExists(playerName);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        return this.has(user, amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(String playerName, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        return this.has(user, amount);
    }

    private boolean has(@Nullable CoinsUser user, double amount) {
        return user != null && user.hasEnough(this.currency, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        return this.depositUser(user, amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        return this.depositUser(user, amount);
    }

    @NotNull
    private EconomyResponse depositUser(@Nullable CoinsUser user, double amount) {
        if (user == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INVALID_PLAYER.getLegacy());
        }
        if (!this.manager.canPerformOperations()) {
            return new EconomyResponse(amount, user.getBalance(this.currency), EconomyResponse.ResponseType.FAILURE, "Operations are not available at this time.");
        }
        this.manager.performOperation(CurrencyOperations.forAddSilently(this.currency, amount, user));
        return new EconomyResponse(amount, user.getBalance(this.currency), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(player.getUniqueId());
        return this.withdrawUser(user, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        CoinsUser user = (CoinsUser)this.plugin.getUserManager().getOrFetch(playerName);
        return this.withdrawUser(user, amount);
    }

    @NotNull
    private EconomyResponse withdrawUser(@Nullable CoinsUser user, double amount) {
        if (user == null) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INVALID_PLAYER.getLegacy());
        }
        BalanceLookup lookup = user.balanceLookup(this.currency);
        if (!user.hasEnough(this.currency, amount)) {
            return new EconomyResponse(amount, lookup.balance(), EconomyResponse.ResponseType.FAILURE, Lang.ECONOMY_ERROR_INSUFFICIENT_FUNDS.getLegacy());
        }
        if (!this.manager.canPerformOperations()) {
            return new EconomyResponse(amount, user.getBalance(this.currency), EconomyResponse.ResponseType.FAILURE, "Operations are not available at this time.");
        }
        this.manager.performOperation(CurrencyOperations.forRemoveSilently(this.currency, amount, user));
        return new EconomyResponse(amount, lookup.balance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse createBank(String name, String player) {
        return NO_BANKS;
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return NO_BANKS;
    }

    public EconomyResponse deleteBank(String name) {
        return NO_BANKS;
    }

    public EconomyResponse bankHas(String name, double amount) {
        return NO_BANKS;
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return NO_BANKS;
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return NO_BANKS;
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return NO_BANKS;
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return NO_BANKS;
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return NO_BANKS;
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return NO_BANKS;
    }

    public EconomyResponse bankBalance(String name) {
        return NO_BANKS;
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    public boolean hasBankSupport() {
        return false;
    }
}

